<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
load_helpers(array('defaults', 'ressources')) ?>

<div class="main">
    <form action="<?php echo get_back_uri('configuration') ?>" method="post" class="ajaxify">

        <fieldset>
            <legend><?php echo __('LblConfigServerTitle') ?></legend>
            <p class="hide">
                <?php echo get_session_token_tag() ?>
            </p>
            <p>
                <label for="configuration_server_base_url"><?php echo __('LblConfigBaseUrl') ?></label>
                <input
                    type="text"
                    class="long"
                    id="configuration_server_base_url"
                    name="configuration[server][base_url]"
                    value="<?php echo _htmlentities(get_configuration('server/base_url')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigBaseUrl') ?></span>
            </p>
            <p>
                <label for="configuration_server_url_rewriting"><?php echo __('LblConfigUrlRewriting') ?></label>
                <?php $b_url_rewriting = get_configuration('server/url_rewriting', false);  ?>
                <input
                    type="checkbox"
                    id="configuration_server_url_rewriting"
                    name="configuration[server][url_rewriting]"<?php echo $b_url_rewriting ? ' checked="checked"' : '' ?> />
                <span class="x-help"><?php echo __('HelpConfigUrlRewriting') ?></span>
            </p>
            <p>
                <label for="configuration_server_page_var_name"><?php echo __('LblConfigVariablePageName') ?></label>
                <input
                    type="text"
                    id="configuration_server_page_var_name"
                    name="configuration[server][page_var_name]"
                    value="<?php echo _htmlentities(get_configuration('server/page_var_name', 'p')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigVariablePageName') ?></span>
            </p>
            <p>
                <label><?php echo __('LblConfigRootDir') ?></label>
                <?php $s_server_base_dir = get_configuration('server/base_dir'); ?>
                <span class="checkbox-group">
                    <label for="configuration_server_base_dir_root" class="no-help"><?php echo __('root') ?></label>
                    <input
                        type="radio"
                        value="/"
                        name="configuration[server][base_dir]"
                        id="configuration_server_base_dir_root"<?php echo ('/' == $s_server_base_dir ? ' checked="checked"' : '') ?> />

                    <label for="configuration_server_base_dir_web" class="no-help">web</label>
                    <input
                        type="radio"
                        value="web"
                        name="configuration[server][base_dir]"
                        id="configuration_server_base_dir_web"<?php echo ('/' == $s_server_base_dir ? '' : ' checked="checked"') ?> />
                </span>
                <span class="x-help"><?php echo __('HelpConfigRootDir') ?></span>
            </p>
            <p>
                <label for="configuration_server_filesize"><?php echo __('LblConfigUploadFileSize') ?></label>
                <input
                    type="text"
                    id="configuration_server_filesize"
                    name="configuration[server][filesize]"
                    value="<?php echo get_configuration('server/filesize', 3000000) ?>" />
                <span class="x-help"><?php echo __('HelpConfigUploadFileSize') ?></span>
            </p>
            <p>
                <label for="configuration_server_filemode"><?php echo __('LblConfigFileMode') ?></label>
                <input
                    type="text"
                    id="configuration_server_filemode"
                    name="configuration[server][filemode]"
                    value="<?php echo get_configuration('server/filemode', 666) ?>" />
                <span class="x-help"><?php echo __('HelpConfigFileMode') ?></span>
            </p>
            <p>
                <label for="configuration_server_dirmode"><?php echo __('LblConfigDirMode') ?></label>
                <input
                    type="text"
                    id="configuration_server_dirmode"
                    name="configuration[server][dirmode]"
                    value="<?php echo get_configuration('server/dirmode', 777) ?>" />
                <span class="x-help"><?php echo __('HelpConfigDirMode') ?></span>
            </p>
        </fieldset>

        <fieldset>
            <legend><?php echo __('LblConfigSiteParameters') ?></legend>
            <p>
                <label for="configuration_misc_site_title"><?php echo __('LblConfigSiteTitle') ?></label>
                <input
                    type="text"
                    class="long"
                    id="configuration_misc_site_title"
                    name="configuration[misc][site][title]"
                    value="<?php echo _htmlentities(get_configuration('misc/site/title')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigSiteTitle') ?></span>
            </p>
            <p>
                <label for="configuration_misc_site_title_format"><?php echo __('LblConfigTitleFormat') ?></label>
                <input
                    type="text"
                    class="x-long"
                    id="configuration_misc_site_title_format"
                    name="configuration[misc][site][title_format]"
                    value="<?php echo _htmlentities(get_configuration('misc/site/title_format', '%site-title% - %page-title%')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigTitleFormat') ?></span>
            </p>
            <p>
                <label for="configuration_misc_images_name_format"><?php echo __('LblConfigImgNameFormat') ?></label>
                <input
                    type="text"
                    class="x-long"
                    id="configuration_misc_images_name_format"
                    name="configuration[misc][images][name_format]"
                    value="<?php echo _htmlentities(get_configuration('misc/images/name_format', '%title%-%date%')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigImgNameFormat') ?></span>
            </p>
            <p>
                <label for="configuration_misc_images_thumb_width"><?php echo __('LblConfigThumbWidth') ?></label>
                <input
                    type="text"
                    id="configuration_misc_images_thumb_width"
                    name="configuration[misc][images][thumb_width]"
                    value="<?php echo _htmlentities(get_configuration('misc/images/thumb_width', '100')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigThumbWidth') ?></span>
            </p>
            <p>
                <label for="configuration_misc_images_thumb_height"><?php echo __('LblConfigThumbHeight') ?></label>
                <input
                    type="text"
                    id="configuration_misc_images_thumb_height"
                    name="configuration[misc][images][thumb_height]"
                    value="<?php echo _htmlentities(get_configuration('misc/images/thumb_height', '100')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigThumbHeight') ?></span>
            </p>
            <p>
                <label for="configuration_misc_documents_name_format"><?php echo __('LblConfigDocNameFormat') ?></label>
                <input
                    type="text"
                    class="x-long"
                    id="configuration_misc_documents_name_format"
                    name="configuration[misc][documents][name_format]"
                    value="<?php echo _htmlentities(get_configuration('misc/documents/name_format', '%title%-%date%')) ?>" />
                <span class="x-help"><?php echo __('HelpConfigDocNameFormat') ?></span>
            </p>
        </fieldset>

        <fieldset>
            <legend><?php echo __('LblConfigPages') ?></legend>
            <p>
                <label for="configuration_pages_default_extension"><?php echo __('LblConfigPagesExtension') ?></label>
                <select
                    id="configuration_pages_default_extension"
                    name="configuration[pages][default_extension]">
                    <?php $s_page_default_extension = get_configuration('pages/default_extension') ?>
                    <?php foreach (array('', 'html', 'xml', 'php') as $s_default_extension) : ?>
                        <option value="<?php echo $s_default_extension ?>"<?php echo ($s_default_extension === $s_page_default_extension) ? ' selected="selected"' : '' ?>><?php echo $s_default_extension ?></option>
                    <?php endforeach ?>
                </select>
                <span class="x-help"><?php echo __('HelpConfigPagesExtension') ?></span>
            </p>
            <p>
                <label for="configuration_pages_default_layout"><?php echo __('LblConfigLayout') ?></label>
                <?php echo get_layout_select(get_configuration('pages/default_layout'), array('id' => 'configuration_pages_default_layout', 'name' => 'configuration[pages][default_layout]')) ?>
                <span class="x-help"><?php echo __('HelpConfigLayout') ?></span>
            </p>
            <p>
                <label for="configuration_pages_default_doctype"><?php echo __('LblConfigDoctype') ?></label>
                <select
                    id="configuration_pages_default_doctype"
                    name="configuration[pages][default_doctype]">
                    <?php $s_page_default_doctype = get_configuration('pages/default_doctype', 'xhtml-1.0-strict') ?>
                    <?php foreach (array('xhtml-1.0-strict' => __('LblDoctypeXhtml1.0Strict'), 'xhtml-1.0-transitional' => __('LblDoctypeXhtml1.0Transitional')) as $s_doctype => $s_label) : ?>
                        <option value="<?php echo $s_doctype ?>"<?php echo ($s_page_default_doctype === $s_doctype) ? ' selected="selected"' : '' ?>><?php echo $s_label ?></option>
                    <?php endforeach ?>
                </select>
                <span class="x-help"><?php echo __('HelpConfigDoctype') ?></span>
            </p>
            <p>
                <label for="configuration_pages_default_css"><?php echo __('LblConfigCss') ?></label>
                <span class="form-block">
                    <?php echo get_css_select(get_configuration('pages/default_css'),
                                             array('id' => 'configuration_pages_default_css', 'name' => 'configuration[pages][default_css]', 'class' => 'x-long', 'cols' => 50, 'rows' => 2),
                                             array('id' => 'configuration_pages_default_css_list', 'name' => 'css_list', 'class' => 'x-long', 'cols' => 50, 'rows' => 2)) ?>
                </span>
                <span class="x-help"><?php echo __('HelpConfigCss') ?></span>
            </p>
            <p>
                <label for="configuration_pages_default_js"><?php echo __('LblConfigJs') ?></label>
                <span class="form-block">
                    <?php echo get_js_select(get_configuration('pages/default_js'),
                                             array('id' => 'configuration_pages_default_js', 'name' => 'configuration[pages][default_js]', 'class' => 'x-long', 'cols' => 50, 'rows' => 2),
                                             array('id' => 'configuration_pages_default_js_list', 'name' => 'js_list', 'class' => 'x-long', 'cols' => 50, 'rows' => 2)) ?>
                </span>
                <span class="x-help"><?php echo __('HelpConfigJs') ?></span>
            </p>
        </fieldset>

        <fieldset>
            <legend><?php echo __('LblAdminArea') ?></legend>
            <p>
                <label for="configuration_administration_route"><?php echo __('LblAdminAreaRoute') ?></label>
                <input
                    type="text"
                    class="long"
                    id="configuration_administration_route"
                    name="configuration[administration][route]"
                    value="<?php echo _htmlentities(get_configuration('administration/route')) ?>" />
                <span class="x-help"><?php echo __('HelpAdminAreaRoute') ?></span>
            </p>
            <p>
                <label for="configuration_administration_is_secure"><?php echo __('LblAdminAreaIsSecure') ?></label>
                <input
                    type="checkbox"
                    id="configuration_administration_is_secure"
                    name="configuration[administration][is_secure]"
                    <?php echo get_configuration('administration/is_secure') ? ' checked="checked"' : '' ?> />
                <span class="x-help"><?php echo __('HelpAdminAreaIsSecure') ?></span>
            </p>
        </fieldset>

        <p>
            <button
                type="submit"
                class="ico ico-save text-button-ico"
                id="action_save"
                name="action" value="save"><?php echo __('BtSave') ?></button>
            <button
                type="reset"
                class="ico ico-cancel text-button-ico"
                id="action_cancel"
                name="action" value="cancel"><?php echo __('BtCancel') ?></button>
        </p>
    </form>
</div>