<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php load_helpers(array('ressources')) ?>

<?php $b_has_page = isset($a_page) ?>

<?php if ($b_has_page) : ?>
    <h2 id="ui-page-title"><?php echo __('LblEditEditTitle', $a_page['title']) ?><?php if ($a_page['is_draft']) : ?> (<?php echo __('LblEditDraftMode') ?>) <?php endif ?></h2>
<?php else : ?>
    <h2 id="ui-page-title"><?php echo __('LblEditEditTitleNoPage') ?></h2>
<?php endif ?>


<?php if ($b_has_page && is_array($a_page['locked'])) : ?>
    <p id="ui-page-locked" class="ico ico-lock"><?php echo __('LblEditLockedBy',  $a_page['locked']['firstname'] .' '. $a_page['locked']['lastname'].' (' .$a_page['locked']['id'] . ')') ?></p>
<?php endif ?>

<div class="main">

<?php if ($b_has_page) : ?>
<form action="<?php echo get_back_uri('edit', ($b_has_page ? array('id' => $a_page['id']) : array())) ?>" method="post" class="ajaxify" id="edit">
    <p class="hide">
        <?php echo get_session_token_tag() ?>
        <input type="hidden" id="type" name="type" value="<?php echo $a_page['is_draft'] ? 'draft' : '' ?>" />

        <input type="hidden" id="page_id" name="page[id]" value="<?php echo $a_page['id'] ?>" />
        <input type="hidden" id="page_parent_id" name="page[parent_id]" value="<?php echo $a_page['parent_id'] ?>" />
        <input type="hidden" id="page_state" name="page[state]" value="<?php echo $a_page['state'] ?>" />
        <input type="hidden" id="page_type" name="page[type]" value="<?php echo $a_page['type'] ?>" />

        <?php if ('xml' === $a_page['type']) : ?>
            <input type="hidden" id="page_doctype" name="page[doctype]" value="<?php echo $a_page['doctype'] ?>" />
        <?php endif ?>
        <?php if ('php' !== $a_page['type']) : ?>
            <input type="hidden" id="page_type_mime" name="page[type_mime]" value="<?php echo $a_page['type_mime'] ?>" />
        <?php endif ?>

        <?php if (!isset($a_page['locked']) || !is_array($a_page['locked'])) : ?>
            <input type="hidden" id="page_locked" name="page[locked]" value="0" />
        <?php else : ?>
            <input type="hidden" id="page_locked_id" name="page[locked][id]" value="<?php echo $a_page['locked']['id'] ?>" />
            <input type="hidden" id="page_locked_firstname" name="page[locked][firstname]" value="<?php echo $a_page['locked']['firstname'] ?>" />
            <input type="hidden" id="page_locked_lastname" name="page[locked][lastname]" value="<?php echo $a_page['locked']['lastname'] ?>" />
        <?php endif ?>

        <input type="hidden" id="page_dates_creation" name="page[dates][creation]" value="<?php echo isset($a_page['dates']['creation']) ? $a_page['dates']['creation'] : time() ?>" />
        <input type="hidden" id="page_dates_modification" name="page[dates][modification]" value="<?php echo isset($a_page['dates']['modification']) ? $a_page['dates']['modification'] : time() ?>" />
        <input type="hidden" id="page_redirection" name="page[redirection]" value="<?php echo $a_page['redirection'] ?>" />
    </p>

    <fieldset>
        <legend><?php echo __('LblEditGeneralsInformations') ?></legend>
        <p>
            <label for="page_title"><?php echo __('LblEditTitle') ?></label>
            <input
                type="text"
                id="page_title"
                name="page[title]"
                class="long"
                value="<?php echo _htmlentities($a_page['title']) ?>" />
            <span class="x-help"><?php echo __('HelpEditTitle') ?></span>
        </p>
        <?php if (!$a_page['is_root']) : ?>
        <p>
            <label for="page_slug"><?php echo __('LblEditSlug') ?></label>
            <input
                type="text"
                id="page_slug"
                name="page[slug]"
                class="long"
                value="<?php echo _htmlentities($a_page['slug']) ?>"<?php echo ($a_page['is_draft'] ? ' disabled="disabled"' : '') ?>/>
            <span class="x-help"><?php echo __('HelpEditSlug') ?></span>
        </p>
        <?php else : ?>
            <input type="hidden" id="page_slug" name="page[slug]" value="" />
        <?php endif ?>
        <p>
            <label><?php echo __('LblEditRoute') ?></label>
            <span id="page_route">
                <?php if ($a_page['is_draft']) : ?>
                    <a href="<?php echo get_back_uri('page_preview', array('view' => $a_page['id'], 'type' => 'draft')) ?>" title="<?php echo __('LblEditRoutePreview') ?>" rel="external"><?php echo __('LblEditRoutePreview') ?></a>
                <?php else : ?>
                    <?php if (STRUCTURE_STATE_VISIBLE === intval($a_page['state']) && ('' == $a_page['redirection'])) : ?>
                        <?php if (false !== ($s_url = get_front_uri($a_page['id']))) : ?>
                            <a href="<?php echo $s_url ?>" title="<?php echo __('LblEditRouteShow') ?>" rel="external"><?php echo $s_url ?></a>
                        <?php else : ?>
                            <?php echo __('LblEditNoRoute') ?>
                        <?php endif ?>
                    <?php else : ?>
                        <a href="<?php echo get_back_uri('page_preview', array('view' => $a_page['id'])) ?>" title="<?php echo __('LblEditRoutePreview') ?>" rel="external"><?php echo __('LblEditRoutePreview') ?></a>
                    <?php endif ?>
                <?php endif ?>
            </span>
            <span class="x-help"><?php echo __('HelpEditRoute') ?></span>
        </p>
        <p>
            <label for="page_cache"><?php echo __('LblEditCacheTime') ?></label>
            <input
                type="text"
                id="page_cache"
                name="page[cache]"
                class="middle"
                value="<?php echo $a_page['cache'] ?>"<?php echo ($a_page['is_draft'] ? ' disabled="disabled"' : '') ?> />
            <span class="x-help"><?php echo __('HelpEditCacheTime') ?></span>
        </p>
        <p>
            <label for="page_layout"><?php echo __('LblEditLayout') ?></label>
            <?php echo get_layout_select($a_page['layout'], array('id' => 'page_layout', 'name' => 'page[layout]')) ?>
            <span class="x-help"><?php echo __('HelpEditLayout') ?></span>
        </p>
        <?php if ('xml' !== $a_page['type']) : ?>
            <p<?php echo ('php' === $a_page['type'] && 'xml' === $a_page['type_mime']) ? ' class="hide"' : '' ?>>
                <label for="page_doctype"><?php echo __('LblEditDoctype') ?></label>
                <select
                    id="page_doctype"
                    name="page[doctype]">
                    <?php foreach (array('xhtml-1.0-strict' => __('LblDoctypeXhtml1.0Strict'), 'xhtml-1.0-transitional' => __('LblDoctypeXhtml1.0Transitional')) as $s_doctype => $s_label) : ?>
                        <option value="<?php echo $s_doctype ?>"<?php echo ($a_page['doctype'] === $s_doctype) ? ' selected="selected"' : '' ?>><?php echo $s_label ?></option>
                    <?php endforeach ?>
                </select>
                <span class="x-help"><?php echo __('HelpEditDoctype') ?></span>
            </p>
        <?php endif ?>
        <?php if ('php' === $a_page['type']) : ?>
            <p>
                <label for="page_type_mime"><?php echo __('LblEditTypeMime') ?></label>
                <select
                    id="page_type_mime"
                    name="page[type_mime]">
                    <?php foreach (array('xhtml' => 'xhtml', 'xml' => 'xml', '' => '' ) as $s_type => $s_label) : ?>
                        <option value="<?php echo $s_type ?>"<?php echo ($a_page['type_mime'] === $s_type) ? ' selected="selected"' : '' ?>><?php echo $s_label ?></option>
                    <?php endforeach ?>
                </select>
                <span class="x-help"><?php echo __('HelpEditTypeMime') ?></span>
            </p>
        <?php endif ?>
    </fieldset>

    <?php if ('php' != $a_page['type'] || USER_ADMIN == get_user_property('rights')) : ?>
        <fieldset>
            <legend><?php echo __('LblEditContents') ?></legend>
            <div>
                <input
                    type="hidden"
                    name="ui-editor-config"
                    value="css:<?php echo implode(',', $a_page['css_files']) ?>;doctype:<?php echo $a_page['doctype'] ?>;html_classes:beCms<?php
                        if ('' != $a_page['body_id']) echo ';body_id:' . $a_page['body_id'] ?><?php
                        echo ';body_classes:' . ('' != $a_page['body_classes'] ? $a_page['body_classes'] . ' beCms' : 'beCms') ?>" />
                <textarea
                    id="page_content"
                    name="page[content]"
                    class="no-float ui-editor-<?php echo $a_page['type'] ?>"
                    style="width: 100%"
                    cols="50" rows="25"><?php echo _htmlentities($a_page['content']) ?></textarea>
            </div>
        </fieldset>
    <?php endif ?>

    <?php if (in_array($a_page['type'], array('html', 'php'))) : ?>

    <fieldset>
        <legend><?php echo __('LblEditMetadataProperties') ?></legend>
        <p>
            <label for="page_metadata_description"><?php echo __('LblEditMetadataDescription') ?></label>
            <textarea
                id="page_metadata_description"
                class="x-long"
                name="page[metadata][description]"
                cols="50" rows="2"><?php echo _htmlentities($a_page['metadata']['description']) ?></textarea>
            <span class="x-help"><?php echo __('HelpEditMetadataDescription') ?></span>
        </p>
        <p>
            <label for="page_metadata_keywords"><?php echo __('LblEditMetadataKeywords') ?></label>
            <textarea
                id="page_metadata_keywords"
                class="x-long"
                name="page[metadata][keywords]"
                cols="50" rows="2"><?php echo _htmlentities($a_page['metadata']['keywords']) ?></textarea>
            <span class="x-help"><?php echo __('HelpEditMetadataKeywords') ?></span>
        </p>
        <p>
            <label for="page_body_id"><?php echo __('LblEditBodyId') ?></label>
            <input
                type="text"
                id="page_body_id"
                name="page[body_id]"
                class="long"
                value="<?php echo _htmlentities($a_page['body_id']) ?>" />
            <span class="x-help"><?php echo __('HelpEditBodyId') ?></span>
        </p>
        <p>
            <label for="page_body_classes"><?php echo __('LblEditBodyClasses') ?></label>
            <input
                type="text"
                id="page_body_classes"
                name="page[body_classes]"
                class="long"
                value="<?php echo _htmlentities($a_page['body_classes']) ?>" />
            <span class="x-help"><?php echo __('HelpEditBodyClasses') ?></span>
        </p>
    </fieldset>

    <fieldset>
        <legend><?php echo __('LblEditExternalsFiles') ?></legend>
        <p>
            <label for="page_css_files"><?php echo __('LblEditCssFiles') ?></label>
            <span class="form-block">
                <?php echo get_css_select(implode(';', $a_page['css_files']),
                                          array('id' => 'page_css_files', 'name' => 'page[css_files]', 'class' => 'x-long', 'cols' => 50, 'rows' => 2),
                                          array('id' => 'page_css_list', 'name' => 'page[css_list]', 'class' => 'x-long', 'cols' => 50, 'rows' => 2)) ?>
            </span>
            <span class="x-help"><?php echo __('HelpEditCssFiles') ?></span>
        </p>
        <p>
            <label for="page_js_files"><?php echo __('LblEditJsFiles') ?></label>
            <span class="form-block">
                <?php echo get_js_select(implode(';', $a_page['js_files']),
                                          array('id' => 'page_js_files', 'name' => 'page[js_files]', 'class' => 'x-long', 'cols' => 50, 'rows' => 2),
                                          array('id' => 'page_js_list', 'name' => 'page[js_list]', 'class' => 'x-long', 'cols' => 50, 'rows' => 2)) ?>
            </span>
            <span class="x-help"><?php echo __('HelpEditJsFiles') ?></span>
        </p>
    </fieldset>

    <?php endif ?>
<?php endif ?>

    <div class="section">
        <p class="legend"><?php echo __('LblEditPagesList') ?></p>
        <?php include_view('edit_treeview', array('s_current_id' => $b_has_page ? $a_page['id'] : null)) /*get_structure_pages_treeview($b_has_page ? $a_page['id'] : null)*/ ?>
    </div>

<?php if ($b_has_page) : ?>
    <p id="ui-page-actions" class="buttons">
        <?php include_view('edit_buttons') ?>
    </p>
    </form>
<?php endif ?>
</div>