<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php $b_edit_mode = isset($a_edit) ?>

<?php if ($b_edit_mode) : ?>
    <?php if (!$b_is_ajax) : ?>
        <div class="nav">
            <ul>
                <li class="active"><a href="#" title="<?php echo __('LblEdit') ?>"><?php echo __('LblEdit') ?></a></li>
                <li><a href="<?php echo get_back_uri('files', array('action' => 'list')) ?>" title="<?php echo __('LblFilesPageTitle') ?>"><?php echo __('LblFilesPageTitle') ?></a></li>
            </ul>
        </div>

        <div class="main">
    <?php endif ?>

    <?php $s_type = ucfirst($a_edit['type']) ?>
    <form action="<?php echo get_back_uri('files') ?>" method="post" class="ajaxify">
        <fieldset>
            <legend><?php echo __('LblFiles'.ucfirst($a_edit['type']).'Edit', $a_edit['title']) ?></legend>
            <p>
                <?php echo get_session_token_tag(true) ?>
                <input type="hidden" name="type" value="<?php echo $a_edit['type'] ?>" />
                <input type="hidden" id="file_id" name="id" value="<?php echo $a_edit['name'] ?>" />

                <label for="file_title"><?php echo __('LblFiles'.$s_type.'Title') ?></label>
                <input type="text" value="<?php echo _htmlentities($a_edit['title']) ?>" id="file_title" name="file[title]" class="long"/>
                <span class="x-help"><?php echo __('HelpFiles'.$s_type.'Title') ?></span>
            </p>
            <p class="v-space"></p>
            <p>
                <label><?php echo __('LblFiles'.$s_type.'Url') ?></label>
                <span>
                    <a href="<?php echo 'http://'.get_configuration('server/base_uri_ressources_path').$a_edit['url'] ?>" title="<?php echo __('LblShow') ?>" rel="external"><?php echo 'http://'.get_configuration('server/base_uri_ressources_path').$a_edit['url'] ?></a>
                </span>
                <span class="x-help"><?php echo __('HelpFiles'.$s_type.'Url') ?></span>
            </p>

            <?php if ('image' == $a_edit['type']) : ?>
                <p>
                    <label><?php echo __('LblFilesImageHasThumb') ?> :</label>
                    <span><?php echo '' != $a_edit['thumbnail_url'] && $a_edit['thumbnail_url'] ? __('LblYes') : __('LblNo') ?></span>
                    <span class="x-help"><?php echo __('HelpFilesImageHasThumb') ?></span>
                </p>
                <p class="v-space"></p>
                <p>
                    <label><?php echo __('LblFilesImage') ?></label>
                    <span>
                        <a href="<?php echo 'http://'.get_configuration('server/base_uri_ressources_path').$a_edit['url'] ?>" title="voir" rel="external">
                            <img src="<?php echo 'http://'.get_configuration('server/base_uri_ressources_path').$a_edit['url'] ?>" title="<?php echo _htmlentities($a_edit['title']) ?>" alt="" />
                        </a>
                    </span>
                    <span class="x-help"><?php echo __('HelpFilesImage') ?></span>
                </p>
            <?php endif ?>

            <p class="v-space"></p>
            <p class="buttons">
                <label><?php echo __('LblActions') ?> :</label>
                <span>
                    <button id="action" class="ico ico-save text-button-ico" title="Enregistrer" value="modify" name="action" type="submit">Enregistrer</button>
                    <button type="reset" class="ico ico-cancel text-button-ico" title="<?php echo __('BtCancel') ?>"><?php echo __('BtCancel') ?></button>
                </span>
                <span class="x-help"><?php echo __('HelpActions') ?></span>
            </p>
        </fieldset>
    </form>

    <?php if (!$b_is_ajax): ?>
        </div>
    <?php endif ?>

<?php else : ?>

    <div class="main">
        <div class="section">
            <p class="legend"><?php echo __('LblFilesDocuments') ?></p>

            <form action="<?php echo get_back_uri('files') ?>" enctype="multipart/form-data" method="post">
                <p>
                    <?php echo get_session_token_tag(true) ?>
                    <input type="hidden" name="MAX_FILE_SIZE" value="<?php echo get_configuration('server/filesize', 3000000) ?>" />
                    <input type="hidden" name="type" value="document" />

                    <label for="files_new_document_file"><?php echo __('LblFilesAddDocument') ?></label>
                    <input
                        type="file"
                        class="long"
                        id="files_new_document_file"
                        name="files[file]" />
                    <span class="x-help"><?php echo __('HelpFilesAddDocument') ?></span>
                </p>
                <p>
                    <label for="files_new_document_title"><?php echo __('LblFilesDocumentTitle') ?></label>
                    <input
                        type="text"
                        class="long"
                        id="files_new_document_title"
                        name="files[title]"
                        value="<?php echo _htmlentities($a_new_files['new_document']['title']) ?>" />
                    <span class="x-help"><?php echo __('HelpFilesDocumentTitle') ?></span>
                </p>

                <p>
                    <label for="files_new_document_dir"><?php echo __('LblFilesDocumentDir') ?></label>
                    <select id="files_new_document_dir" name="files[dir]">
                        <?php foreach ($a_dirs['documents'] as $s_id => $s_doc_dir) : ?>
                            <option value="<?php echo $s_id ?>"<?php if ($s_id === $a_list_dirs['documents']) echo ' selected="selected"' ?>><?php echo $s_doc_dir ?></option>
                        <?php endforeach ?>
                    </select>
                    <button id="files_new_document_delete_dir" class="ico ico-delete image-button-ico ajaxify" title="<?php echo __('LblDelete') ?>" value="delete_dir" name="action" type="submit"><?php echo __('LblDelete') ?></button>
                    <span class="x-help"><?php echo __('HelpFilesDocumentDir') ?></span>
                </p>
                <p>
                    <label for="files_new_document_new_dir"><?php echo __('LblFileDocumentNewDir') ?></label>
                    <input
                        type="text"
                        class="long"
                        id="files_new_document_new_dir"
                        name="files[new_dir]"
                        value="<?php echo _htmlentities($a_new_files['new_document']['new_dir']) ?>" />
                    <span class="x-help"><?php echo __('HelpFileDocumentNewDir') ?></span>
                </p>

                <p class="buttons">
                    <button
                        type="submit"
                        class="ico ico-save text-button-ico"
                        id="action_save_document"
                        title="<?php echo __('BtSave') ?>"
                        name="action" value="save"><?php echo __('BtSave') ?></button>
                    <button
                        type="reset"
                        class="ico ico-cancel text-button-ico ajaxify"
                        id="action_cancel_document"
                        title="<?php echo __('BtCancel') ?>"
                        name="action" value="cancel"><?php echo __('BtCancel') ?></button>
                </p>

            </form>

            <hr />

            <form action="<?php echo get_back_uri('files') ?>" method="post" class="ajaxify">
                <p>
                    <?php echo get_session_token_tag(true) ?>
                    <input type="hidden" name="type" value="documents" />
                    <label for="files_document_list_dir" class="small-label"><?php echo __('LblFilesDocumentDir') ?></label>
                    <select id="files_document_list_dir" name="documents_list_dir">
                        <?php foreach ($a_dirs['documents'] as $s_id => $s_img_dir) : ?>
                            <option value="<?php echo $s_id ?>"<?php if ($s_id === $a_list_dirs['documents']) echo ' selected="selected"' ?>><?php echo $s_img_dir ?></option>
                        <?php endforeach ?>
                    </select>
                    <button id="files_document_list_dir_submit" type="submit" class="ico ico-save image-button-ico" name="action" value="list" title="<?php echo __('LblFilesImageListDir') ?>"><?php echo __('LblFilesImageListDir') ?></button>
                    <span class="x-help"><?php echo __('HelpFilesImageDirShow') ?></span>
                </p>
            </form>

            <?php include_view('files_documents') ?>

        </div>

        <div class="section">
            <p class="legend"><?php echo __('LblFilesImages') ?></p>

            <form action="<?php echo get_back_uri('files') ?>" enctype="multipart/form-data" method="post">
                <p>
                    <?php echo get_session_token_tag(true) ?>
                    <input type="hidden" name="MAX_FILE_SIZE" value="<?php echo get_configuration('server/filesize', 3000000) ?>" />
                    <input type="hidden" name="type" value="image" />

                    <label for="files_new_image_file"><?php echo __('LblFilesAddImage') ?></label>
                    <input
                        type="file"
                        class="long"
                        id="files_new_image_file"
                        name="files[file]" />
                    <span class="x-help"><?php echo __('HelpFilesAddImage') ?></span>
                </p>
                <p>
                    <label for="files_new_image_title"><?php echo __('LblFilesImageTitle') ?></label>
                    <input
                        type="text"
                        class="long"
                        id="files_new_image_title"
                        name="files[title]"
                        value="<?php echo _htmlentities($a_new_files['new_image']['title']) ?>"/>
                    <span class="x-help"><?php echo __('HelpFilesImageTitle') ?></span>
                </p>

                <p>
                    <label for="files_new_image_dir"><?php echo __('LblFilesImageDir') ?></label>
                    <select id="files_new_image_dir" name="files[dir]">
                        <?php foreach ($a_dirs['images'] as $s_id => $s_img_dir) : ?>
                            <option value="<?php echo $s_id ?>"<?php if ($s_id === $a_list_dirs['images']) echo ' selected="selected"' ?>><?php echo $s_img_dir ?></option>
                        <?php endforeach ?>
                    </select>
                    <button id="files_new_image_delete_dir" class="ico ico-delete image-button-ico ajaxify" title="<?php echo __('LblDelete') ?>" value="delete_dir" name="action" type="submit"><?php echo __('LblDelete') ?></button>
                    <span class="x-help"><?php echo __('HelpFilesImageDir') ?></span>
                </p>
                <p>
                    <label for="files_new_image_new_dir"><?php echo __('LblFilesImageNewDir') ?></label>
                    <input
                        type="text"
                        class="long"
                        id="files_new_image_new_dir"
                        name="files[new_dir]"
                        value="<?php echo _htmlentities($a_new_files['new_image']['new_dir']) ?>" />
                    <span class="x-help"><?php echo __('HelpFilesImageNewDir') ?></span>
                </p>

                <?php if (function_exists('imagecreatefromjpeg')) : ?>
                <p>
                    <label for="files_new_image_thumbnail"><?php echo __('LblFilesImageMakeThumb') ?></label>
                    <input
                        type="checkbox"
                        id="files_new_image_thumbnail"
                        name="files[thumbnail]"
                        <?php if ('on' === $a_new_files['new_image']['thumbnail']) echo ' checked="checked"' ?> />
                    <span class="x-help"><?php echo __('HelpFilesImageMakeThumb') ?></span>
                </p>
                <p>
                    <label for="files_new_image_thumb_width"><?php echo __('LblFilesImageThumbWidth') ?></label>
                    <input
                        type="text"
                        id="files_new_image_thumb_width"
                        name="files[thumb_width]"
                        value="<?php echo get_configuration('misc/images/thumb_width') ?>" />
                    <span class="x-help"><?php echo __('HelpFilesImageThumbWidth') ?></span>
                </p>
                <p>
                    <label for="files_new_image_thumb_height"><?php echo __('LblFilesImageThumbHeight') ?></label>
                    <input
                        type="text"
                        id="files_new_image_thumb_height"
                        name="files[thumb_height]"
                        value="<?php echo get_configuration('misc/images/thumb_height') ?>" />
                    <span class="x-help"><?php echo __('HelpFilesImageThumbHeight') ?></span>
                </p>
                <?php endif ?>

                <p class="buttons">
                    <button
                        type="submit"
                        class="ico ico-save text-button-ico"
                        id="action_save_image"
                        title="<?php echo __('BtSave') ?>"
                        name="action" value="save"><?php echo __('BtSave') ?></button>
                    <button
                        type="reset"
                        class="ico ico-cancel text-button-ico ajaxify"
                        id="action_cancel_image"
                        title="<?php echo __('BtCancel') ?>"
                        name="action" value="cancel"><?php echo __('BtCancel') ?></button>
                </p>
            </form>

            <hr />

            <form action="<?php echo get_back_uri('files') ?>" method="post" class="ajaxify">
                <p>
                    <?php echo get_session_token_tag(true) ?>
                    <input type="hidden" name="type" value="images" />
                    <label for="files_image_list_dir" class="small-label"><?php echo __('LblFilesImageDir') ?></label>
                    <select id="files_image_list_dir" name="images_list_dir">
                        <?php foreach ($a_dirs['images'] as $s_id => $s_img_dir) : ?>
                            <option value="<?php echo $s_id ?>"<?php if ($s_id === $a_list_dirs['images']) echo ' selected="selected"' ?>><?php echo $s_img_dir ?></option>
                        <?php endforeach ?>
                    </select>
                    <button id="files_image_list_dir_submit" type="submit" class="ico ico-save image-button-ico" name="action" value="list" title="<?php echo __('LblFilesImageListDir') ?>"><?php echo __('LblFilesImageListDir') ?></button>
                    <span class="x-help"><?php echo __('HelpFilesImageDirShow') ?></span>
                </p>
            </form>

            <?php include_view('files_images') ?>

        </div>
    </div>
<?php endif ?>