<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php load_helpers('defaults') ?>

<form action="<?php echo get_back_uri('login') ?>" method="post" id="connection" class="center">

    <fieldset>
        <legend><?php echo __('LblConnectionInformations') ?></legend>

        <?php echo get_messages_box() ?>

        <input type="hidden" name="_config/page" id="_config_page" value="login" />

        <p>
            <label for="connection_login"><?php echo __('LblConnectionLogin') ?></label>
            <input type="text" id="connection_login" name="connection[login]" class="ico ico-user long" />
        </p>

        <p>
            <label for="connection_password"><?php echo __('LblConnectionPassword') ?></label>
            <input type="password" id="connection_password" name="connection[password]" class="ico ico-password long" />
        </p>
        <p class="buttons align-center">
            <button type="submit" class="ico ico-ok text-button-ico"><?php echo __('BtOk') ?></button>
        </p>
    </fieldset>

    <div class="app-name-version"><?php echo APPLICATION_NAME ?> v<?php echo APPLICATION_VERSION ?></div>
</form>
