<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php $b_has_module = (null !== ($s_module_key = get_configuration('module/key'))) ?>

<?php $b_user_is_admin = (USER_ADMIN == get_user_property('rights')) ?>

<?php if ($b_has_module) : ?>
    <?php $a_module_info = modules_get_info($s_module_key) ?>
    <?php $s_module_title = array_key_exists('title', $a_module_info) ? _htmlentities($a_module_info['title']) : _htmlentities($s_module_key) ?>
    <h2><a href="<?php echo get_back_uri('modules/' . $s_module_key . ($module_is_admin ? '/admin' : '')) ?>" title="<?php echo $s_module_title ?>"><?php  echo $s_module_title ?></a></h2>
<?php endif ?>

<div class="main">
        <?php if ($b_has_module) : ?>
            <?php include_module_views() ?>
        <?php else : ?>

                <div class="section module-conf" id="section-installed">
                    <p class="legend"><?php echo __('LblModulesInstalledModules') ?></p>

                    <?php include_view('modules_installed', $a_modules_installed) ?>
                </div>

            <?php if  ($b_user_is_admin) : ?>

                <div class="section module-conf" id="section-availables">
                    <p class="legend"><?php echo __('LblModulesAvailableModules') ?></p>

                    <?php include_view('modules_availables', $a_modules_availables) ?>

                </div>

            <?php endif ?>
        <?php endif ?>
</div>