<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php load_helpers('defaults') ?>

<?php $b_edit_mode = isset($a_edit) ?>

<?php if ($b_edit_mode) : ?>
    <?php if (!$b_is_ajax) : ?>
        <div class="nav">
            <ul>
                <li class="active"><a href="#" title="<?php echo __('LblEdit') ?>"><?php echo __('LblEdit') ?></a></li>
                <li><a href="<?php echo get_back_uri('users', array('action' => 'list')) ?>" title="<?php echo __('LblUsersMenuTitle') ?>"><?php echo __('LblUsersMenuTitle') ?></a></li>
            </ul>
        </div>

        <div class="main">
    <?php endif ?>

    <form action="<?php echo get_back_uri('users') ?>" method="post" class="ajaxify">
        <fieldset>
            <legend><?php echo __('LblUsersUserEdit', ($s_type_action != 'add' ? $a_edit['login'] : __('LblUsersNewUser'))) ?></legend>

            <p>
                <?php echo get_session_token_tag() ?>
                <input type="hidden" name="type_action" value="<?php echo $s_type_action ?>" />
                <label for="user_login"><?php echo __('LblUsersLogin') ?> :</label>
                <?php if ($s_type_action != 'add') : ?>
                    <span><?php echo _htmlentities($a_edit['login']) ?><input type="hidden" name="user[login]" id="user_login" value="<?php echo _htmlentities($a_edit['login']) ?>" /></span>
                <?php else : ?>
                    <input type="text" name="user[login]" id="user_login" value="<?php echo _htmlentities($a_edit['login']) ?>" />
                <?php endif ?>
                <span class="x-help"><?php echo __('HelpUsersLogin') ?></span>
            </p>
            <p>
                <label for="user_firstname"><?php echo __('LblUsersFirstname') ?> :</label>
                <input type="text" name="user[firstname]" id="user_firstname" value="<?php echo _htmlentities($a_edit['firstname']) ?>" class="long" />
                <span class="x-help"><?php echo __('HelpUsersFirstname') ?></span>
            </p>
            <p>
                <label for="user_lastname"><?php echo __('LblUsersLastname') ?> :</label>
                <input type="text" name="user[lastname]" id="user_lastname" value="<?php echo _htmlentities($a_edit['lastname']) ?>" class="long" />
                <span class="x-help"><?php echo __('HelpUsersLastname') ?></span>
            </p>
            <p>
                <label for="user_rights"><?php echo __('LblUsersRights') ?> :</label>
                <select name="user[rights]" id="user_rights">
                    <option value="<?php echo USER_USER ?>"<?php if (USER_USER == $a_edit['rights']) echo ' selected="selected"'?>><?php echo __('LblUsersTypeUser') ?></option>
                    <option value="<?php echo USER_ADMIN ?>"<?php if (USER_ADMIN == $a_edit['rights']) echo ' selected="selected"'?>><?php echo __('LblUsersTypeAdmin') ?></option>
                </select>
                <span class="x-help"><?php echo __('HelpUsersRights') ?></span>
            </p>
            <p>
                <label for="user_password"><?php echo __('LblUsersPassword') ?> :</label>
                <input type="text" name="user[password]" id="user_password" value="<?php echo _htmlentities(user_password_decode($a_edit['password'])) ?>" />
                <span class="x-help"><?php echo __('HelpUsersPassword') ?></span>
            </p>

            <p class="buttons">
                <label><?php echo __('LblActions') ?> :</label>
                <span>
                    <button type="submit" class="ico ico-save text-button-ico" name="action" value="save" title="<?php echo __('BtSave') ?>"><?php echo __('BtSave') ?></button>
                    <button type="reset" class="ico ico-cancel text-button-ico" id="action_cancel_document" title="<?php echo __('BtCancel') ?>"><?php echo __('BtCancel') ?></button>
                </span>
                <span class="x-help"><?php echo __('HelpActions') ?></span>
            </p>
        </fieldset>
    </form>

    <?php if (!$b_is_ajax): ?>
        </div>
    <?php endif ?>

<?php else : ?>

    <?php if (!$b_is_ajax) : ?>
        <div class="main">
    <?php endif ?>

        <table id="users">
            <thead>
                <tr>
                    <th><label><?php echo __('LblUsersLogin') ?></label><span class="x-help"><?php echo __('HelpUsersLogin') ?></span></th>
                    <th><label><?php echo __('LblUsersFirstname') ?></label><span class="x-help"><?php echo __('HelpUsersFirstname') ?></span></th>
                    <th><label><?php echo __('LblUsersLastname') ?></label><span class="x-help"><?php echo __('HelpUsersLastname') ?></span></th>
                    <th><label><?php echo __('LblUsersRights') ?></label><span class="x-help"><?php echo __('HelpUsersRights') ?></span></th>
                    <th><label><?php echo __('LblUsersPassword') ?></label><span class="x-help"><?php echo __('HelpUsersPassword') ?></span></th>
                    <th><label><?php echo __('LblUsersActions') ?></label><span class="x-help"><?php echo __('HelpUsersActions') ?></span></th>
                </tr>
            </thead>
            <tbody>
                <?php $b_style = false ?>
                <?php foreach ($a_users as $s_login => $a_properties) :?>
                <tr class="align-center<?php if ($b_style) echo ' odd' ?>" id="user_<?php echo $s_login ?>">
                    <td><?php echo $s_login ?></td>
                    <td><?php echo _htmlentities($a_properties['firstname']) ?></td>
                    <td><?php echo _htmlentities($a_properties['lastname']) ?></td>
                    <td><?php echo (USER_USER === $a_properties['rights'] ? __('LblUsersTypeUser') : __('LblUsersTypeAdmin')) ?></td>
                    <td><?php echo _htmlentities(user_password_decode($a_properties['password'])) ?></td>
                    <td>
                        <a class="ico ico-edit image-button-ico ajaxify" href="<?php echo get_back_uri('users', array('action' => 'edit', 'id' => $s_login)) ?>" title="<?php echo __('LblEdit') ?>"><?php echo __('LblEdit') ?></a>
                        <a class="ico ico-delete image-button-ico ajaxify" href="<?php echo get_back_uri('users', array('action' => 'delete', 'id' => $s_login)) ?>" title="<?php echo __('LblDelete') ?>"><?php echo __('LblDelete') ?></a>
                    </td>
                </tr>
                <?php $b_style = !$b_style ?>
                <?php endforeach ?>
            </tbody>
        </table>

    <?php if (!$b_is_ajax) : ?>
        <p class="buttons">
            <a class="ico ico-add text-button-ico ajaxify" href="<?php echo get_back_uri('users', array('action' => 'add')) ?>" title="<?php echo __('LblAdd') ?>"><?php echo __('LblAdd') ?></a>
        </p>

    </div>
    <?php endif ?>
<?php endif ?>