<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<button type="submit" class="ico ico-save text-button-ico" title="<?php echo __('BtSave') ?>" id="action_save" name="action" value="save"><?php echo __('BtSave') ?></button>

<?php if ($a_page['is_draft']) : ?>
    <button type="submit" class="ico ico-save text-button-ico" title="<?php echo __('BtPublish') ?>" id="action_pusblish" name="action" value="publish"><?php echo __('BtPublish') ?></button>
<?php endif ?>

<a class="ico ico-cancel text-button-ico ajaxify" href="<?php echo get_back_uri('edit', ($a_page['is_draft'] ? array('action' => 'edit', 'id' => $a_page['id'], 'type' => 'draft') : array('action' => 'edit', 'id' => $a_page['id']))) ?>" title="<?php echo __('BtCancel') ?>"><?php echo __('BtCancel') ?></a>


<?php $b_page_is_locked = is_array($a_page['locked']); $b_page_user_locked = ($b_page_is_locked && $a_page['locked']['id'] == get_user_id()); ?>

<?php if ($b_page_user_locked) : ?>
    <a class="ico ico-unlock text-button-ico margin-left ajaxify" href="<?php echo get_back_uri('edit', array('action' => 'unlock', 'id' => $a_page['id'], 'type' => ($a_page['is_draft'] ? 'draft' : ''))) ?>" title="<?php echo __('LblEditUnlock') ?>"><?php echo __('LblEditUnlock') ?></a>
<?php elseif (!$b_page_is_locked) : ?>
    <a class="ico ico-lock text-button-ico margin-left ajaxify" href="<?php echo get_back_uri('edit', array('action' => 'lock', 'id' => $a_page['id'], 'type' => ($a_page['is_draft'] ? 'draft' : ''))) ?>" title="<?php echo __('LblEditLock') ?>"><?php echo __('LblEditLock') ?></a>
<?php endif ?>

<?php if (!$a_page['is_draft']) : ?>
        <a class="ico ico-page-draft<?php echo (!$a_page['has_draft'] ? '-new' : '') ?> text-button-ico link-edit-draft ajaxify discard-changes" href="<?php echo get_back_uri('edit', array('action' => 'edit', 'id' => $a_page['id'], 'type' => 'draft')) ?>" title="<?php echo __('LblEditGoDraft' . (!$a_page['has_draft'] ? 'New' : '' )) ?>"><?php echo __('LblEditGoDraft' . (!$a_page['has_draft'] ? 'New' : '' )) ?></a>
<?php else : ?>
    <a class="ico ico-page-edit text-button-ico link-edit-real ajaxify discard-changes" href="<?php echo get_back_uri('edit', array('action' => 'edit', 'id' => $a_page['id'])) ?>" title="<?php echo __('LblEditGoReal') ?>"><?php echo __('LblEditGoReal') ?></a>
    <?php if (!$b_page_is_locked || $b_page_user_locked) : ?>
        <a class="ico ico-page-draft text-button-ico margin-left ajaxify" href="<?php echo get_back_uri('edit', array('action' => 'copy', 'id' => $a_page['id'], 'type' => 'draft')) ?>" title="<?php echo __('LblEditCopyReal') ?>"><?php echo __('LblEditCopyReal') ?></a>
    <?php endif ?>
<?php endif ?>

<?php if ($a_page['is_draft'] && ($b_page_user_locked || !$b_page_is_locked)) : ?>
    <a class="ico ico-delete text-button-ico right ajaxify discard-changes" href="<?php echo get_back_uri('edit', array('action' => 'delete', 'id' => $a_page['id'], 'type' => 'draft')) ?>" title="<?php echo __('LblDelete') ?>"><?php echo __('LblDelete') ?></a>
<?php endif?>