<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php
$s_edit_uri = get_back_uri('edit', array('action' => 'edit', 'id' => '_id_'));
$a_structure = get_structure();
?>

<ul class="ui-treeview pages-list">

<?php _edit_treeview_element($s_edit_uri, $a_structure, key($a_structure), $s_current_id) ?>

<?php
function _edit_treeview_element($s_edit_uri, & $a_structure, $s_id, $s_current_id)
{
    $a_properties = $a_structure[$s_id];
    $b_has_children = (count($a_properties['children']));
?>

    <li id="e-<?php echo $a_properties['id'] ?>">
        <p class="ui-treeview-label">
            <span class="ico <?php echo ($b_has_children ? 'ui-treeview-minus' : 'ui-treeview-none') ?>"></span>

            <?php if ($s_current_id === $a_properties['id']) : ?>
                <strong><?php echo _htmlentities($a_properties['title']) ?></strong>
            <?php else : ?>
                <a href="<?php echo str_replace('_id_', $a_properties['id'], $s_edit_uri) ?>" title="<?php echo __('LblEdit') ?>"><span class="ico ico-page-<?php echo $a_properties['type'] ?> image-button-ico-no-border"></span><?php echo _htmlentities($a_properties['title']) ?></a>
            <?php endif ?>
        </p>

    <?php if ($b_has_children) : ?>
        <ul>
        <?php foreach ($a_properties['children'] as $s_child)
            _edit_treeview_element($s_edit_uri, $a_structure, $s_child, $s_current_id);
        ?>
        </ul>
    <?php endif ?>

    </li>
<?php } ?>

</ul>