<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (count($a_files['documents'])) : ?>
    <table id="documents">
        <caption><?php echo __('LblFilesDocumentList') ?></caption>
        <thead>
            <tr>
                <th><?php echo __('LblTitle') ?></th>
                <th><?php echo __('LblFileName') ?></th>
                <th><?php echo __('LblActions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $b_style = false ?>
            <?php foreach ($a_files['documents'] as $s_file_name => $a_document) : ?>
                <?php $s_id_file_name = str_replace('.', '_', $s_file_name) ?>
                <tr<?php if ($b_style) echo ' class="odd"' ?>>
                    <td class="align-center" id="file_<?php echo $s_file_name ?>"><?php echo _htmlentities($a_document['title']) ?></td>
                    <td class="align-center"><?php echo _htmlentities(basename($a_document['url'])) ?></td>
                    <td class="align-center">
                        <a
                            class="ico ico-show image-button-ico"
                            href="http://<?php echo get_configuration('server/base_uri_ressources_path').$a_document['url'] ?>"
                            title="<?php echo __('LblShow') ?>"
                            rel="external"><?php echo __('LblShow') ?></a>
                        <a
                            class="ico ico-edit image-button-ico ajaxify"
                            href="<?php echo get_back_uri('files', array('action' => 'edit', 'type' => 'document', 'id' => $s_file_name)) ?>"
                            title="<?php echo __('LblEdit') ?>"><?php echo __('LblEdit') ?></a>
                        <a
                            class="ico ico-delete image-button-ico ajaxify"
                            href="<?php echo get_back_uri('files', array('action' => 'delete', 'type' => 'document', 'id' => $s_file_name)) ?>"
                            title="<?php echo __('LblDelete') ?>"><?php echo __('LblDelete') ?></a>
                    </td>
                </tr>
                <?php $b_style = !$b_style ?>
            <?php endforeach ?>
        </tbody>
    </table>
<?php else : ?>
    <p id="documents"><?php echo __('LblFilesNoDocument') ?></p>
<?php endif ?>