<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php if (!count($a_modules_availables)) : ?>

    <p><?php echo __('MsgNoAvailableModule') ?></p>

<?php else : ?>

    <table>
    <thead>
    <tr>
    <th><label><?php echo __('LblModulesTitle') ?></label><span class="x-help"><?php echo __('HelpModulesTitle') ?></span></th>
    <th><label><?php echo __('LblModulesModule') ?></label><span class="x-help"><?php echo __('HelpModulesModule') ?></span></th>
    <th><label><?php echo __('LblModulesVersion') ?></label><span class="x-help"><?php echo __('HelpModulesVersion') ?></span></th>
    <th><label><?php echo __('LblModulesDescription') ?></label><span class="x-help"><?php echo __('HelpModulesDescription') ?></span></th>
    <th><label><?php echo __('LblActions') ?></label><span class="x-help"><?php echo __('HelpActions') ?></span></th>
    </tr>
    </thead>
    <tbody>

    <?php $b_style = false ?>

    <?php foreach ($a_modules_availables as $s_name => $a_module) : ?>

        <tr class="align-center<?php echo ($b_style ? ' odd' : '')?>">
        <td><?php echo ('' !== $a_module['info']['title'] ? _htmlentities($a_module['info']['title']) : _htmlentities($s_name)) ?></td>
        <td><?php echo _htmlentities($s_name) ?></td>
        <td><?php echo _htmlentities($a_module['info']['version']) ?></td>
        <td><?php echo ('' !== $a_module['info']['description'] ? _htmlentities($a_module['info']['description']) : '-') ?></td>
        <td><a class="ico ico-add image-button-ico ajaxify" href="<?php echo get_back_uri('modules', array('action' => 'install', 'id' => $s_name)) ?>" title="<?php echo __('LblAdd') ?>"><?php echo __('LblAdd') ?></a></td>
        </tr>

        <?php $b_style = !$b_style ?>
    <?php endforeach ?>

    </tbody>
    </table>

<?php endif ?>