<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php if (!count($a_modules_installed)) : ?>

    <p><?php echo __('MsgNoInstalledModule') ?></p>

<?php else : ?>

    <?php $b_user_is_admin = (USER_ADMIN == get_user_property('rights')) ?>

    <table>
    <thead>
    <tr>
    <th><label><?php echo __('LblModulesTitle') ?></label><span class="x-help"><?php echo __('HelpModulesTitle')  ?></span></th>
    <th><label><?php echo __('LblModulesModule')  ?></label><span class="x-help"><?php echo __('HelpModulesModule')  ?></span></th>
    <th><label><?php echo __('LblModulesVersion')  ?></label><span class="x-help"><?php echo __('HelpModulesVersion')  ?></span></th>
    <th><label><?php echo __('LblModulesDescription')  ?></label><span class="x-help"><?php echo __('HelpModulesDescription')  ?></span></th>
    <th><label><?php echo __('LblActions')  ?></label><span class="x-help"><?php echo __('HelpActions')  ?></span></th>
    </tr>
    </thead>
    <tbody>

    <?php $b_style = false; $i_pos = 0; $i_max = count($a_modules_installed) - 1; ?>

    <?php foreach ($a_modules_installed as $s_name => $a_module) : ?>
        <?php $a_module['info'] = modules_get_info($s_name) ?>

        <tr class="align-center<?php echo ($b_style ? ' odd' :'') ?>">

        <td><?php echo ('' !== $a_module['info']['title'] ? _htmlentities($a_module['info']['title']) : _htmlentities($s_name)) ?></td>
        <td><?php echo _htmlentities($s_name)  ?></td>
        <td><?php echo htmlentities($a_module['info']['version'])  ?></td>
        <td><?php echo ('' !== $a_module['info']['description'] ? _htmlentities($a_module['info']['description']) : '-') ?></td>
        <td>

        <?php if (2 === (2 & $a_module['dispatchers'])) : ?>
            <a class="ico ico-home image-button-ico" href="<?php echo get_back_uri('modules/' . $s_name)  ?>" title="<?php echo __('LblModulesHomePage')  ?>"><?php echo __('LblModulesHomePage')  ?></a>&nbsp;
        <?php endif ?>

        <?php if ($b_user_is_admin) : ?>

            <?php if (1 === (1 & $a_module['dispatchers'])) : ?>
                <a class="ico ico-configuration image-button-ico" href="<?php echo get_back_uri('modules/' . $s_name . '/admin')  ?>" title="<?php echo __('LblModulesAdminPage')  ?>"><?php echo __('LblModulesAdminPage')  ?></a>
            <?php endif ?>

            &nbsp;

            <?php if (0 !== $i_pos) : ?>
                <a class="ico ico-up image-button-ico ajaxify" href="<?php echo get_back_uri('modules', array('action' => 'up', 'id' => $s_name)) ?>" title="<?php echo __('LblModulesPositionUp')  ?>"><?php echo __('LblModulesPositionUp')  ?></a>
            <?php else : ?>
                <span class="ico ico-up image-button-ico disabled" title="<?php echo __('LblModulesPositionUp')  ?>"><?php echo __('LblModulesPositionUp')  ?></span>
            <?php endif ?>

            <?php if ($i_max !== $i_pos) : ?>
                <a class="ico ico-down image-button-ico ajaxify" href="<?php echo get_back_uri('modules', array('action' => 'down', 'id' => $s_name)) ?>" title="<?php echo __('LblModulesPositionDown')  ?>"><?php echo __('LblModulesPositionDown')  ?></a>
            <?php else : ?>
                <span class="ico ico-down image-button-ico disabled" title="<?php echo __('LblModulesPositionDown')  ?>"><?php echo __('LblModulesPositionDown')  ?></span>
            <?php endif ?>

            &nbsp;
            <a class="ico ico-delete image-button-ico ajaxify" href="<?php echo get_back_uri('modules', array('action' => 'uninstall', 'id' => $s_name))  ?>" title="<?php echo __('LblDelete')  ?>"><?php echo __('LblDelete')  ?></a>

        <?php endif ?>

        </td>
        </tr>

        <?php $b_style = !$b_style; $i_pos++; ?>

    <?php endforeach ?>

    </tbody>
    </table>

<?php endif ?>