<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php if (!count($a_edit_element)) : ?>

    <div class="section">
        <p class="legend">
            <?php echo __('LblHelperStructureEditElement', get_request_parameter('id')) ?>
        </p>
        <?php echo get_message_box('error', __('ErrPageNotExists', get_request_parameter('id'))) ?>
    </div>

<?php else : ?>

    <?php
        $a_properties = $a_edit_element;
        $b_is_root = empty($a_properties['parent_id']) && strlen($a_properties['id']);
        $b_is_new = !strlen($a_properties['id']);
        $s_action_uri =  get_back_uri('structure', array('action' => '_action_', 'id' => '_id_'));
        $a_structure = get_structure();
    ?>

    <form action="<?php echo get_back_uri('structure') ?>" method="post" class="ajaxify">
        <fieldset>
            <legend><?php echo __('LblHelperStructureEditElement', ($b_is_new ? __('LblHelperStructureNewElement') : _htmlentities($a_properties['title']))) ?></legend>

            <p class="hidden">
                <?php echo get_session_token_tag(true) ?>
                <input type="hidden" name="structure[parent_id]" id="structure_parent_id" value="<?php echo ($b_is_new ? $s_parent_id : $a_properties['parent_id']) ?>" />
                <input type="hidden" name="structure[id]" id="structure_id" value="<?php echo ($b_is_new ? '' : $a_properties['id']) ?>" />
                <?php if ($b_is_root) : ?>
                    <input type="hidden" id="structure_slug" name="structure[slug]" value="" />
                    <input type="hidden" id="structure_show_slug" name="structure[show_slug]" value="0" />
                    <input type="hidden" id="structure_extension" name="structure[extension]" value="" />
                <?php endif ?>
            </p>

            <p class="first">
                <label for="structure_title"><?php echo  __('LblHelperStructureTitle') ?></label>
                <input type="text" id="structure_title" name="structure[title]" class="long" value="<?php echo _htmlentities($a_properties['title']) ?>" />
                <span class="x-help"><?php echo __('HelpHelperStructureTitle') ?></span>
            </p>

            <?php if (!$b_is_root) : ?>
                <p>
                    <label for="structure_slug"><?php echo  __('LblHelperStructureSlug') ?></label>
                    <input type="text" id="structure_slug" name="structure[slug]" class="long" value="<?php echo _htmlentities($a_properties['slug'])?>" />
                    <span class="x-help"><?php echo  __('HelpHelperStructureSlug') ?></span>
                </p>

                <p>
                    <label for="structure_show_slug"><?php echo  __('LblHelperStructureShowSlug') ?></label>
                    <input type="checkbox" id="structure_show_slug" name="structure[show_slug]"<?php echo (1 == $a_properties['show_slug'] ? ' checked="checked"' : '')?> />
                    <span class="x-help"><?php echo  __('HelpHelperStructureShowSlug') ?></span>
                </p>
            <?php endif ?>

            <p class="v-space"></p>

            <p>
                <label for="structure_redirection"><?php echo  __('LblHelperStructureRedirection') ?></label>
                <select name="structure[redirection]" id="structure_redirection">
                    <option value=""></option>
                    <?php
                        function _structure_get_redirection(& $a_structure, & $a_element, $s_id, $i_index = 0)
                        {
                            $a_properties = $a_structure[$s_id];
                            $s_pad = implode('', array_pad(array(), $i_index, '&nbsp;&nbsp;'));
                    ?>
                                <option value="<?php echo $s_id ?>"<?php echo ($s_id == $a_element['redirection']) ? ' selected="selected"' : '' ?><?php echo (($s_id == $a_element['id'] || STRUCTURE_STATE_VISIBLE != $a_properties['state']) ? ' disabled="disabled"' : '') ?>><?php echo $s_pad._htmlentities($a_properties['title']) ?></option>

                    <?php       foreach ($a_properties['children'] as $s_id)
                                    _structure_get_redirection($a_structure, $a_element, $s_id, ($i_index + 1));
                        }
                        _structure_get_redirection($a_structure, $a_properties, key($a_structure));
                        reset($a_structure);
                    ?>

                </select>
                <span class="x-help"><?php echo  __('HelpHelperStructureRedirection') ?></span>
            </p>

            <p>
                <label for="structure_redirection_code"><?php echo  __('LblHelperStructureRedirectionCode') ?></label>
                <select id="structure_redirection_code" name="structure[redirection_code]">
                    <?php foreach (array('' => '', 'xxx' => __('LblHelperStructureContentRedirection'), '301' => __('LblHelperStructureMovedPermanently'), '302' => __('LblHelperStructureFound')) as $s_type => $s_title) : ?>
                        <option value="<?php echo $s_type?>"<?php echo ($s_type == $a_properties['redirection_code'] ? ' selected="selected"' : '')?>><?php echo $s_title?></option>
                    <?php endforeach ?>
                </select>
                <span class="x-help"><?php echo  __('HelpHelperStructureRedirectionCode') ?></span>
            </p>

            <p class="v-space"></p>

            <p>
                <label for="structure_cache"><?php echo  __('LblHelperStructureCacheLength') ?></label>
                <input type="text" id="structure_cache" name="structure[cache]" class="middle" value="<?php echo $a_properties['cache']?>" />
                <?php if (!$b_is_new) : ?>
                    <?php if (0 != $a_properties['cache']) : ?>
                        <a class="ico ico-clear-cache image-button-ico ajaxify" href="<?php echo str_replace(array('_action_', '_id_'), array('clear-cache', $a_properties['id']), $s_action_uri)?>" title="<?php echo __('LblHelperStructureClearCache')?>"><?php echo __('LblHelperStructureClearCache')?></a>
                    <?php else : ?>
                        <span class="ico ico-clear-cache image-button-ico disabled" title="<?php echo  __('LblHelperStructureClearCache') ?>"></span>
                    <?php endif ?>
                <?php endif ?>
                <span class="x-help"><?php echo  __('HelpHelperStructureCacheLength') ?></span>
            </p>

            <p class="v-space"></p>

            <p>
                <label for="structure_type"><?php echo __('LblHelperStructurePageType') ?></label>
                <select id="structure_type" name="structure[type]">
                <?php foreach (array('html', 'xml', 'php') as $s_type) : ?>
                    <option value="<?php echo $s_type ?>"<?php echo ($s_type == $a_properties['type'] ? ' selected="selected"' : '') ?>><?php echo $s_type ?></option>
                <?php endforeach ?>
                </select>
                <span class="x-help"><?php echo __('HelpHelperStructurePageType') ?></span>
            </p>

            <?php if (!$b_is_root) : ?>
                <p>
                    <label for="structure_extension"><?php echo  __('LblHelperStructureExtension') ?></label>
                    <select id="structure_extension" name="structure[extension]">
                    <?php foreach (array('', 'html', 'xml', 'php') as $s_extension) : ?>
                        <option value="<?php echo $s_extension ?>"<?php echo ($s_extension == $a_properties['extension'] ? ' selected="selected"' : '') ?>><?php echo $s_extension ?></option>
                    <?php endforeach ?>
                    </select>
                <span class="x-help"><?php echo  __('HelpHelperStructureExtension') ?></span>
                </p>
            <?php endif ?>

            <p>
                <label for="structure_state"><?php echo  __('LblHelperStructureOnline') ?></label>
                <input type="checkbox" id="structure_state" name="structure[state]"<?php echo  (STRUCTURE_STATE_VISIBLE == $a_properties['state'] ? ' checked="checked"' : '') ?>/>
                <span class="x-help"><?php echo  __('HelpHelperStructureOnline') ?></span>
            </p>

            <p>
                <label for="structure_index_menu"><?php echo  __('LblHelperStructureInMenu') ?></label>
                <input type="checkbox" id="structure_index_menu" name="structure[index_menu]"<?php echo  (1 == $a_properties['index_menu'] ? ' checked="checked"' : '') ?>/>
                <span class="x-help"><?php echo  __('HelpHelperStructureInMenu') ?></span>
            </p>

            <p>
                <label for="structure_is_secure"><?php echo  __('LblHelperStructureIsSecure') ?></label>
                <input type="checkbox" id="structure_is_secure" name="structure[is_secure]"<?php echo  (1 == $a_properties['is_secure'] ? ' checked="checked"' : '') ?>/>
                <span class="x-help"><?php echo  __('HelpHelperStructureIsSecure') ?></span>
            </p>

            <?php if (!$b_is_new) : ?>
                <p class="v-space"></p>

                <p>
                    <label><?php echo __('LblHelperStructureId') ?></label><?php echo $a_properties['id'] ?>
                    <span class="x-help"><?php echo __('HelpHelperStructureId') ?></span>
                </p>
            <?php endif ?>

            <p class="v-space"></p>

            <?php if (!$b_is_root && !$b_is_new) : ?>
                <?php
                $b_button_up = false;
                $b_button_down = false;

                // search position
                reset($a_structure);
                $a_children = $a_structure[$a_properties['parent_id']]['children'];

                $i_position = array_search($a_properties['id'], $a_children);
                $b_button_up = $i_position > 0;
                $b_button_down = $i_position >= 0 && $i_position < count($a_children) - 1;
                ?>

                <p>
                    <label><?php echo  __('LblHelperStructurePosition') ?></label>
                    <?php if ($b_button_up) : ?>
                        <a class="ico ico-up image-button-ico ajaxify" href="<?php echo str_replace(array('_action_', '_id_', 'id'), array('up', $a_properties['id'], 'id'), $s_action_uri) ?>" title="<?php echo __('LblHelperStructurePositionUp') ?>"></a>
                    <?php else : ?>
                        <span class="ico ico-up image-button-ico disabled" title="<?php echo __('LblHelperStructurePositionUp') ?>"></span>
                    <?php endif ?>

                    <?php if ($b_button_down) : ?>
                            <a class="ico ico-down image-button-ico ajaxify" href="<?php echo str_replace(array('_action_', '_id_', 'id'), array('down', $a_properties['id'], 'id'), $s_action_uri) ?>" title="<?php echo  __('LblHelperStructurePositionDown') ?>"></a>
                    <?php else : ?>
                        <span class="ico ico-down image-button-ico disabled" title="<?php echo __('LblHelperStructurePositionDown') ?>"></span>
                    <?php endif ?>

                    <span class="x-help"><?php echo __('HelpHelperStructurePosition') ?></span>
                </p>

            <?php endif ?>

            <p class="buttons">
                <label><?php echo  __('LblActions') ?> :</label>
                <button type="submit" class="ico ico-save text-button-ico" id="action" name="action" value="save" title="<?php echo __('BtSave') ?>"><?php echo __('BtSave') ?></button>

                <?php if (!$b_is_root && !$b_is_new) : ?>
                    <a class="ico ico-delete text-button-ico ajaxify" href="<?php echo str_replace(array('_action_', '_id_', 'id'), array('delete', $a_properties['id'], 'id'), $s_action_uri) ?>" title="<?php echo __('BtDelete') ?>"><?php echo __('BtDelete') ?></a>
                <?php endif ?>

                <button type="reset" class="ico ico-cancel text-button-ico" title="<?php echo __('BtCancel') ?>"><?php echo __('BtCancel') ?></button>
                <span class="x-help"><?php echo __('HelpActions') ?></span>
            </p>

        </fieldset>

    </form>

<?php endif ?>