<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php
$a_uri = array(
    'action' => get_back_uri('structure', array('action' => '_action_', 'id' => '_id_')),
    'edit'   => get_back_uri('edit', array('action' => 'edit', 'id' => '_id_')),
    'draft'  => get_back_uri('edit', array('action' => 'edit', 'id' => '_id_', 'type' => 'draft'))
);
$a_structure = get_structure();
?>

<ul class="ui-treeview">

<?php
$s_root = key($a_structure);
$a_structure[$s_root]['title'] = 'http://'.get_configuration('server/base_url');
_structure_treeview_element($a_uri, $a_structure, $s_root);
?>

<?php
function _structure_treeview_element(& $a_uri, & $a_structure, $s_id)
{
    $a_properties = $a_structure[$s_id];
    $b_has_children = (count($a_properties['children']));
?>

    <li id="e-<?php echo $a_properties['id'] ?>">
        <p class="ui-treeview-label">
            <span class="ico <?php echo ($b_has_children ? 'ui-treeview-minus' : 'ui-treeview-none') ?>"></span>
            <a href="<?php echo str_replace(array('_action_', '_id_'), array('edit', $a_properties['id']), $a_uri['action']) ?>" class="ajaxify" title="<?php echo __('LblHelperStructureEditElementProperties') ?>"><span class="ico ico-page-<?php echo $a_properties['type'] ?> image-button-ico-no-border"></span><?php echo _htmlentities($a_properties['title']) ?></a>
            <span class="ui-treeview-actions-icons">
                <a href="<?php echo str_replace('_id_', $a_properties['id'], $a_uri['edit']) ?>" class="ico ico-page-edit image-button-ico" title="<?php echo __('LblHelperStructureEditPage') ?>"><?php echo __('LblHelperStructureEditPage') ?></a>
                <a href="<?php echo str_replace('_id_', $a_properties['id'], $a_uri['draft']) ?>" class="ico ico-page-draft image-button-ico" title="<?php echo __('LblHelperStructureEditDraft') ?>"><?php echo __('LblHelperStructureEditDraft') ?></a>
            </span>
            <span class="ui-treeview-actions-icons">
                <a href="<?php echo str_replace(array('_action_', '_id_', 'id'), array('add', $a_properties['id'], 'id'), $a_uri['action']) ?>" class="ico ico-add image-button-ico ajaxify" title="<?php echo __('LblHelperStructureAddChild') ?>"><?php echo __('LblHelperStructureAddChild') ?></a>
            </span>
        </p>

        <?php if ($b_has_children) : ?>
            <ul>
                <?php foreach ($a_properties['children'] as $s_child)
                        _structure_treeview_element($a_uri, $a_structure, $s_child); ?>
            </ul>
        <?php endif ?>

    </li>
<?php  } ?>

</ul>