<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Returns the back-office menu.
 *
 * @return string
 */
function get_back_menu()
{
    $s_page = get_configuration('app/page');
    $a_routes = include get_configuration('app/path/data').get_configuration('app/name').'_routes.php';
    $a_menu = array();
    $b_user_is_admin = USER_ADMIN === get_user_property('rights');

    $a_menu[] = '<ul>';
    foreach ($a_routes as $s_route => $a_properties)
    {
        if ($a_properties['menu'] && ($b_user_is_admin || USER_USER == $a_properties['rights']))
        {
            $b_is_current = $s_route === $s_page;
            $s_active = $b_is_current ? ' class="active"' : '';
            $s_link_title = $b_is_current ? __('LblCurrentPage', $a_properties['title']) : __('LblGoToPage', $a_properties['title']). ' - '.__('LblAccesskey', $a_properties['accesskey']);

            $a_menu[] = '<li'.$s_active.'>' .
                        '<a href="'.get_back_uri($s_route).'" class="ico ico-' . $s_route . '" title="'.$s_link_title.'" accesskey="'.$a_properties['accesskey'].'">'.
                        $a_properties['title'].
                        '</a></li>';
        }
    }
    $a_menu[] = '</ul>';

    return implode("\n", $a_menu);
}

/**
 * Returns all messages boxes.
 *
 * @return string
 */
function get_messages_box()
{
    return get_message_box('error') . get_message_box('warning') . get_message_box('success') . get_message_box('info');
}

/**
 * Returns message box.
 *
 * @param  string  $s_message_type  Message type (error, warning, success, info).
 * @param  mixed   $m_message       Message.
 * @return string
 */
function get_message_box($s_message_type, $m_message = null)
{
    if (has_application_parameter('messages/'.$s_message_type) || $m_message)
    {
        $x_message = ($m_message ? $m_message : get_message($s_message_type));
        $s_return_message = '';

        if (is_array($x_message))
        {
            $s_return_message = '<ul>';
            foreach ($x_message as $s_message)
                $s_return_message .= '<li>'.$s_message.'</li>';
            $s_return_message .= '</ul>';
        }
        else
            $s_return_message = '<ul><li>'.$x_message.'</li></ul>';

        return '<div class="ui-message-box '.$s_message_type.'"><span class="ico"></span>'.$s_return_message.'<div class="clear"></div></div>';
    }
    return null;
}

/**
 * Returns hidden's fields with configuration.
 *
 * @return string
 */
function get_hidden_configuration()
{
    $a_return = array();
    $a_config = array();
    $a_configuration = get_configuration();
    unset($a_configuration['app']);
    if (isset($a_configuration['module']['path'])) unset($a_configuration['module']['path']);

    _a_to_s($a_configuration, $a_config);

    foreach ($a_config as $s_key => $s_value)
        $a_return[] = sprintf('<input type="hidden" id="_config%s" name="_config%s" value="%s" />', str_replace('/', '_', $s_key), $s_key, _htmlentities($s_value));

    $a_return[] = sprintf('<input type="hidden" id="_config_base_uri_ressources_path" name="_config/base_uri_ressources_path" value="%s" />', get_configuration('server/base_uri_ressources_path'));
    $a_return[] = sprintf('<input type="hidden" id="_config_script_name" name="_config/script_name" value="%s" />', get_configuration('server/script_name'));
    $a_return[] = sprintf('<input type="hidden" id="_config_page" name="_config/page" value="%s" />', get_configuration('app/page'));
    $a_return[] = sprintf('<input type="hidden" id="_config_page_path" name="_config/page_path" value="%s" />', implode('/', get_configuration('app/page-path')));

    if (isset($a_configuration['modules']['load']['js']))
        $a_return[] = sprintf('<input type="hidden" id="_config_modules_load_js" name="_config/modules/load/js" value="%s" />', implode(';', $a_configuration['modules']['load']['js']));
    if (isset($a_configuration['modules']['load']['css']))
        $a_return[] = sprintf('<input type="hidden" id="_config_modules_load_css" name="_config/modules/load/css" value="%s" />', implode(';', $a_configuration['modules']['load']['css']));

    return implode("\n", $a_return);
}

/**
 * Returns a human comprehensive unit for bytes values.
 * @todo : rename to bytes_to_multiples
 *
 * @param  integer  $i_octets  Value in bytes.
 * @return array
 */
function octets_to_multiples($i_octets)
{
    $a_multiples = get_configuration('app/lang/byte_units', array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB'));
    $b = (double)$i_octets;
	if($b > 0)
	{
		$e = (int)(log($b,1024));
		// no unit : To
		if (isset($a_multiples[$e]))
            return array(round($b/pow(1024, $e), 2), $a_multiples[$e]);
	}
    return array($i_octets, 'o');
}

/*
 * Convert an array to a string for configuration.
 *
 * @param  array   $a  Array to convert.
 * @param  array   $r  Returning array.
 * @param  string  $s  Temp value.
 * @return void
 */
function _a_to_s($a, &$r, $s = null)
{
    foreach ($a as $k => $v)
    {
        if (is_array($v))
            _a_to_s($v, $r, $s.'/'.$k);
        else
            if (!is_int($k))
                $r[$s.'/'.$k] = $v;
    }
}