<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
include_once get_configuration('app/path/back').'external_files.php';

/**
 * Returns the html code for layout select.
 *
 * @param  string  $s_selected           Current selected layout.
 * @param  array   $a_select_properties  Parameters for select.
 * @return string
 */
function get_layout_select($s_selected = null, $a_select_properties = array())
{
    $a_html = array();

    $a_properties = array();
    foreach ($a_select_properties as $s_key => $s_value) $a_properties[] = $s_key.'="'.$s_value.'"';

    $a_html[] = '<select'.(count($a_properties) ? ' '.implode(' ', $a_properties) : '').'><option value=""></option>';

    foreach (external_files_get_layout() as $s_file)
    {
        $s_file = basename($s_file, '.php');
        $a_html[] = '<option value="' . $s_file . '"'.($s_file === $s_selected ? ' selected="selected"' : '').'>'._htmlentities($s_file).'</option>';
    }

    $a_html[] = '</select>';
    return implode("\n", $a_html);
}

/**
 * Returns the html code for css select.
 *
 * @param  string  $s_selected                Current selected css.
 * @param  array   $a_select_properties       Parameters for select.
 * @param  array   $a_select_list_properties  Css list.
 * @return string
 */
function get_css_select($s_selected = null, $a_select_properties = array(), $a_select_list_properties = array())
{
    // a textarea with selected css
    // and an other with all css
    $a_html = array();

    $a_properties = array();
    foreach ($a_select_properties as $s_key => $s_value) $a_properties[] = $s_key.'="'.$s_value.'"';

    $a_html[] = '<textarea'.(count($a_properties) ? ' '.implode(' ', $a_properties) : '').'>';
    $a_html[] = $s_selected;
    $a_html[] = '</textarea>';

    $a_files = array();
    foreach (external_files_get_css() as $s_file)
        $a_files[] = str_replace(array(get_configuration('app/path/web'), '\\'), array('/', '/'), $s_file);

    $a_properties = array();
    foreach ($a_select_list_properties as $s_key => $s_value) $a_properties[] = $s_key.'="'.$s_value.'"';

    $a_html[] = '<textarea'.(count($a_properties) ? ' '.implode(' ', $a_properties) : '').'>';
    $a_html[] = implode(';', $a_files);
    $a_html[] = '</textarea>';

    return implode("\n", $a_html);
}

/**
 * Returns the html code for js select.
 *
 * @param  string  $s_selected                Current selected js.
 * @param  array   $a_select_properties       Parameters for select.
 * @param  array   $a_select_list_properties  Js list.
 * @return string
 */
function get_js_select($s_selected = null, $a_select_properties = array(), $a_select_list_properties = array())
{
    // a textarea with selected css
    // and an other with all css
    $a_html = array();

    $a_properties = array();
    foreach ($a_select_properties as $s_key => $s_value) $a_properties[] = $s_key.'="'.$s_value.'"';

    $a_html[] = '<textarea'.(count($a_properties) ? ' '.implode(' ', $a_properties) : '').'>';
    $a_html[] = $s_selected;
    $a_html[] = '</textarea>';

    $a_files = array();
    foreach (external_files_get_js() as $s_file)
        $a_files[] = str_replace(array(get_configuration('app/path/web'), '\\'), array('/', '/'), $s_file);

    $a_properties = array();
    foreach ($a_select_list_properties as $s_key => $s_value) $a_properties[] = $s_key.'="'.$s_value.'"';

    $a_html[] = '<textarea'.(count($a_properties) ? ' '.implode(' ', $a_properties) : '').'>';
    $a_html[] = implode(';', $a_files);
    $a_html[] = '</textarea>';

    return implode("\n", $a_html);
}