<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * returns a generic string for front uri.
 *
 * @param  array  $a_parameters  Uri parameters.
 * @return string
 */
function _get_front_generic_uri($a_parameters = array())
{
    $b_has_rewriting_mode = get_configuration('server/url_rewriting', false);

    $s_url = sprintf('http%s://%s/%s',
                '%protocol%',
                get_configuration('server/base_uri_path'),
                (!$b_has_rewriting_mode ? get_configuration('server/script_name') . '?' .get_configuration('server/page_var_name', 'p').'=' : '').
                '%page%');

    if (count($a_parameters))
        $s_url .= (!$b_has_rewriting_mode ? $s_var_separator : '?').http_build_query($a_parameters, '', $s_var_separator);

    return $s_url;
}

/**
 * Returns the generic front menu.
 *
 * @return string
 */
function get_front_menu()
{
    $a_menu = get_data('front_menu');
    if (empty($a_menu)) return ;

    $a_menu_lines = array('<ul class="menu">');

    _front_menu_walk(key($a_menu), get_configuration('app/page'), _get_front_generic_uri(), $a_menu, $a_menu_lines);

    $a_menu_lines[] = '</ul>';
    return implode("\n", $a_menu_lines);
}

/*
 * walk in the menu data to make the generic front menu.
 *
 * @param  string  $s_id          Current id in the menu.
 * @param  string  $s_page_id     Current page.
 * @param  string  $s_base_url    Base url.
 * @param  array   $a_menu        Front menu db.
 * @param  array   $a_menu_lines  Menu.
 * @return void
 */
function _front_menu_walk($s_id, $s_page_id, $s_base_url, & $a_menu, & $a_menu_lines)
{

    if (!isset($a_menu[$s_id])) return ;

    $s_classes = ($s_page_id === $s_id ? 'selected current' : (in_array($s_page_id, $a_menu[$s_id]['children']) ? 'selected' : null));

    $a_menu_lines[] = '<li'. ($s_classes ? ' class="' . $s_classes . '"' : '') . '>';
    $a_menu_lines[] = '<a href="'.str_replace(array('%protocol%', '%page%'), array($a_menu[$s_id]['is_secure'] ? 's' : '', $a_menu[$s_id]['route']), $s_base_url).'" title="'._htmlentities($a_menu[$s_id]['title']).'">'._htmlentities($a_menu[$s_id]['title']).'</a>';

    if (count($a_menu[$s_id]['children']))
    {
        $a_menu_lines[] = '<ul>';
        foreach ($a_menu[$s_id]['children'] as $s_child)
            _front_menu_walk($s_child, $s_page_id, $s_base_url, $a_menu, $a_menu_lines);
        $a_menu_lines[] = '</ul>';

        if (($i_count = count($a_menu_lines)) >= 2 && ('<ul>' === $a_menu_lines[$i_count - 2] && '</ul>' === $a_menu_lines[$i_count - 1])) {
            $a_menu_lines[$i_count - 2] = ''; $a_menu_lines[$i_count - 1] = '';
        }
    }

    $a_menu_lines[] = '</li>';

    $s_parent_id = $a_menu[$s_id]['parent_id'];
    unset($a_menu[$s_id]);

    if (count($a_menu)) {
        $s_next_id = key($a_menu);
        if ($a_menu[$s_next_id]['parent_id'] === $s_parent_id)
            _front_menu_walk($s_next_id, $s_page_id, $s_base_url, $a_menu, $a_menu_lines);
    }
}

/**
 * Returns the generic breadcrumb.
 *
 * @return string
 */
function get_front_breadcrumb($b_display_root = true)
{
    $a_properties = page_get_properties(get_configuration('app/page'));
    $a_breadcrumb_lines = array('<span class="breadcrumb-current">' . _htmlentities($a_properties['title']) . '</span>');

    while (!empty($a_properties['parent_id']))
    {
        $s_id = $a_properties['parent_id'];
        if (is_array($a_properties = page_get_properties($s_id)) && (intval($a_properties['state'])))
            $a_breadcrumb_lines[] = '<a href="' . get_front_uri($s_id) . '" title="' . _htmlentities($a_properties['title']) . '" class="breadcrumb-path">' . _htmlentities($a_properties['title']) . '</a>';
    }

    if (!$b_display_root) array_pop($a_breadcrumb_lines);
    return implode(' &gt; ', array_reverse($a_breadcrumb_lines));
}

/*
 * @see /cms/libs/apps/back/pages.php:page_get_properties()
 */
if (!function_exists('page_get_properties')) {
    function page_get_properties($s_id)
    {
        if (file_exists($s_properties_file = get_configuration('app/path/contents').APP_FRONT.DIRECTORY_SEPARATOR.$s_id.'.properties.php'))
        {
            return include $s_properties_file;
        }
        return null;
    }
}
