<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('beCms')) return ; ?>
<?php load_helpers('defaults') ?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php echo get_user_property('lang', 'fr') ?>" xml:lang="<?php echo get_user_property('lang', 'fr') ?>" dir="ltr">
    <head>
        <meta charset="utf-8" />
        <title><?php echo get_page_title() ?></title>

        <link rel="shortcut icon" type="image/png" href="<?php echo get_configuration('request/protocol') ?>://<?php echo get_configuration('server/base_uri_ressources_path') ?>/images/back/favicon.png" />
        <link rel="stylesheet" type="text/css" href="<?php echo get_configuration('request/protocol') ?>://<?php echo get_configuration('server/base_uri_ressources_path') ?>/css/back/default.php?uri=<?php echo get_configuration('request/protocol') ?>://<?php echo get_configuration('server/base_uri_ressources_path') ?>" />
        <?php echo get_page_css() ?>
    </head>
    <body class="<?php echo get_configuration('app/page') ?>">

        <div id="header">
            <span class="ico ico-user"><?php echo get_user_property('firstname') ?> <?php echo get_user_property('lastname') ?></span>
                -
            <a href="<?php echo get_back_uri('quit') ?>" class="ico ico-quit" accesskey="9" title="<?php echo __('LblLogoutLinkTitle') ?> - <?php echo __('LblAccesskey', 9) ?>"><?php echo __('LblLogout') ?></a>
        </div>

        <div id="nav" class="nav">
            <?php echo get_page_menu() ?>
        </div>

        <div id="main" class="main">
            <div id="ui-messages-area">
                <?php echo get_messages_box() ?>
            </div>

            <h1><?php echo get_page_title() ?></h1>

            <?php echo get_page_content() ?>

            <div class="app-name-version"><span title="<?php echo APPLICATION_NAME . ' v' . APPLICATION_VERSION . ' (' . APPLICATION_DATE . ')' ?>"><?php echo APPLICATION_NAME ?> v<?php echo APPLICATION_VERSION ?></span></div>
        </div>

        <p class="hidden">
            <?php echo get_hidden_configuration() ?>
        </p>

        <script type="text/javascript" src="<?php echo get_configuration('request/protocol') ?>://<?php echo get_configuration('server/base_uri_ressources_path') ?>/js/back/jquery/jquery.js"></script>
        <script type="text/javascript" src="<?php echo get_configuration('request/protocol') ?>://<?php echo get_configuration('server/base_uri_ressources_path') ?>/js/back/tools/back.tools.js"></script>
        <?php echo get_page_js() ?>

    </body>
</html>
