<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Check values for configuration data.
 *
 * @param  array  $a_configuration  Configuration data.
 * @return boolean
 */
function configuration_control_values(& $a_configuration)
{
    $a_errors = array();

    if (!array_key_exists('server', $a_configuration))
        $a_errors[] = __('MsgRequiredSeverConfig');

    if (!array_key_exists('administration', $a_configuration))
        $a_errors[] = __('MsgRequiredAdminAreaConfig');

    if (!count($a_errors))
    {
        // server values
        if ($b_has_value = array_key_exists('base_url', $a_configuration['server']))
            $a_configuration['server']['base_url'] = str_ireplace('http://', '', trim($a_configuration['server']['base_url'], '/'));

        if (!$b_has_value || (!$a_configuration['server']['base_url'] || !strlen($a_configuration['server']['base_url'])))
            $a_errors[] = __('MsgRequiredUrl');
        elseif (!preg_match('~^[a-zA-Z0-9\_\-\./]+$~', $a_configuration['server']['base_url']))
            $a_errors[] = __('MsgCheckBaseUrl', $a_configuration['server']['base_url']);

        $a_configuration['server']['url_rewriting'] = intval($a_configuration['server']['url_rewriting']);

        if (!$a_configuration['server']['url_rewriting'])
        {
            if ((!($b_has_value = array_key_exists('page_var_name', $a_configuration['server']))) ||
                (!$a_configuration['server']['page_var_name']) ||
                (!strlen($a_configuration['server']['page_var_name'])) ||
                (!preg_match('~^[a-zA-Z]+$~', $a_configuration['server']['page_var_name'])))
                $a_errors[] = sprintf(__('MsgCheckVariablePageName', $b_has_value ? $a_configuration['server']['page_var_name'] : ''));
        }

        if (!preg_match('/^[\d]+$/', $a_configuration['server']['filesize']))
            $a_errors[] = __('MsgCheckInteger', __('LblUploadFileSize'));

        if (!preg_match('/^[\d]+$/', $a_configuration['server']['filemode']))
            $a_errors[] = __('MsgCheckInteger', __('LblConfigFileMode'));
        else
            $a_configuration['server']['filemode'] = intval($a_configuration['server']['filemode']);

        if (!preg_match('/^[\d]+$/', $a_configuration['server']['dirmode']))
            $a_errors[] = __('MsgCheckInteger', __('LblConfigDirMode'));
        else
            $a_configuration['server']['dirmode'] = intval($a_configuration['server']['dirmode']);

        if (!$a_configuration['pages']['default_doctype'] || !in_array($a_configuration['pages']['default_doctype'], array('xhtml-1.0-strict', 'xhtml-1.0-transitional')))
            $a_configuration['pages']['default_doctype'] = 'xhtml-1.0-strict';

        if (is_array($a_configuration['pages']['default_css']))
            $a_configuration['pages']['default_css'] = implode(';', $a_configuration['pages']['default_css']);
        if (is_array($a_configuration['pages']['default_js']))
            $a_configuration['pages']['default_js'] = implode(';', $a_configuration['pages']['default_js']);

        $a_configuration['pages']['default_css'] = trim($a_configuration['pages']['default_css']);
        $a_configuration['pages']['default_js']  = trim($a_configuration['pages']['default_js']);

        // admin values
        if ((!($b_has_value = array_key_exists('route', $a_configuration['administration']))) ||
            (!$a_configuration['administration']['route']) ||
            (!strlen($a_configuration['administration']['route'])) ||
            (!preg_match('~^[a-zA-Z\-\_]+$~', $a_configuration['administration']['route'])))
            $a_errors[] = sprintf(__('MsgCheckAdminRoute', $b_has_value ? $a_configuration['administration']['route'] : ''));

        // misc
        $a_configuration['misc']['images']['thumb_width'] = trim($a_configuration['misc']['images']['thumb_width']);
        $a_configuration['misc']['images']['thumb_height'] = trim($a_configuration['misc']['images']['thumb_height']);
        if (!preg_match('/^[\d]+$/', $a_configuration['misc']['images']['thumb_width']) && !empty($a_configuration['misc']['images']['thumb_width']))
            $a_errors[] = __('MsgCheckInteger', __('LblThumbsWidth'));
        if (!preg_match('/^[\d]+$/', $a_configuration['misc']['images']['thumb_height']) && !empty($a_configuration['misc']['images']['thumb_height']))
            $a_errors[] = __('MsgCheckInteger', __('LblThumbsHeight'));
        if (empty($a_configuration['misc']['images']['thumb_width']) && empty($a_configuration['misc']['images']['thumb_height']))
        {
            $a_errors[] = __('MsgRequiredWidthHeight');
            $a_configuration['misc']['images']['thumb_width'] = 100;
            $a_configuration['misc']['images']['thumb_height'] = 100;
        }
    }

    if (count($a_errors))
    {
        set_message('error', $a_errors);
        return false;
    }

    return true;
}