<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Returns available js files for front.
 *
 * @return array
 */
function external_files_get_js()
{
    $a = bfglob(get_configuration('app/path/web').'js'.DIRECTORY_SEPARATOR.'front'.DIRECTORY_SEPARATOR, '*.js|*.php', 0, -1);
    return is_array($a) ? $a : array();
}

/**
 * Returns available css files for front.
 *
 * @return array
 */
function external_files_get_css()
{
    $a = bfglob(get_configuration('app/path/web').'css'.DIRECTORY_SEPARATOR.'front'.DIRECTORY_SEPARATOR, '*.css|*.php', 0, -1);
    return is_array($a) ? $a : array();
}

/**
 * Returns available layout files for front.
 *
 * @return array
 */
function external_files_get_layout()
{
    $a = x_glob(get_configuration('app/path/layouts').APP_FRONT.DIRECTORY_SEPARATOR, '*.php');
    return is_array($a) ? $a : array();
}

/**
 * Returns routes with level, title and id.
 *
 * @return array
 */
function external_files_get_routes()
{
    $a = array();
    $a_structure = get_structure();
    $a_routes_flip = get_data('front_routes_flip');
    _external_files_get_routes(key($a_structure), $a_structure, $a_routes_flip, $a);
    return $a;
}

function _external_files_get_routes($s_id, & $a_structure, & $a_routes_flip, & $a_routes)
{
    if (isset($a_routes_flip[$s_id])) {
        $a_values = $a_routes_flip[$s_id];
        $a_routes[] = array('level' => (count(explode('/', $a_values['route']))) - 1, 'title' => $a_values['title'], 'id' => $s_id);
    }

    foreach ($a_structure[$s_id]['children'] as $s_child_id)
        _external_files_get_routes($s_child_id, $a_structure, $a_routes_flip, $a_routes);
}

/**
 * Returns documents directories.
 *
 * @return array
 */
function external_files_get_documents_dirs()
{
    $s_dir = get_configuration('app/path/web') . 'files' . DIRECTORY_SEPARATOR . 'documents';
    $a_dirs = bfglob($s_dir, '*', 1, -1);
    $a_sorted = array();
    _external_files_sort_dirs($a_dirs, $a_sorted, $s_dir);
    return $a_sorted;
}

/**
 * Returns images directories.
 *
 * @param  boolean  $b_with_thumbs  Indicates if thumbnails directories must be returned.
 * @return array
 */
function external_files_get_images_dirs($b_with_thumbs = false)
{
    $s_dir = get_configuration('app/path/web') . 'files' . DIRECTORY_SEPARATOR . 'images';
    $a_dirs = bfglob($s_dir, '*', 1, -1);
    if (!$b_with_thumbs)
    {
        $s_thumbs_dir = get_configuration('app/path/web') . 'files' . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'thumbnails' . DIRECTORY_SEPARATOR;
        foreach ($a_dirs as $i_index => $s_subdir)
        {
            if (0 === strpos($s_subdir . DIRECTORY_SEPARATOR, $s_thumbs_dir))
                $a_dirs[$i_index] = null;
        }
    }
    $a_sorted = array();
    _external_files_sort_dirs($a_dirs, $a_sorted, $s_dir);
    return $a_sorted;
}

function external_files_get_documents($s_dir = null)
{
    $a_docs = get_data('documents', array());
    if (null === $a_docs) return $a_docs;

    set_application_parameter('_external_files_get_doc_filter', '/files/documents' . ('' !== $s_dir ? '/' . $s_dir : ''). '/');
    $a_docs = array_filter($a_docs, '_external_files_get_doc_filter');
    delete_application_parameter('_external_files_get_doc_filter');

    return $a_docs;
}

function external_files_get_images($s_dir = null)
{
    $a_imgs = get_data('images', array());
    if (null === $s_dir) return $a_imgs;

    set_application_parameter('_external_files_get_img_filter', '/files/images' . ('' !== $s_dir ? '/' . $s_dir : ''). '/');
    $a_imgs = array_filter($a_imgs, '_external_files_get_img_filter');
    delete_application_parameter('_external_files_get_img_filter');

    return $a_imgs;
}

function _external_files_get_doc_filter($s_dir)
{
    static $s_filter_dir = null;
    static $i_level = null;

    if (!$s_filter_dir) {
        $s_filter_dir = get_application_parameter('_external_files_get_doc_filter');
        $i_level = substr_count($s_filter_dir, '/');
    }

    return (0 === strpos($s_dir['url'], $s_filter_dir) && ($i_level === substr_count($s_dir['url'], '/')));
}

function _external_files_get_img_filter($s_dir)
{
    static $s_filter_dir = null;
    static $i_level = null;

    if (!$s_filter_dir) {
        $s_filter_dir = get_application_parameter('_external_files_get_img_filter');
        $i_level = substr_count($s_filter_dir, '/');
    }

    return (0 === strpos($s_dir['url'], $s_filter_dir) && ($i_level === substr_count($s_dir['url'], '/')));
}

/*
 * Sorts documents / images directories.
 */
function _external_files_sort_dirs(& $a_dirs, & $a_sorted, $s_dir)
{
    $s_dir .= DIRECTORY_SEPARATOR;

    $i_subdir_level = substr_count($s_dir, DIRECTORY_SEPARATOR);

    foreach ($a_dirs as $i_index => $s_subdir)
    {
        if (!$s_subdir) continue;

        if (0 === strpos($s_subdir, $s_dir))
        {
            $a_sorted[] = $s_subdir;
            $a_dirs[$i_index] = null;
            _external_files_sort_dirs($a_dirs, $a_sorted, $s_subdir);
        }
    }
}