<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Specific front-office application dispatcher.
 *
 * @return void
 */
function front_dispatch()
{
    // @todo fix it
    //load_language('en');

    // extract page from parameters
    $a_parameters = get_uri_parameters();
    $s_page = $a_parameters['page'];

    if (!array_key_exists('page', $a_parameters)) error_404();

    set_application_page($s_page);

    $b_cache_file = cache_file_start($s_page);

    display_page();

    if ($b_cache_file) cache_file_end($s_page);

    return true;
}

/**
 * Sets the page key or returns the 404 page.
 *
 * @param  string  $s_page    Page parameter from uri.
 * @param  array   $a_routes  Routes from data/front_routes
 * @return boolean
 */
function set_application_page($s_page)
{
    $a_routes = get_data('front_routes', array());
    if (!isset($a_routes[$s_page])) error_404();
    if ($a_routes[$s_page]['is_secure'] && !current_uri_is_securised()) redirect(preg_replace('/^http\:/', 'https:', get_current_uri()));

    if ('' !== $a_routes[$s_page]['redirection'])
    {
        if ('xxx' === $a_routes[$s_page]['redirection_code'])
            set_configuration('app/page', $a_routes[$s_page]['redirection']);
        else
            redirect($a_routes[$s_page]['redirection'], intval($a_routes[$s_page]['redirection_code']));
    }
    else
        set_configuration('app/page', $a_routes[$s_page]['id']);

    return true;
}

/**
 * Cache manager start.
 *
 * @param  string  $s_page    Page parameter from uri.
 * @return boolean
 */
function cache_file_start($s_page)
{
    if ('GET' === get_request_method() && array_key_exists($s_page, get_data('front_cache', array())))
    {
        ob_start();
        return true;
    }
    return false;
}

/**
 * Cache manager end.
 *
 * @param  string  $s_page    Page parameter from uri.
 * @return boolean
 */
function cache_file_end($s_page)
{
    $a_cache = get_data('front_cache', array());

    if (array_key_exists($s_page, $a_cache))
    {
        $s_cache_file = get_configuration('app/path/cache').str_replace('/', DIRECTORY_SEPARATOR, get_configuration('request/protocol').DIRECTORY_SEPARATOR.get_configuration('server/base_uri_path').(strlen($s_page) ? DIRECTORY_SEPARATOR.$s_page : '')).'.cache.php';
        $s_cache_dir  = dirname($s_cache_file);
        $s_content    = ob_get_clean();

        if (!is_dir($s_cache_dir))
            mkdir($s_cache_dir, 0777, true);

        $s_page_type = get_page_property('type');
        $s_page_type_mime = get_page_property('type_mime');
        $s_content_type = (('xml' === $s_page_type || 'xml' === $s_page_type_mime) ? 'header(\'content-type: text/xml; charset=UTF-8\');' :
                                (('html' ===  $s_page_type || 'xhtml' === $s_page_type_mime) ? 'header(\'content-type: text/html; charset=UTF-8\');' : ''));

        write_file($s_cache_file,
                   sprintf('<?php if (time() >= %d) { unlink(__FILE__);', (time() + intval($a_cache[$s_page]))) .
                   'if (function_exists(\'dispatch\')) { dispatch(); }' .
                   sprintf('else { include_once \'%s%s\'; }', get_configuration('app/path/base'), get_configuration('server/script_name')) .
                   '} else { ' . $s_content_type . '?>' . "\n" .
                   $s_content .
                   "\n". '<?php } ?>'
        );

        echo $s_content;
    }

    return true;
}
