<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
if (!defined('INIT_DIR')) define('INIT_DIR',  '/');

include realpath(dirname(__FILE__).DIRECTORY_SEPARATOR.'cms'.DIRECTORY_SEPARATOR.'libs'.DIRECTORY_SEPARATOR.'core'.DIRECTORY_SEPARATOR.'core.php');

install_init();
install_exec();

function install_init()
{
    initialize();

    $s_base_uri = 'http://'.strtolower($_SERVER['HTTP_HOST'].rtrim(str_replace(basename(__FILE__), '', $_SERVER['REQUEST_URI']), '/')); //str_replace($_SERVER['SCRIPT_URL'], '', $_SERVER['SCRIPT_URI']);

    set_configuration('install/base_uri',               $s_base_uri);
    set_configuration('install/install_uri',            $s_base_uri . '/' . basename(__FILE__));
    set_configuration('install/ressources_uri',         $s_base_uri . ('web' == INIT_DIR ? '' : '/web') . '/');
    set_configuration('install/css_uri',                $s_base_uri . ('web' == INIT_DIR ? '' : '/web') . '/' . 'css/back/default.php?uri='.$s_base_uri . ('web' == INIT_DIR ? '' : '/web'));
    set_configuration('install/htaccess',               ('web' == INIT_DIR ? realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'web') : realpath(dirname(__FILE__))) . DIRECTORY_SEPARATOR . '.htaccess');

    set_application_parameter('install/allready_configured',   ('' != get_configuration('server/base_url')));

    set_configuration('app/name', APP_BACK);
    set_configuration('server/script_name', 'index.php');

    install_load_language();
    load_helpers('defaults');

    include get_configuration('app/path/back') . 'configuration.php';
    include get_configuration('app/path/back') . 'users.php';
    install_test_rights();
}

function install_test_rights()
{
    $a_dir_rights = array();
    foreach (array(get_configuration('app/path/data'),
                   get_configuration('app/path/contents').'front',
                   get_configuration('app/path/cache'),
                   get_configuration('app/path/web').'files'.DIRECTORY_SEPARATOR.'documents',
                   get_configuration('app/path/web').'files'.DIRECTORY_SEPARATOR.'images',
                   get_configuration('app/path/web').'files'.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'thumbnails') as $s_directory) {
        $a_dir_rights[$s_directory] = is_writable($s_directory) && is_readable($s_directory);
    }

    set_configuration('install/rights/dirs', $a_dir_rights);

    $a_files_rigths = array();
    foreach (array_merge(bfglob(get_configuration('app/path/data'), '*.php'), bfglob(get_configuration('app/path/contents').'front', '*.php')) as $s_file) {
        $a_files_rigths[$s_file] = is_writable($s_file) && is_readable($s_file);
    }
    set_configuration('install/rights/files', $a_files_rigths);
}

function install_load_language()
{
    load_language('fr');

    // adds terms to lang
    $a_lang = array_merge(get_configuration('app/lang'), array(
        'LblInstallTitle' => 'Installation de %s %s',
        'MsgAllreadyConfigured' => 'Le système semble être déjà configuré, vous devriez supprimer ce fichier.',
        'HelpServerConfig' => 'Certaines informations liées au serveur sont nécessaires au fonctionnement de beCms.<br />Veuillez vérifier ces informations, et les modifier au besoin.',
        'HelpUserConfig' => 'Des utilisateurs par défaut existent lors de l\'installation de beCms.<br />Pour des raisons de sécurité, il vaut mieux modifier ces utilisateurs.',

        'LblDirectoriesFilesRights' => 'Droits répertoires et fichiers',
        'HelpDirectoriesFilesRights' => 'Tests des droits en lecture et écriture sur les répertoires et fichiers.<br />Si un résultat indique "KO", veuillez modifier les droits sur les répertoires ou fichiers indiqués',
        'LblDirectoriesRights' => 'Droits sur les répertoires',
        'LblRightsStatus' => 'Résultats des tests : %s',
        'LblFilesRights' => 'Droits sur les fichiers',

        'MsgConfigOk' => 'L\'enregistrement de la configuration s\'est bien déroulée. Vous pouvez modifier à nouveau les options ou tester la connexion à votre interface d\'administration : <a href="%s" title="Administration">%s</a>.',
    ));
    set_configuration('app/lang', $a_lang);
}


function get_message($s_type)
{
    return get_application_parameter('messages/' . $s_type);
}

function set_message($s_type, $m_message)
{
    $a_message = get_application_parameter('messages/' . $s_type, array());
    if (is_array($m_message)) $a_message = array_merge($a_message, $m_message);
    else $a_message[] = $m_message;
    set_application_parameter('messages/' . $s_type, $a_message);
}

function install_exec()
{
    set_application_parameter('install/success', false);

    if (get_application_parameter('install/allready_configured'))
        set_message('warning', __('MsgAllreadyConfigured'));

    if ('POST' == get_request_method())
    {
        $b_is_sucess = true;

        // config
        $a_config = get_data('config');
        foreach ($_POST['configuration']['server'] as $s_key => $m_value) $a_config['server'][$s_key] = $m_value;
        $a_config['server']['url_rewriting'] = array_key_exists('url_rewriting', $_POST['configuration']['server']);

        $b_is_sucess = $b_is_sucess && configuration_control_values($a_config);

        // users
        $a_users = $_POST['user'];
        $b_has_admin = false;
        foreach ($a_users as $a_user)
        {
            $b_is_sucess = $b_is_sucess && user_control_values($a_user);
            if (USER_ADMIN == $a_user['rights']) $b_has_admin = true;
        }

        if (!$b_has_admin)
        {
            $b_is_sucess = false;
            set_message('error', __('ErrNoAdminUser'));
        }

        $_a_users = array();
        foreach ($a_users as $a_user)
        {
            $a_user['password'] = user_password_encode($a_user['password']);
            $a_user['rights'] = intval($a_user['rights']);
            $_a_users[$a_user['login']] = $a_user;
        }

        if ($b_is_sucess)
        {
            set_application_parameter('_app/_configuration', $a_config);
            if (false === ($b_is_sucess = $b_is_sucess && write_data($a_config, 'config'))) set_message('error', __('ErrFileNotWrite', 'config'));
            else if (false === ($b_is_sucess = $b_is_sucess && user_save_file($_a_users))) set_message('error', __('ErrFileNotWrite', 'users'));
        }

        if ($b_is_sucess)
        {
            set_configuration('server', $a_config['server']);
            set_message('success', __('MsgOperationOk'));
            set_application_parameter('install/success', true);

            // update config
            $s_base_uri_path = trim(preg_replace('#(/+)#', '/', get_configuration('server/base_url')), '/');
            set_configuration('server/base_uri_path',               $s_base_uri_path);
            set_configuration('server/base_uri_ressources_path',    trim(preg_replace('#(/+)#', '/', $s_base_uri_path . '/' . ('/' == get_configuration('server/base_dir') ? '/web/' : '/')), '/'));
            //set_configuration('server/script_name',                 basename($_SERVER['SCRIPT_NAME']));
        }

        // restore configuration
        set_application_parameter('install/config', $a_config['server']);
        set_application_parameter('install/users',  $_a_users);
    }
    else
    {
        $a_config = get_configuration('server');
        if (!get_application_parameter('install/allready_configured'))
        {
            $a_config['base_url'] = preg_replace('/^(https?\:\/\/)/i', '', get_configuration('install/base_uri'));
            $a_config['base_dir'] = INIT_DIR;
        }

        set_application_parameter('install/config', $a_config);
        set_application_parameter('install/users',  get_data('users'));
    }
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr">
    <head>
        <title><?php echo __('LblInstallTitle', APPLICATION_NAME, APPLICATION_VERSION) ?></title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <link href="<?php echo get_configuration('install/css_uri') ?>" type="text/css" rel="stylesheet">
        <style type="text/css">
            div.user-item + div.user-item {
                margin-top: 2em;
            }
            p.form-help {
                margin-bottom: 2em;
            }
            .xx-long {
                width: 40em;
            }
            li.error {
                color: #d8000c;
            }
            ul + h2 {
                margin-top: 1.5em;
            }
        </style>
    </head>
    <body>

        <div id="nav" class="nav">
            <ul>
                <li class="active"><a class="ico ico-configuration" href="#">Installation</a></li>
            </ul>
        </div>

        <div id="main" class="main">

        <div id="ui-messages-area">
            <?php echo get_messages_box() ?>
        </div>

        <h1><?php echo __('LblInstallTitle', APPLICATION_NAME, APPLICATION_VERSION) ?></h1>

            <div class="main">

            <?php if (get_application_parameter('install/success')) : ?>
                <p><?php echo __('MsgConfigOk', get_back_uri('login'), get_back_uri('login')) ?></p>
            <?php endif ?>

            <?php if (get_application_parameter('install/allready_configured') && !get_application_parameter('install/success')) : ?>
                <p><?php echo __('MsgAllreadyConfigured') ?></p>
            <?php else : ?>

                <form action="<?php echo get_configuration('install/install_uri') ?>" method="post">
                    <fieldset>
                        <legend><?php echo __('LblConfigServerTitle') ?></legend>
                        <?php $a_config = get_application_parameter('install/config') ?>

                        <p class="form-help"><?php echo __('HelpServerConfig') ?></p>

                        <p>
                            <label for="configuration_server_base_url"><?php echo __('LblConfigBaseUrl') ?></label>
                            <input
                                type="text"
                                class="long"
                                id="configuration_server_base_url"
                                name="configuration[server][base_url]"
                                value="<?php echo _htmlentities($a_config['base_url']) ?>" />
                            <span class="x-help"><?php echo __('HelpConfigBaseUrl') ?></span>
                        </p>
                        <p>
                            <label for="configuration_server_url_rewriting"><?php echo __('LblConfigUrlRewriting') ?></label>
                            <?php $b_url_rewriting = $a_config['url_rewriting'];  ?>
                            <input
                                type="checkbox"
                                id="configuration_server_url_rewriting"
                                name="configuration[server][url_rewriting]"<?php echo $b_url_rewriting ? ' checked="checked"' : '' ?> />
                            <span class="x-help"><?php echo __('HelpConfigUrlRewriting') ?></span>
                        </p>
                        <p>
                            <label for="configuration_server_page_var_name"><?php echo __('LblConfigVariablePageName') ?></label>
                            <input
                                type="text"
                                id="configuration_server_page_var_name"
                                name="configuration[server][page_var_name]"
                                value="<?php echo _htmlentities($a_config['page_var_name']) ?>" />
                            <span class="x-help"><?php echo __('HelpConfigVariablePageName') ?></span>
                        </p>
                        <p>
                            <label><?php echo __('LblConfigRootDir') ?></label>
                            <?php $s_server_base_dir = $a_config['base_dir']; ?>
                            <span class="checkbox-group">
                                <label for="configuration_server_base_dir_root" class="no-help"><?php echo __('root') ?></label>
                                <input
                                    type="radio"
                                    value="/"
                                    name="configuration[server][base_dir]"
                                    id="configuration_server_base_dir_root"<?php echo ('/' == $s_server_base_dir ? ' checked="checked"' : '') ?> />

                                <label for="configuration_server_base_dir_web" class="no-help">web</label>
                                <input
                                    type="radio"
                                    value="web"
                                    name="configuration[server][base_dir]"
                                    id="configuration_server_base_dir_web"<?php echo ('/' == $s_server_base_dir ? '' : ' checked="checked"') ?> />
                            </span>
                            <span class="x-help"><?php echo __('HelpConfigRootDir') ?></span>
                        </p>
                        <p>
                            <label for="configuration_server_filemode"><?php echo __('LblConfigFileMode') ?></label>
                            <input
                                type="text"
                                id="configuration_server_filemode"
                                name="configuration[server][filemode]"
                                value="<?php echo get_configuration('server/filemode', 666) ?>" />
                            <span class="x-help"><?php echo __('HelpConfigFileMode') ?></span>
                        </p>
                        <p>
                            <label for="configuration_server_dirmode"><?php echo __('LblConfigDirMode') ?></label>
                            <input
                                type="text"
                                id="configuration_server_dirmode"
                                name="configuration[server][dirmode]"
                                value="<?php echo get_configuration('server/dirmode', 777) ?>" />
                            <span class="x-help"><?php echo __('HelpConfigDirMode') ?></span>
                        </p>
                    </fieldset>

                    <fieldset>
                        <legend><?php echo __('LblUsersPageTitle') ?></legend>
                        <?php $a_users = get_application_parameter('install/users') ?>

                        <p class="form-help"><?php echo __('HelpUserConfig') ?></p>

                        <?php $i = 0; ?>
                        <?php foreach ($a_users as $s_login => $a_user) : ?>
                            <div class="user-item">
                                <p>
                                    <label for="user_login_<?php echo $i ?>"><?php echo __('LblUsersLogin') ?> :</label>
                                    <input type="text" name="user[<?php echo $i ?>][login]" id="user_login_<?php echo $i ?>" value="<?php echo _htmlentities($s_login) ?>" />
                                    <span class="x-help"><?php echo __('HelpUsersLogin') ?></span>
                                </p>
                                <p>
                                    <label for="user_firstname_<?php echo $i ?>"><?php echo __('LblUsersFirstname') ?> :</label>
                                    <input type="text" name="user[<?php echo $i ?>][firstname]" id="user_firstname_<?php echo $i ?>" value="<?php echo _htmlentities($a_user['firstname']) ?>" class="long" />
                                    <span class="x-help"><?php echo __('HelpUsersFirstname') ?></span>
                                </p>
                                <p>
                                    <label for="user_lastname_<?php echo $i ?>"><?php echo __('LblUsersLastname') ?> :</label>
                                    <input type="text" name="user[<?php echo $i ?>][lastname]" id="user_lastname_<?php echo $i ?>" value="<?php echo _htmlentities($a_user['lastname']) ?>" class="long" />
                                    <span class="x-help"><?php echo __('HelpUsersLastname') ?></span>
                                </p>
                                <p>
                                    <label for="user_rights_<?php echo $i ?>"><?php echo __('LblUsersRights') ?> :</label>
                                    <select name="user[<?php echo $i ?>][rights]" id="user_rights_<?php echo $i ?>">
                                        <option value="<?php echo USER_USER ?>"<?php if (USER_USER == $a_user['rights']) echo ' selected="selected"'?>><?php echo __('LblUsersTypeUser') ?></option>
                                        <option value="<?php echo USER_ADMIN ?>"<?php if (USER_ADMIN == $a_user['rights']) echo ' selected="selected"'?>><?php echo __('LblUsersTypeAdmin') ?></option>
                                    </select>
                                    <span class="x-help"><?php echo __('HelpUsersRights') ?></span>
                                </p>
                                <p>
                                    <label for="user_password_<?php echo $i ?>"><?php echo __('LblUsersPassword') ?> :</label>
                                    <input type="text" name="user[<?php echo $i ?>][password]" id="user_password_<?php echo $i ?>" value="<?php echo _htmlentities(user_password_decode($a_user['password'])) ?>" />
                                    <span class="x-help"><?php echo __('HelpUsersPassword') ?></span>
                                    <input type="hidden" name="user[<?php echo $i ?>][lang]" id="user_lang_<?php echo $i ?>" value="fr" />
                                </p>
                            </div>
                        <?php $i++; endforeach ?>
                    </fieldset>

                    <fieldset>
                        <legend><?php echo __('LblDirectoriesFilesRights') ?></legend>
                        <p class="form-help"><?php echo __('HelpDirectoriesFilesRights') ?></p>
                        <h2><?php echo __('LblDirectoriesRights') ?></h2>
                        <?php
                            $b_ok = true;
                            $a_list = array();
                            foreach (get_configuration('install/rights/dirs') as $s_dir => $b_right) {
                                $a_list[] = '<li' . (!$b_right ? ' class="error"' : '') . '>'. $s_dir . ' : ' . ($b_right ? 'OK' : 'KO') . '</li>';
                                $b_ok = $b_ok && $b_right;
                            }
                        ?>
                        <p><?php echo __('LblRightsStatus', ($b_ok ? 'OK' : 'KO')) ?></p>
                        <ul>
                            <?php echo implode('', $a_list); ?>
                        </ul>

                        <h2><?php echo __('LblFilesRights') ?></h2>
                        <?php
                            $b_ok = true;
                            $a_list = array();
                            foreach (get_configuration('install/rights/files') as $s_dir => $b_right) {
                                $a_list[] = '<li' . (!$b_right ? ' class="error"' : '') . '>' . $s_dir . ' : ' . ($b_right ? 'OK' : 'KO') . '</li>';
                                $b_ok = $b_ok && $b_right;
                            }
                        ?>
                        <p><?php echo __('LblRightsStatus', ($b_ok ? 'OK' : 'KO')) ?></p>
                        <ul>
                            <?php echo implode('', $a_list); ?>
                        </ul>
                    </fieldset>

                    <p class="buttons">
                        <button value="save" name="action" id="action_save" title="<?php echo __('BtSave') ?>" class="ico ico-save text-button-ico" type="submit"><?php echo __('BtSave') ?></button>
                        <button value="reset" name="action" id="action_reset" title="<?php echo __('BtCancel') ?>" class="ico ico-cancel text-button-ico" type="reset"><?php echo __('BtCancel') ?></button>
                    </p>
                </form>

            <?php endif ?>

            </div>
            <div class="app-name-version"><?php echo APPLICATION_NAME ?> v<?php echo APPLICATION_VERSION ?></div>
        </div>

        <script src="<?php echo get_configuration('install/ressources_uri') ?>js/back/jquery/jquery.js" type="text/javascript"></script>
        <script src="<?php echo get_configuration('install/ressources_uri') ?>js/back/tools/back.tools.js" type="text/javascript"></script>

    </body>
</html>
