<?php
/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */
header("Content-type: text/css"); $uri = isset($_GET['uri']) ? $_GET['uri'] : '' ?>
/*   Reset all elements border, margin and padding */
html,
head, /*title, base, meta, link, style, script, noscript,*/
body,
div, p, h1, h2, h3, h4, h5, h6,
ul, ol, li, dl, dt, dd,
address, hr,
pre, blockquote, ins, del, a, span, bdo,
br,
em, strong, dfn, code, samp, kbd, var, cite, abbr, acronym, q, sub, sup, tt,
i, b, big, small,
object, param,
img, map, area,
form, label, input, select, optgroup, option, textarea, fieldset, legend, button,
table, caption, thead, tfoot, tbody, colgroup, col, tr, th, td {
	border: 0;
	margin: 0;
	padding: 0;
	vertical-align: baseline;
}

/* Structure */
html {
	background-color: #f8f8f8;
	font-size: 100%;
}

body {
	/* font-family: georgia, palatino, "palatino linotype", times, "times new roman", serif; */
	font-family: Verdana, "DejaVu Sans", "Lucida sans", helvetica, tahoma, arial, sans-serif;
	font-size: .875em;
	font-size-adjust: 0.58;
	line-height: 1.5em;
	margin: 1em;
}

/* Text */
h1, h2, h3, h4, h5, h6 { font-weight: bold; }

h1 {
	font-size: 1.5em;
	line-height: 1em;
	/*margin-bottom: 0.33em;
    margin-top: 0.33em;*/
}

h2 {
	font-size: 1.25em;
	line-height: 1.2em;
}

h3 {
	font-size: 1.15em;
	line-height: 1.304em;
}

h4 {
	font-size: 1.10em;
	line-height: 1.3636em;
}

h5 {
	font-size: 1.05em;
	line-height: 1.4286em;
}

h6 {
	font-size: 1.025em;
	line-height: 1.4633em;
}

em, i {
	font-style: italic;
}

strong, b {
	font-weight: bold;
}

blockquote, q, cite, address {
	font-style: italic;
}

blockquote, q {
	quotes: none;
}

blockquote:before, blockquote:after,
q:before, q:after {
	content: none;
	content: "";
}

code, kbd, pre, samp, tt {
	font-family: menlo, monaco, consolas, "lucida console", "courier new", courier, monospace;
	font-size: 0.75em;
    line-height: 1.5em;
    vertical-align: text-bottom;
}

pre {
	white-space: pre-wrap;
}

pre code, pre kbd, pre samp, pre tt {
	font-size: 1em;
    line-height: 1.5em;
	vertical-align: middle;
}

abbr, acronym, dfn {
	border-bottom: 1px dotted;
	cursor: help;
	font-style: normal;
	font-variant: normal;
}

var {
	font-style: normal;
}

/* List */

ul {
	list-style: disc outside none;
}

ul.list-style-none,
ul.all-list-style-none, ul.all-list-style-none ul {
	list-style: none;
}

ol {
	list-style: decimal outside none;
}

li {
	margin-left: 2em;
}

li ul, li ol {
	margin-bottom: 0;
}

dt {
	font-weight: bold;
}

dd {
	margin-bottom: 1.5em;
	margin-left: 2em;
}

/* Presentation */
hr {
	border: 0;
	border-bottom: 1px solid;
}

big {
	font-size: 1.15em;
	line-height: 1.304em;
}

small, sub, sup {
	font-size: 0.75em;
}

small {
	/* 0.8625 */
	line-height: 1.15em;
}

sub, sup {
	/*line-height: 1;*/
	line-height: 0.8em;
}

sub {
	vertical-align: bottom;
}

sup {
	vertical-align: top;
}

del, s, strike {
	text-decoration: line-through;
}

ins {
	border-bottom: 1px dotted;
	text-decoration: none;
}

bdo {
	border-bottom: 1px dotted;
}

u {
	text-decoration: underline;
}

a {
	text-decoration: none;
}
a:hover  {
	text-decoration: underline;
}

/* Table */
table {
	border: solid 1px #000;
	border-collapse: collapse;
	margin-left: auto;
	margin-right: auto;
	width: 98%;
}

thead {
	background-color: #ccc;
	border: solid 1px #000;
	font-weight: bold;
	text-align: center;
}

th, td {
	border: solid 1px #000;
	padding: 0.25em 0.5em;
	vertical-align: middle;
}

tr > td {
	background-color: #fff;
}

tr.odd > td {
	background-color: #c1cee9;
}

tr:hover > td {
	background-color: #ffffcc;
}

/* Form */
form.center {
	/*display: inline-block;*/
	margin-left: auto;
	margin-right: auto;
}

button, input, textarea, select, option {
	font-family: Verdana, "DejaVu Sans", "Lucida sans", helvetica, tahoma, arial, sans-serif;
	font-size: 1em;
	line-height: 1.5em;
	padding: 0 0 0 5px;
}

input[type=text].x-long, input[type=password].x-long, input[type=file].x-long, textarea.x-long, select.x-long {
	width: 25em;
}
input[type=text].long, input[type=password].long, input[type=file].long, textarea.long, select.long {
	width: 20em;
}
input[type=text], input[type=password], input[type=file], textarea, select,
input[type=text].middle, input[type=password].middle, input[type=file].middle, textarea.middle, select.middle {
	width: 10em;
}
input[type=text].short, input[type=password].short, input[type=file].short, textarea.short, select.short {
	width: 5em;
}

span.text-button-ico, span.image-button-ico, a.text-button-ico, a.image-button-ico, button, input, select, textarea {
	border: solid 1px #3a3935;
	color: #000;
	vertical-align: middle;
}
input[type=radio], input[type=checkbox] {
	border: none;
}
span.image-button-ico-no-border,
span.image-button-ico, a.image-button-ico, button.image-button-ico {
	display: inline-block;
	font-size: 0px;
	height: 20px;
	margin: 0;
	padding: 0;
	text-decoration: none;
	vertical-align: middle; /*top;*/
	width: 20px;
	-moz-box-sizing: content-box;
	-webkit-box-sizing: content-box;
	-ms-box-sizing: content-box;
	box-sizing: content-box;
}

span.text-button-ico, span.image-button-ico, a.text-button-ico, a.image-button-ico, button, input[type=button], input[type=submit], input[type=reset], input[type=image], input[type=file] {
	background-color: #e6efc2;
	cursor: pointer;
	-moz-box-sizing: content-box;
	-webkit-box-sizing: content-box;
	-ms-box-sizing: content-box;
	box-sizing: content-box;
}

button[disabled], input[disabled], select[disabled], textarea[disabled],
a.disabled,
span.image-button-ico.disabled,
span.text-button-ico.disabled {
	background-color: #ddeeff;
	cursor: default;
	opacity: 0.5;
}

input[type=checkbox], input[type=radio], input[type=file], input[type=password], input[type=text],
select, textarea {
	background-color: #fff;
}

input[type=text], input[type=password] /*, input[type=file] */ {
	height: 1.45em;
}

span.ui-input-file-container {
	position: relative;
}

span.ui-input-file-container input[type=file] {
	float: none;
	/*height: 0;*/
	opacity: 0;
	position: relative;
	/*width: 0;*/
	z-index: -1;
}

span.ui-input-file-container input[type=text] {
	cursor: pointer;
	float: none;
	left: 0;
	top: 0;
	position: absolute;
}

a.text-button-ico:hover, a.image-button-ico:hover, button:hover, input:hover, select:hover, textarea:hover {
	background-color: #dddfff;
}
option:hover {
	background-color: #c6b9a6;
}

a.text-button-ico:focus, a.image-button-ico:focus, button:focus, input:focus, select:focus, textarea:focus {
	background-color: #ddeeff;
}
span.text-button-ico, a.text-button-ico, button.text-button-ico {
	padding-right: 10px;
}
span.text-button-ico, a.text-button-ico {
	display: inline-block;
	text-decoration: none;
	width: auto;
}
span.text-button-ico, a.text-button-ico, button.text-button-ico {
	height: 1.5em;
}

input::-moz-focus-inner, button::-moz-focus-inner /* Remove button padding in FF */
{
    border: 0;
    padding: 0;
}


fieldset {
	border: solid 1px #3a3935;
	margin: 0.5em;
}

legend {
	margin: 0.5em;
	padding: 0 0.25em;
}

fieldset.none {
	border: none;
}

fieldset.none legend {
	display: none;
}

form p label,
form div.p label {
	float: left;
	margin-right: 0.5em;
	text-align: right;
	width: 49%;
}
form p label.small-label,
form div.p label.small-label {
	width: auto !important;
}

hr {
	background-color: #006699;
	border: 0;
	color: #006699;
	height: 1px;
	margin: 1em 0;
}

form p {
	clear: both;
	padding: 0.25em 0;
}

p.buttons {
	margin: 0.25em;
	/*text-align: center;*/
}

form p.buttons button, form p.buttons input[type=button], form p.buttons input[type=submit], form p.buttons input[type=reset] {
	float: none;
}

form.center div {
	margin: 0 1em;
}
form.center p {
	margin: 0 3em;
}
form.center p label {
	float: none;
	display: block;
	margin-left: auto;
	margin-right: auto;
	text-align: center;
	width: auto;
}
form.center p input,
form.center p button {
	display: block;
	float: none;
	margin-left: auto;
	margin-right: auto;

}

/* structure */
div#header {
	float: right;
}

div#nav {
}

<?php /* cf http://css.maxdesign.com.au/listamatic/horizontal05.htm#
http://css.maxdesign.com.au/listamatic/
http://htmldog.com/articles/tabs/ <=
*/ ?>
.nav ul {
	font-size: 0.8em;
	font-weight: bold;
	list-style: none;
	padding: 0;
	margin: 0;
}

.nav li {
	background-color: #c1ced5;
	float: left;
	border: 1px solid #006699;
	border-bottom-width: 0;
	margin: 0 0.5em 0 0;
	-moz-border-radius: 3px 3px 0 0;
	-webkit-border-radius: 3px 3px 0 0;
	-o-border-radius: 3px 3px 0 0;
	-ms-border-radius: 3px 3px 0 0;
	-khtml-border-radius: 3px 3px 0 0;
	border-radius: 3px 3px 0 0;
}

.nav .active {
	background-color: #ffffcc;
}

.nav .active a {
	background-color: #ffffcc;
	color: #000;
	position: relative;
	text-decoration: none;
	top: 1px;
	-moz-border-radius: 3px 3px 0 0;
	-webkit-border-radius: 3px 3px 0 0;
	-o-border-radius: 3px 3px 0 0;
	-ms-border-radius: 3px 3px 0 0;
	-khtml-border-radius: 3px 3px 0 0;
	border-radius: 3px 3px 0 0;
}

.nav .active a:hover {
	text-decoration: none;
}

.nav a {
	background-color: #c1ced5;
	color: #666;
	display: block;
	padding: 0 1em;
	text-decoration: none;
	-moz-border-radius: 3px 3px 0 0;
	-webkit-border-radius: 3px 3px 0 0;
	-o-border-radius: 3px 3px 0 0;
	-ms-border-radius: 3px 3px 0 0;
	-khtml-border-radius: 3px 3px 0 0;
	border-radius: 3px 3px 0 0;
}

.nav a:hover {
	text-decoration: underline;
}

.nav .ico {
	padding: 0 1em 0 25px
}

div.main {
	background-color: #ffffcc;
	border: 1px solid #006699;
	clear: both;
	padding: 1.5em;
	-moz-border-radius: 5px;
	-webkit-border-radius: 5px;
	-o-border-radius: 5px;
	-ms-border-radius: 5px;
	-khtml-border-radius: 5px;
	border-radius: 5px;
}

div.nav + div.main {
	-moz-border-radius: 0 5px 5px 5px;
	-webkit-border-radius: 0 5px 5px 5px;
	-o-border-radius: 0 5px 5px 5px;
	-ms-border-radius: 0 5px 5px 5px;
	-khtml-border-radius: 0 5px 5px 5px;
	border-radius: 0 5px 5px 5px;
}

form + div.section,
form + form,
div.section + form,
div.section + div.section,
fieldset + div.section,
div.section + fieldset {
	margin-top: 1.5em;
}

div.section {
	border: 1px solid #3A3935;
    margin: 0.5em;
	z-index: 1;
}

p.legend {
	background-color: #ffffcc;
	display: inline-block;
	margin: 0.5em;
    padding: 0 0.25em;
	position: relative;
    top: -1.25em;
	z-index: 2;
}

div.section.none {
	border: none;
}

div.section.none p.legend {
	display: none;
}


div#main h1 + h2,
div#main h1 + p,
div#main h1 + div,
div#main h1 + form,
div#main h2 + p,
div#main h2 + div,
div#main h2 + form,
div#main p + div
{
	margin-top: .65em;
}

div#main h2 a {
	color: #000;
	text-decoration: underline;
}

div#dashbord {
	text-align: center;
}
div.dashbord {
	background-color: #f8f8f8;
	border: 1px solid #006699;
	clear: both;
	display: inline-block;
	padding: 0;
	-moz-border-radius: 5px;
	-webkit-border-radius: 5px;
	-o-border-radius: 5px;
	-ms-border-radius: 5px;
	-khtml-border-radius: 5px;
	border-radius: 5px;

	margin: 5px 1%;
	text-align: left;

	width: 22%;
	min-width: 300px;
	vertical-align: top;
}
div.dashbord div.title {
	background-color: #c1ced5;
	border-bottom: 1px solid #006699;
	font-weight: bold;
	padding: 5px 10px;
	text-align: center;

	-moz-border-radius: 5px 5px 0 0;
	-webkit-border-radius: 5px 5px 0 0;
	-o-border-radius: 5px 5px 0 0;
	-ms-border-radius: 5px 5px 0 0;
	-khtml-border-radius: 5px 5px 0 0;
	border-radius: 5px 5px 0 0;
}
div.dashbord div.content {
	background-color: #f8f8f8;
	padding: 5px 10px;
	-moz-border-radius: 0 0 5px 5px;
	-webkit-border-radius: 0 0 5px 5px;
	-o-border-radius: 0 0 5px 5px;
	-ms-border-radius: 0 0 5px 5px;
	-khtml-border-radius: 0 0 5px 5px;
	border-radius: 0 0 5px 5px;
}
div.dashbord a {
	color: #006699;
}


/*div#main > p {
	margin: 0 0.75em;
}*/

div#main fieldset,
div#main div.section {
	padding-bottom: 1.5em;
	word-wrap: break-word;
}

div.main form p label,
div.main form div.p label {
	padding-right: 20px;
	width: 40%;
}
div.p div.weed-container {
    display: inline-block;
}
div.main form p label + span.checkbox-group {
    display: inline-block;
}

div.main form p label + span.checkbox-group label {
	float: none;
	padding: 0;
	margin: 0;
	width: auto;
}

div.main form p label + span.checkbox-group input {
	margin-right: 1.5em;
}

p.back-top {
	font-size: .75em;
	margin-right: 1.5em;
	text-align: right;
}

/* icons */
.ico {
	padding-left: 20px;
	background-image: url(<?php echo $uri ?>/images/back/icons.gif);
	background-repeat: no-repeat;
}

.help {
	background: url(<?php echo $uri ?>/images/back/help.png) no-repeat scroll right 3px transparent;
}
th label.help {
	background-position: right 1px;
	padding-right: 20px;
}
.x-help {
	background: url(<?php echo $uri ?>/images/back/help.png) no-repeat scroll 0 3px transparent;
	display: inline-block;
	font-size: 0.75em;
	margin-left: 20px;
    padding-left: 20px;
	vertical-align: top;
}

.ico-add { background-position: 2px -24px; }
.ico-clear-cache { background-position: 2px -674px; }
.ico-cancel { background-position: 2px -154px; }
.ico-close { background-position: 2px -232px;  }
.ico-configuration { background-position: 2px -206px; }
.ico-delete { background-position: 2px -258px; }
.ico-down { background-position: 2px -50px; }
.ico-edit { background-position: 2px -622px; }
.ico-folder-close { background-position: 2px -336px }
.ico-folder-open { background-position: 2px -362px }
.ico-help { background-position: 2px -440px; }
.ico-home { background-position: 2px -466px; }
.ico-left { background-position: 2px -76px; }
.ico-lock { background-position: 2px -518px; }
.ico-ok { background-position: 2px 2px; }
.ico-password, .ico.ico-quit { background-position: 2px -519px; }
.ico-page { background-position: 2px -596px; }
.ico-page-draft { background-position: 2px -726px; }
.ico-page-draft-new { background-position: 2px -960px; }
.ico-page-edit { background-position: 2px -622px; }
.ico-page-html { background-position: 2px -778px; }
.ico-page-php { background-position: 2px -700px; }
.ico-page-xml { background-position: 2px -648px; }
.ico-right { background-position: 2px -102px; }
.ico-save { background-position: 2px 2px; }
.ico-show { background-position: 2px -284px; }
.ico-unlock { background-position: 2px -544px; }
.ico-up { background-position: 2px -128px; }
.ico-user { background-position: 2px -883px; }

.ui-treeview-minus  { background-position: 2px -570px }
.ui-treeview-plus { background-position: 2px -180px }
.ui-treeview-none { background-image: none; }
.ui-treeview-minus, .ui-treeview-plus, .ui-treeview-none {
	display: inline-block;
    height: 16px;
	padding-left: 0;
	width: 16px;
}
.ui-treeview-minus, .ui-treeview-plus { cursor: pointer; }

.nav .ico-home { background-position: 5px -466px; }
.nav .ico-structure { background-position: 5px -388px; }
.nav .ico-pages { background-position: 5px -596px; }
.nav .ico-files { background-position: 5px -492px; }
.nav .ico-configuration { background-position: 5px -206px; }
.nav .ico-users { background-position: 5px -414px; }
.nav .ico-modules { background-position: 5px -856px; }

/* session status */
span.ui-session-status {
	display: inline-block;
	height: 16px;
	margin-left: 5px;
	width: 16px;
}

span.ui-session-status.status-ok {
	background: url(<?php echo $uri ?>/images/back/session-status-ok.gif) no-repeat scroll 0px 0px transparent;
}
span.ui-session-status.status-alert {
	background: url(<?php echo $uri ?>/images/back/session-status-alert.gif) no-repeat scroll 0px 0px transparent;
}
span.ui-session-status.status-ko {
	background: url(<?php echo $uri ?>/images/back/session-status-ko.gif) no-repeat scroll 0px 0px transparent;
}


/* messages box and notifications */
div#ui-notify-area {
	/*display: none;*/
	font-size: 0.75em;
	width: 300px;
	z-index: 10;
}
div.ui-message-box, div.ui-notify {
	border: 1px solid;
	margin: 10px 0px;
	padding: 0.5em;
	z-index: 10;
}
div.ui-message-box {
	position: relative;
}
div.ui-notify {
	margin: 0;
	-moz-border-radius: 3px;
	-webkit-border-radius: 3px;
	-o-border-radius: 3px;
	-ms-border-radius: 3px;
	-khtml-border-radius: 3px;
	border-radius: 3px;
}
div.ui-notify span.ui-closable, div.ui-notify span.ui-attachable {
	margin-right: 5px;
}
div.ui-notify span.ico {
	display: none;
}
div.ui-message-box.info,
div.ui-message-box.loading,
div.ui-notify.info,
div.ui-notify.loading {
	background-size: 16px;
	color: #00529b;
	background-color: #bde5f8;
}
div.ui-message-box.success,
div.ui-notify.success {
	color: #4f8a10;
	background-color: #dff2bf;
}
div.ui-message-box.warning,
div.ui-notify.warning {
	color: #9f6000;
	background-color: #feefb3;
}
div.ui-message-box.error,
div.ui-notify.error {
	color: #d8000c;
	background-color: #ffbaba;
}
div.ui-message-box.validation,
div.ui-notify.validation {
    color: #d63301;
    background-color: #ffccba;
}
div.ui-message-box ul {
	display: inline-block;
    /*float: left;*/
	margin-top: 4px;
	vertical-align: middle;
}
div.ui-message-box.loading ul {
	margin-top: 0;
}
div.ui-message-box ul li,
div.ui-notify ul li {
	list-style-type: none;
}

div.ui-message-box ul li + li,
div.ui-notify ul li + li {
	margin-top: .5em;
}

div.ui-message-box div, div.ui-notify div {
	margin: 0;
	padding: 0;
}

div.ui-message-box span.ico {
	background-repeat: no-repeat;
	background-image: url(<?php echo $uri ?>/images/back/msg.gif);
	display: inline-block;
	/*float: left;*/
	height: 32px;
	padding: 0;
	margin: 0;
	vertical-align: middle;
	width: 32px;
}

div.ui-message-box.loading span.ico {
	background-image: url('<?php echo $uri ?>/images/back/loading.gif');
	height: 16px;
	width: 16px;
}
div.ui-message-box.info span.ico { background-position: 0 -36px; }
div.ui-message-box.success span.ico { background-position: 0 -72px; }
div.ui-message-box.warning span.ico { background-position: 0 -144px; }
div.ui-message-box.error span.ico { background-position: 0 0; }
div.ui-message-box.validation span.ico { background-position: 0 -108px; }

div.ui-message-box + div.ui-message-box,
div.ui-notify + div.ui-notify {
	margin-top: .5em;
}
div#ui-messages-area div.ui-message-box:last-child {
	margin-bottom: 1.5em;
}
div.section div.ui-message-box {
	margin: 0 0.5em;
}

/* treeview component */

/* ul.ui-treeview li p.label */
ul.ui-treeview,
ul.ui-treeview ul {
	list-style: none
}
ul.ui-treeview li p {
	display: inline-block;
	margin-bottom: 0.66em;
}
ul.ui-treeview li p:hover {
	background-color: #dddfff;
}
ul.ui-treeview li p.ico {
	padding-left: 2px;
}
ul.ui-treeview li p span.ui-treeview-actions-icons {
	margin-left: 1.05em;
}

ul.ui-treeview li label {
	float: none;
	padding-right: 0px !important;
	width: auto !important;
}

/* tooltip component */
div#ui-tooltip {
	background-color: #eee;
	border: 1px solid #111;
	font-size: 0.75em;
	position: absolute;
	padding: 5px 25px;
	opacity: 0.95;
	z-index: 11;
}
div#ui-tooltip .x-help {
	font-size: 1.25em;
	margin: 0;
	/*padding: 0;*/
}

/* lightbox component */
div#ui-lightbox {
	background-color: #f8f8f8;
	border: solid 1px #000;
	max-height: 90%;
	padding: 10px;
	overflow: auto;
	z-index: 10;
}
div#ui-lightbox span.ui-closable {
	float: right;
	margin-right: 10px;
}
div#ui-lightbox div.title {
	font-weight: bold;
	margin-left: 10px;
}
div#ui-lightbox .main {
	background-color: #f8f8f8;
	border-color: #000;
	border-width: 1px 0;
	margin: 0;
	padding: 0 10px;
	-moz-border-radius: 0px;
	-webkit-border-radius: 0px;
	-o-border-radius: 0px;
	-ms-border-radius: 0px;
	-khtml-border-radius: 0px;
	border-radius: 0px;
}
div#ui-lightbox.image-lightbox .main {
	text-align: center;
}
div#ui-lightbox fieldset {
	border: none;
	margin: 0;
	padding: 0;
}
div#ui-lightbox legend { display: none; }
div#ui-lightbox input, div#ui-lightbox select, div#ui-lightbox textarea, div#ui-lightbox label + span { max-width: 200px; }
div#ui-lightbox label + span { display: inline-block; }
div#ui-lightbox label + span img { width: 100%; }

/* ui-from-to-selector */
select.ui-from-to-selector {
	height: 75px;
    width: 25em;
	vertical-align: middle;
}
a.ui-from-to-selector-up, a.ui-from-to-selector-down {
	display: block;
}
span.ui-from-to-selector-up-down {
	display: inline-block;
	padding-left: 10px;
    /*padding-top: 15px;*/
	vertical-align: middle;
}
span.ui-from-to-selector-add-remove {
	display: block;
	margin: 5px 0;
	text-align: center;
}

span.ui-closable {
	background-position: 2px -232px;
}
span.ui-attachable {
	background-position: 2px -76px;
}

span.ui-closable, span.ui-attachable {
	background-image: url(<?php echo $uri ?>/images/back/icons.gif);
	background-repeat: no-repeat;
	cursor: pointer;
	display: inline-block;
	float: right;
	font-size: 0;
	height: 16px;
	width: 16px;
}

div#ui-overlay {
	background-color: #000;
    height: 100%;
	left: 0px;
    opacity: 0.1;
    position: absolute;
	top: 0px;
	width: 100%;
	z-index: 9;
}

/* Float model, based on http://www.pixenjoy.com */
.left  { float: left; }
.right { float: right; }
.clear { clear: both; display: block; overflow: hidden; visibility: hidden; width: 0px; height: 0px; }
.hide  { display: none; }
.no-float { float: none; }

.align-right    { text-align: right; }
.align-left     { text-align: left; }
.align-center   { text-align: center; }
.align-justify  { text-align: justify; }

.margin-left { margin-left: 1.5em }

span.form-block {
	display: inline-block;
}
span.form-block textarea {
	float: none;
}
span.form-block textarea + textarea {
	display: block;
}
span.form-block span.form-block + span.form-block {
	display: block;
}

.v-space { height: .5em; }

.w_30 { width: 30%; }

.app-name-version {
	font-size: 0.75em;
	margin-top: 5px;
	text-align: right;
	vertical-align: middle;
}
.app-name-version .logo {
	background: url(<?php echo $uri ?>/images/back/logo-min.png) no-repeat scroll right top transparent;
	display: inline-block;
	height: 26px;
	margin-right: 5px;
	vertical-align: middle;
	width: 39px;
}

.app-name-version .version {
	display: inline-block;
	vertical-align: bottom;
}


/*.baseline {
	background: url(baseline-21px.gif);
}*/

@media screen and (max-width: 1100px) {
	/*body {
		font-size: 0.95em;
	}*/

	div#header {
		float: none;
		margin-bottom: .5em;
		text-align: center;
	}
}

@media screen and (max-width: 970px) {
	/**/
	.nav {
		position: relative;
		min-height: 40px;
	}
	.nav ul {
		position: absolute;
		top: 0;
		left: 0;
	}
	.nav li {
		display: none; /* hide all <li> items */
		margin: 0;

		border-bottom-width: 1px;
		border: 1px solid #006699;
		float: none;
		padding: 1px;
		-moz-border-radius: 3px;
		-webkit-border-radius: 3px;
		-o-border-radius: 3px;
		-ms-border-radius: 3px;
		-khtml-border-radius: 3px;
		border-radius: 3px;
	}
	.nav .active {
		display: block; /* show only current <li> item */
	}
	.nav a {
		display: block;

		border: none;
		margin: 0;
	}
	.nav ul:hover {
		z-index: 100;
	}
	.nav ul:hover li {
		display: block;
	}
	.nav a:hover {
		color: #000;
	}
	/**/

	div.nav + div.main {
		-moz-border-radius: 5px;
		-webkit-border-radius: 5px;
		-o-border-radius: 5px;
		-ms-border-radius: 5px;
		-khtml-border-radius: 5px;
		border-radius: 5px;
	}
}

@media screen and (max-width: 900px) {
	div#main div.main form p + p {
		margin-top: .5em;
	}
	div#main div.main form p label,
    div#main div.main form div.p label{
		display: block;
		padding: 0;
		text-align: left;
		width: 100%;
	}

	div#main div.main form p label.help,
    div#main div.main form div.p label.help {
		padding-left: 20px;
		background-position: left 3px;
	}

	div#main form p input, select, textarea {
		display: block;
		padding: 0;
	}

	div#main form p input[type="checkbox"] {
		display: inline;
	}

	div#main form p span.checkbox-group {
		margin-left: 5%;
	}
	div#main form p span.checkbox-group label,
	div#main form p span.checkbox-group input {
		display: inline-block;
		width: auto;
	}

	div#main span.form-block {
		display: inline-block;
		padding: 0;
	}

	div#main span.form-block span.form-block,
	div#main span.form-block span.form-block + span.form-block	{
		display: inline-block;
	}

	div#main select.ui-from-to-selector {
		display: inline-block;
		vertical-align: middle;
	}
}

@media screen and (max-width: 640px) /*,
screen and (max-width: 640px) and (orientation: portrait)*/ {
	div#main form {
		width: 100%;
	}
	div#main form p {
		text-align: left;
	}
	div#main form p input, form p select, form p texteara, form p span {
		float: none;
	}
	div#main form p label;
    div#main form div.p label    {
		float: none;
		display: block;
		margin-left: auto;
		margin-right: auto;
		text-align: center;
		width: auto;
	}
}