/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

XhtmlTidy.DTD["xhtml-1.0-strict"] = {
    // inline elements
    "inline": XhtmlTidy.tools.makeMap(['a', 'abbr', 'acronym', 'b', 'bdo', 'big', 'br', 'button', 'cite', 'code', 'del', 'dfn', 'em', 'i', 'img', 'input', 'ins', 'kbd', 'label', 'noscript', 'object', 'option', 'optgroup', 'q', 'samp', 'script', 'select', 'small', 'span', 'strong', 'sub', 'sup', 'textarea', 'tt', 'var']),
    // block elements
    "block":  XhtmlTidy.tools.makeMap(['address', 'map', 'area', 'base', 'blockquote', 'body', 'caption', 'col', 'colgroup', 'div', 'dl', 'dt', 'dd', 'fieldset', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'hr', 'html', 'legend', 'li', 'link', 'meta', 'ol', 'p', 'pre', 'style', 'table', 'tbody', 'td', 'tfoot', 'th', 'thead', 'title', 'tr', 'ul']),
    // empty elements
    "empty":  XhtmlTidy.tools.makeMap(['area', 'base', 'br', 'col', 'hr', 'img', 'input', 'link', 'meta', 'param']),
    // auto boolean attributes
    "attr_boolean": XhtmlTidy.tools.makeMap(["checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"]),
    // attributes validation
    "attributes": {
        "abbr": [null],
        "accept": [null],
        "accept-charset": [null],
        "accesskey": [null],
        "action": [null],
        "align": [/^(left|center|right|justify|char)$/i],
        "alt": [null],
        "archive": [null],
        "axis": [null],
        "border": [/^\d+$/],
        "cellpadding": [/^[+\-]?\d+(%|px)?$/],
        "cellspacing": [/^[+\-]?\d+(%|px)?$/],
        "char": [null],
        "charoff": [/^[+\-]?\d+(%|px)?$/],
        "charset": [null],
        "checked": [null],
        "cite": [null],
        "class": [null],
        "classid": [null],
        "codebase": [null],
        "codetype": [null],
        "cols": [/^\d+$/],
        "colspan": [/^\d+$/],
        "content": [null],
        "coords": [null],
        "data": [null],
        "datetime": [/^(\d{4})\D?(0[1-9]|1[0-2])\D?([12]\d|0[1-9]|3[01])(\D?([01]\d|2[0-3])\D?([0-5]\d)\D?([0-5]\d)?\D?(\d{3})?([zZ]|([\+-])([01]\d|2[0-3])\D?([0-5]\d)?)?)?$/],
        "declare": [null],
        "defer": [null],
        "dir": [/^(ltr|rlt)$/i],
        "disabled": [null],
        "enctype": [null],
        "for": [/^[a-z]([a-z0-9\-_\:\.]+)?$/i],
        "frame": [/^(void|above|below|hsides|lhs|rhs|vsides|box|border)$/i],
        "headers": [/^([a-z]([a-z0-9\-_\:\.]+)?(\s*,\s*)?)+$/i],
        "height": [/^[+\-]?\d+(%|px)?$/],
        "href": [null],
        "hreflang": [/^[a-z]{1,2}(-[a-z]+)?$/i],
        "http-equiv": [null],
        "id": [/^[a-z]([a-z0-9\-_\:\.]+)?$/i],
        "ismap": [null],
        "label": [null],
        "lang": [/^[a-z]{1,2}(-[a-z]+)?$/i],
        "longdesc": [null],
        "maxlength": [null],
        "media": [null],
        "method": [null],
        "multiple": [null],
        "name": [null],
        "nohref": [null],
        "onblur": [null],
        "onchange": [null],
        "onclick": [null],
        "ondblclick": [null],
        "onfocus": [null],
        "onkeydown": [null],
        "onkeypress": [null],
        "onkeyup": [null],
        "onload": [null],
        "onmousedown": [null],
        "onmousemove": [null],
        "onmouseout": [null],
        "onmouseover": [null],
        "onmouseup": [null],
        "onreset": [null],
        "onselect": [null],
        "onsubmit": [null],
        "onunload": [null],
        "profile": [null],
        "readonly": [null],
        "rel": [/^(\w+| )+$/i], //[/^(alternate|stylesheet|start|next|prev|contents|index|glossary|copyright|chapter|section|subsection|appendix|help|bookmark| |)+$/i],
        "rev": [/^(\w+| )+$/i], //[/^(alternate|stylesheet|start|next|prev|contents|index|glossary|copyright|chapter|section|subsection|appendix|help|bookmark| |)+$/i],
        "rows": [/^\d+$/],
        "rowspan": [/^\d+$/],
        "rules": [/^(none|groups|rows|cols|all)$/i],
        "scheme": [null],
        "scope": [/^(row|col|rowgroup|colgroup)$/i],
        "selected": [null],
        "shape": [/^(rect|circle|poly|default)$/i],
        "size": [null],
        "span": [null],
        "src": [null],
        "standby": [null],
        "style": [null],
        "summary": [null],
        "tabindex": [null],
        "title": [null],
        "type": [null, /^(text|password|checkbox|radio|submit|reset|file|hidden|image|button)$/],
        "usemap": [null],
        "valign": [/^(top|middle|bottom|baseline)$/i],
        "value": [null],
        "valuetype": [null],
        "width": [/^[+\-]?\d+(%|px)?$/, /^([+\-]?(\d*\.)?\d+(%|px)?(\s*,\s*)?)+$/],
        "xml:lang": [/^[a-z]{1,2}(-[a-z]+)?$/i],
        "xml:space": [null],
        "xmlns": [null]
    },
    "elements": {
     "html": {
        "attributes": {
          "dir": 0, "id": 0, "lang": 0, "xml:lang": 0, "xmlns": 0
        },
        "required_attributes": [],
        "children": ["body", "head"]
     },
      "head": {
        "attributes": {
          "dir": 0, "id": 0, "lang": 0, "profile": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["base", "link", "meta", "object", "script", "style", "title"]
     },
      "title": {
        "attributes": {
          "dir": 0, "id": 0, "lang": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": []
     },
      "base": {
        "attributes": {
          "href": 0, "id": 0
        },
        "required_attributes": ["href"],
        "children": []
     },
      "meta": {
        "attributes": {
          "content": 0, "dir": 0, "http-equiv": 0, "id": 0, "lang": 0, "name": 0, "scheme": 0, "xml:lang": 0
        },
        "required_attributes": ["content"],
        "children": []
     },
      "link": {
        "attributes": {
          "charset": 0, "class": 0, "dir": 0, "href": 0, "hreflang": 0, "id": 0, "lang": 0, "media": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rel": 0, "rev": 0, "style": 0, "title": 0, "type": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": []
     },
      "style": {
        "attributes": {
          "dir": 0, "id": 0, "lang": 0, "media": 0, "title": 0, "type": 0, "xml:lang": 0, "xml:space": 0
        },
        "required_attributes": ["type"],
        "children": []
     },
      "script": {
        "attributes": {
          "charset": 0, "defer": 0, "id": 0, "src": 0, "type": 0, "xml:space": 0
        },
        "required_attributes": ["type"],
        "children": []
     },
      "noscript": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["address", "blockquote", "del", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "noscript", "ol", "p", "pre", "script", "table", "ul"]
     },
      "body": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onload": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onunload": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["address", "blockquote", "del", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "noscript", "ol", "p", "pre", "script", "table", "ul"]
     },
      "div": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "p": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "h1": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "h2": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "h3": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "h4": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "h5": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "h6": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "ul": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["li"]
     },
      "ol": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["li"]
     },
      "li": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "dl": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["dd", "dt"]
     },
      "dt": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "dd": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "address": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "hr": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": []
     },
      "pre": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0, "xml:space": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "br", "button", "cite", "code", "del", "dfn", "em", "i", "input", "ins", "kbd", "label", "map", "q", "samp", "script", "select", "span", "strong", "textarea", "tt", "var"]
     },
      "blockquote": {
        "attributes": {
          "cite": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["address", "blockquote", "del", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "noscript", "ol", "p", "pre", "script", "table", "ul"]
     },
      "ins": {
        "attributes": {
          "cite": 0, "class": 0, "datetime": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "del": {
        "attributes": {
          "cite": 0, "class": 0, "datetime": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "a": {
        "attributes": {
          "accesskey": 0, "charset": 0, "class": 0, "coords": 0, "dir": 0, "href": 0, "hreflang": 0, "id": 0, "lang": 0, "name": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rel": 0, "rev": 0, "shape": 0, "style": 0, "tabindex": 0, "title": 0, "type": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "span": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "bdo": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": ["dir"],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "br": {
        "attributes": {
          "class": 0, "id": 0, "style": 0, "title": 0
        },
        "required_attributes": [],
        "children": []
     },
      "em": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "strong": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "dfn": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "code": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "samp": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "kbd": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "var": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "cite": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "abbr": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "acronym": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "q": {
        "attributes": {
          "cite": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "sub": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "sup": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "tt": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "i": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "b": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "big": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "small": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "object": {
        "attributes": {
          "archive": 0, "class": 0, "classid": 0, "codebase": 0, "codetype": 0, "data": 0, "declare": 0, "dir": 0, "height": 0, "id": 0, "lang": 0, "name": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "standby": 0, "style": 0, "tabindex": 0, "title": 0, "type": 0, "usemap": 0, "width": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "param", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "param": {
        "attributes": {
          "id": 0, "name": 0, "type": 0, "value": 0, "valuetype": 0
        },
        "required_attributes": [],
        "children": []
     },
      "img": {
        "attributes": {
          "alt": 0, "class": 0, "dir": 0, "height": 0, "id": 0, "ismap": 0, "lang": 0, "longdesc": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "src": 0, "style": 0, "title": 0, "usemap": 0, "width": 0, "xml:lang": 0
        },
        "required_attributes": ["alt", "src"],
        "children": []
     },
      "map": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "name": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": ["id"],
        "children": ["address", "area", "blockquote", "del", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "noscript", "ol", "p", "pre", "script", "table", "ul"]
     },
      "area": {
        "attributes": {
          "accesskey": 0, "alt": 0, "class": 0, "coords": 0, "dir": 0, "href": 0, "id": 0, "lang": 0, "nohref": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "shape": 0, "style": 0, "tabindex": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": ["alt"],
        "children": []
     },
      "form": {
        "attributes": {
          "accept": 0, "accept-charset": 0, "action": 0, "class": 0, "dir": 0, "enctype": 0, "id": 0, "lang": 0, "method": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onreset": 0, "onsubmit": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": ["action"],
        "children": ["address", "blockquote", "del", "div", "dl", "fieldset", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "noscript", "ol", "p", "pre", "script", "table", "ul"]
     },
      "label": {
        "attributes": {
          "accesskey": 0, "class": 0, "dir": 0, "for": 0, "id": 0, "lang": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "input": {
        "attributes": {
          "accept": 0, "accesskey": 0, "alt": 0, "checked": 0, "class": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "maxlength": 0, "name": 0, "onblur": 0, "onchange": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onselect": 0, "readonly": 0, "size": 0, "src": 0, "style": 0, "tabindex": 0, "title": 0, "type": 1, "usemap": 0, "value": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": []
     },
      "select": {
        "attributes": {
          "class": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "multiple": 0, "name": 0, "onblur": 0, "onchange": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "size": 0, "style": 0, "tabindex": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["optgroup", "option"]
     },
      "optgroup": {
        "attributes": {
          "class": 0, "dir": 0, "disabled": 0, "id": 0, "label": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": ["label"],
        "children": ["option"]
     },
      "option": {
        "attributes": {
          "class": 0, "dir": 0, "disabled": 0, "id": 0, "label": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "selected": 0, "style": 0, "title": 0, "value": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": []
     },
      "textarea": {
        "attributes": {
          "accesskey": 0, "class": 0, "cols": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "name": 0, "onblur": 0, "onchange": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onselect": 0, "readonly": 0, "rows": 0, "style": 0, "tabindex": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": ["cols", "rows"],
        "children": []
     },
      "fieldset": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "legend", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "legend": {
        "attributes": {
          "accesskey": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "button": {
        "attributes": {
          "accesskey": 0, "class": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "name": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "tabindex": 0, "title": 0, "type": 0, "value": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "cite", "code", "del", "dfn", "div", "dl", "em", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "small", "span", "strong", "sub", "sup", "table", "tt", "ul", "var"]
     },
      "table": {
        "attributes": {
          "border": 0, "cellpadding": 0, "cellspacing": 0, "class": 0, "dir": 0, "frame": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rules": 0, "style": 0, "summary": 0, "title": 0, "width": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr"]
     },
      "caption": {
        "attributes": {
          "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "b", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "i", "img", "input", "ins", "kbd", "label", "map", "object", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "textarea", "tt", "var"]
     },
      "thead": {
        "attributes": {
          "align": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["tr"]
     },
      "tfoot": {
        "attributes": {
          "align": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["tr"]
     },
      "tbody": {
        "attributes": {
          "align": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["tr"]
     },
      "colgroup": {
        "attributes": {
          "align": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "span": 0, "style": 0, "title": 0, "valign": 0, "width": 1, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["col"]
     },
      "col": {
        "attributes": {
          "align": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "span": 0, "style": 0, "title": 0, "valign": 0, "width": 1, "xml:lang": 0
        },
        "required_attributes": [],
        "children": []
     },
      "tr": {
        "attributes": {
          "align": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["td", "th"]
     },
      "th": {
        "attributes": {
          "abbr": 0, "align": 0, "axis": 0, "char": 0, "charoff": 0, "class": 0, "colspan": 0, "dir": 0, "headers": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rowspan": 0, "scope": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     },
      "td": {
        "attributes": {
          "abbr": 0, "align": 0, "axis": 0, "char": 0, "charoff": 0, "class": 0, "colspan": 0, "dir": 0, "headers": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rowspan": 0, "scope": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0
        },
        "required_attributes": [],
        "children": ["a", "abbr", "acronym", "address", "b", "bdo", "big", "blockquote", "br", "button", "cite", "code", "del", "dfn", "div", "dl", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "map", "noscript", "object", "ol", "p", "pre", "q", "samp", "script", "select", "small", "span", "strong", "sub", "sup", "table", "textarea", "tt", "ul", "var"]
     }
    }
};