/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

XhtmlTidy.DTD["xhtml-1.0-transitional"] = {
	"inline":       XhtmlTidy.tools.makeMap(["script", "iframe", "ins", "del", "a", "span", "bdo", "br", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "q", "sub", "sup", "tt", "i", "b", "big", "small", "u", "s", "strike", "basefont", "font", "object", "param", "applet", "img", "label", "input", "select", "optgroup", "option", "textarea", "button"]),
	"block":        XhtmlTidy.tools.makeMap(["html", "head", "title", "base", "meta", "link", "style", "noscript", "noframes", "body", "div", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "menu", "dir", "li", "dl", "dt", "dd", "address", "hr", "pre", "blockquote", "center", "map", "area", "form", "fieldset", "legend", "isindex", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td"]),
	"empty":        XhtmlTidy.tools.makeMap(["base", "meta", "link", "hr", "br", "basefont", "param", "img", "area", "input", "isindex", "col"]),
	"attr_boolean": XhtmlTidy.tools.makeMap(["checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noshade", "nowrap", "readonly", "selected"]),
	"attributes": {
		"abbr": [null],
		"accept": [null],
		"accept-charset": [null],
		"accesskey": [null],
		"action": [null],
		"align": [/^(top|middle|bottom|left|right)$/i, /^(left|center|right|justify)$/i, /^(left|center|right)$/i, /^(top|bottom|left|right)$/i, /^(left|center|right|justify|char)$/i],
		"alink": [null],
		"alt": [null],
		"archive": [null],
		"axis": [null],
		"background": [null],
		"bgcolor": [null],
		"border": [/^\d+$/, /^[+\-]?\d+(%|px)?$/],
		"cellpadding": [/^[+\-]?\d+(%|px)?$/],
		"cellspacing": [/^[+\-]?\d+(%|px)?$/],
		"char": [null],
		"charoff": [/^[+\-]?\d+(%|px)?$/],
		"charset": [null],
		"checked": [/^(checked)$/i],
		"cite": [null],
		"class": [null],
		"classid": [null],
		"clear": [/^(left|all|right|none)$/i],
		"code": [null],
		"codebase": [null],
		"codetype": [null],
		"color": [null],
		"cols": [null],
		"colspan": [null],
		"compact": [/^(compact)$/i],
		"content": [null],
		"coords": [null],
		"data": [null],
		"datetime": [/^(\d{4})\D?(0[1-9]|1[0-2])\D?([12]\d|0[1-9]|3[01])(\D?([01]\d|2[0-3])\D?([0-5]\d)\D?([0-5]\d)?\D?(\d{3})?([zZ]|([\+-])([01]\d|2[0-3])\D?([0-5]\d)?)?)?$/],
		"declare": [/^(declare)$/i],
		"defer": [/^(defer)$/i],
		"dir": [/^(ltr|rtl)$/i],
		"disabled": [/^(disabled)$/i],
		"enctype": [null],
		"face": [null],
		"for": [/^[a-z]([a-z0-9\-_\:\.]+)?$/i],
		"frame": [/^(void|above|below|hsides|lhs|rhs|vsides|box|border)$/i],
		"frameborder": [/^(1|0)$/i],
		"headers": [/^([a-z]([a-z0-9\-_\:\.]+)?(\s*,\s*)?)+$/i],
		"height": [/^[+\-]?\d+(%|px)?$/],
		"href": [null],
		"hreflang": [/^[a-z]{1,2}(-[a-z]+)?$/i],
		"hspace": [/^\d+$/],
		"http-equiv": [null],
		"id": [/^[a-z]([a-z0-9\-_\:\.]+)?$/i],
		"ismap": [/^(ismap)$/i],
		"label": [null],
		"lang": [/^[a-z]{1,2}(-[a-z]+)?$/i],
		"language": [null],
		"link": [null],
		"longdesc": [null],
		"marginheight": [/^\d+$/],
		"marginwidth": [/^\d+$/],
		"maxlength": [null],
		"media": [null],
		"method": [/^(get|post)$/i],
		"multiple": [/^(multiple)$/i],
		"name": [null],
		"nohref": [/^(nohref)$/i],
		"noshade": [/^(noshade)$/i],
		"nowrap": [/^(nowrap)$/i],
		"object": [null],
		"onblur": [null],
		"onchange": [null],
		"onclick": [null],
		"ondblclick": [null],
		"onfocus": [null],
		"onkeydown": [null],
		"onkeypress": [null],
		"onkeyup": [null],
		"onload": [null],
		"onmousedown": [null],
		"onmousemove": [null],
		"onmouseout": [null],
		"onmouseover": [null],
		"onmouseup": [null],
		"onreset": [null],
		"onselect": [null],
		"onsubmit": [null],
		"onunload": [null],
		"profile": [null],
		"prompt": [null],
		"readonly": [/^(readonly)$/i],
		"rel": [/^(alternate|stylesheet|start|next|prev|contents|index|glossary|copyright|chapter|section|subsection|appendix|help|bookmark| |)+$/i],
		"rev": [/^(alternate|stylesheet|start|next|prev|contents|index|glossary|copyright|chapter|section|subsection|appendix|help|bookmark| |)+$/i],
		"rows": [null],
		"rowspan": [null],
		"rules": [/^(none|groups|rows|cols|all)$/i],
		"scheme": [null],
		"scope": [/^(row|col|rowgroup|colgroup)$/i],
		"scrolling": [/^(yes|no|auto)$/i],
		"selected": [/^(selected)$/i],
		"shape": [/^(rect|circle|poly|default)$/i],
		"size": [/^\d+$/, null],
		"span": [null],
		"src": [null],
		"standby": [null],
		"start": [null],
		"style": [null],
		"summary": [null],
		"tabindex": [null],
		"target": [null],
		"text": [null],
		"title": [null],
		"type": [null, /^(disc|square|circle)$/i, /^(1|a|A|i|I)$/, /^(disc|square|circle)|(1|a|A|i|I)$/, /^(text|password|checkbox|radio|submit|reset|file|hidden|image|button)$/, /^(button|submit|reset)$/i],
		"usemap": [null],
		"valign": [/^(top|middle|bottom|baseline)$/i],
		"value": [null],
		"valuetype": [/^(data|ref|object)$/i],
		"vlink": [null],
		"vspace": [/^\d+$/],
		"width": [/^[+\-]?\d+(%|px)?$/, null, /^[+\-]?(\d*\.)?\d+(%|px|\*)?$/i],
		"xml:lang": [/^[a-z]{1,2}(-[a-z]+)?$/i],
		"xml:space": [/^(preserve)$/i],
		"xmlns": [null]
	},
	"elements": {
		"html": {
			"attributes": {"dir": 0, "id": 0, "lang": 0, "xml:lang": 0, "xmlns": 0},
			"required_attributes": [],
			"children": ["body", "head"]
		},
		"head": {
			"attributes": {"dir": 0, "id": 0, "lang": 0, "profile": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["base", "isindex", "link", "meta", "object", "script", "style", "title"]
		},
		"title": {
			"attributes": {"dir": 0, "id": 0, "lang": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"base": {
			"attributes": {"href": 0, "id": 0, "target": 0},
			"required_attributes": [],
			"children": []
		},
		"meta": {
			"attributes": {"content": 0, "dir": 0, "http-equiv": 0, "id": 0, "lang": 0, "name": 0, "scheme": 0, "xml:lang": 0},
			"required_attributes": ["content"],
			"children": []
		},
		"link": {
			"attributes": {"charset": 0, "class": 0, "dir": 0, "href": 0, "hreflang": 0, "id": 0, "lang": 0, "media": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rel": 0, "rev": 0, "style": 0, "target": 0, "title": 0, "type": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"style": {
			"attributes": {"dir": 0, "id": 0, "lang": 0, "media": 0, "title": 0, "type": 0, "xml:lang": 0, "xml:space": 0},
			"required_attributes": ["type"],
			"children": []
		},
		"script": {
			"attributes": {"charset": 0, "defer": 0, "id": 0, "language": 0, "src": 0, "type": 0, "xml:space": 0},
			"required_attributes": ["type"],
			"children": []
		},
		"noscript": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"iframe": {
			"attributes": {"align": 0, "class": 0, "frameborder": 0, "height": 0, "id": 0, "longdesc": 0, "marginheight": 0, "marginwidth": 0, "name": 0, "scrolling": 0, "src": 0, "style": 0, "title": 0, "width": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"noframes": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"body": {
			"attributes": {"alink": 0, "background": 0, "bgcolor": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "link": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onload": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onunload": 0, "style": 0, "text": 0, "title": 0, "vlink": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"div": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"p": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"h1": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"h2": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"h3": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"h4": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"h5": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"h6": {
			"attributes": {"align": 1, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"ul": {
			"attributes": {"class": 0, "compact": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "type": 1, "xml:lang": 0},
			"required_attributes": [],
			"children": ["li"]
		},
		"ol": {
			"attributes": {"class": 0, "compact": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "start": 0, "style": 0, "title": 0, "type": 2, "xml:lang": 0},
			"required_attributes": [],
			"children": ["li"]
		},
		"menu": {
			"attributes": {"class": 0, "compact": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["li"]
		},
		"dir": {
			"attributes": {"class": 0, "compact": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["li"]
		},
		"li": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "type": 3, "value": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"dl": {
			"attributes": {"class": 0, "compact": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["dd", "dt"]
		},
		"dt": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"dd": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"address": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "p", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"hr": {
			"attributes": {"align": 2, "class": 0, "dir": 0, "id": 0, "lang": 0, "noshade": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "size": 0, "style": 0, "title": 0, "width": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"pre": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "width": 1, "xml:lang": 0, "xml:space": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "b", "bdo", "br", "button", "cite", "code", "del", "dfn", "em", "i", "input", "ins", "kbd", "label", "q", "s", "samp", "script", "select", "span", "strike", "strong", "textarea", "tt", "u", "var"]
		},
		"blockquote": {
			"attributes": {"cite": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"center": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"ins": {
			"attributes": {"cite": 0, "class": 0, "datetime": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"del": {
			"attributes": {"cite": 0, "class": 0, "datetime": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"a": {
			"attributes": {"accesskey": 0, "charset": 0, "class": 0, "coords": 0, "dir": 0, "href": 0, "hreflang": 0, "id": 0, "lang": 0, "name": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rel": 0, "rev": 0, "shape": 0, "style": 0, "tabindex": 0, "target": 0, "title": 0, "type": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"span": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"bdo": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": ["dir"],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"br": {
			"attributes": {"class": 0, "clear": 0, "id": 0, "style": 0, "title": 0},
			"required_attributes": [],
			"children": []
		},
		"em": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"strong": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"dfn": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"code": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"samp": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"kbd": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"var": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"cite": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"abbr": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"acronym": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"q": {
			"attributes": {"cite": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"sub": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"sup": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"tt": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"i": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"b": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"big": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"small": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"u": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"s": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"strike": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"basefont": {
			"attributes": {"color": 0, "face": 0, "id": 0, "size": 1},
			"required_attributes": ["size"],
			"children": []
		},
		"font": {
			"attributes": {"class": 0, "color": 0, "dir": 0, "face": 0, "id": 0, "lang": 0, "size": 1, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"object": {
			"attributes": {"align": 0, "archive": 0, "border": 0, "class": 0, "classid": 0, "codebase": 0, "codetype": 0, "data": 0, "declare": 0, "dir": 0, "height": 0, "hspace": 0, "id": 0, "lang": 0, "name": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "standby": 0, "style": 0, "tabindex": 0, "title": 0, "type": 0, "usemap": 0, "vspace": 0, "width": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "param", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"param": {
			"attributes": {"id": 0, "name": 0, "type": 0, "value": 0, "valuetype": 0},
			"required_attributes": ["name"],
			"children": []
		},
		"applet": {
			"attributes": {"align": 0, "alt": 0, "archive": 0, "class": 0, "code": 0, "codebase": 0, "height": 0, "hspace": 0, "id": 0, "name": 0, "object": 0, "style": 0, "title": 0, "vspace": 0, "width": 0},
			"required_attributes": ["height", "width"],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "param", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"img": {
			"attributes": {"align": 0, "alt": 0, "border": 1, "class": 0, "dir": 0, "height": 0, "hspace": 0, "id": 0, "ismap": 0, "lang": 0, "longdesc": 0, "name": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "src": 0, "style": 0, "title": 0, "usemap": 0, "vspace": 0, "width": 0, "xml:lang": 0},
			"required_attributes": ["alt", "src"],
			"children": []
		},
		"map": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "name": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": ["id"],
			"children": ["address", "area", "blockquote", "center", "del", "dir", "div", "dl", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ins", "isindex", "menu", "noframes", "noscript", "ol", "p", "pre", "script", "table", "ul"]
		},
		"area": {
			"attributes": {"accesskey": 0, "alt": 0, "class": 0, "coords": 0, "dir": 0, "href": 0, "id": 0, "lang": 0, "nohref": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "shape": 0, "style": 0, "tabindex": 0, "target": 0, "title": 0, "xml:lang": 0},
			"required_attributes": ["alt"],
			"children": []
		},
		"form": {
			"attributes": {"accept": 0, "accept-charset": 0, "action": 0, "class": 0, "dir": 0, "enctype": 0, "id": 0, "lang": 0, "method": 0, "name": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onreset": 0, "onsubmit": 0, "style": 0, "target": 0, "title": 0, "xml:lang": 0},
			"required_attributes": ["action"],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"label": {
			"attributes": {"accesskey": 0, "class": 0, "dir": 0, "for": 0, "id": 0, "lang": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"input": {
			"attributes": {"accept": 0, "accesskey": 0, "align": 0, "alt": 0, "checked": 0, "class": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "maxlength": 0, "name": 0, "onblur": 0, "onchange": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onselect": 0, "readonly": 0, "size": 1, "src": 0, "style": 0, "tabindex": 0, "title": 0, "type": 4, "usemap": 0, "value": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"select": {
			"attributes": {"class": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "multiple": 0, "name": 0, "onblur": 0, "onchange": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "size": 1, "style": 0, "tabindex": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["optgroup", "option"]
		},
		"optgroup": {
			"attributes": {"class": 0, "dir": 0, "disabled": 0, "id": 0, "label": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": ["label"],
			"children": ["option"]
		},
		"option": {
			"attributes": {"class": 0, "dir": 0, "disabled": 0, "id": 0, "label": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "selected": 0, "style": 0, "title": 0, "value": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"textarea": {
			"attributes": {"accesskey": 0, "class": 0, "cols": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "name": 0, "onblur": 0, "onchange": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "onselect": 0, "readonly": 0, "rows": 0, "style": 0, "tabindex": 0, "title": 0, "xml:lang": 0},
			"required_attributes": ["cols", "rows"],
			"children": []
		},
		"fieldset": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "legend", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"legend": {
			"attributes": {"accesskey": 0, "align": 3, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"button": {
			"attributes": {"accesskey": 0, "class": 0, "dir": 0, "disabled": 0, "id": 0, "lang": 0, "name": 0, "onblur": 0, "onclick": 0, "ondblclick": 0, "onfocus": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "tabindex": 0, "title": 0, "type": 5, "value": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "small", "span", "strike", "strong", "sub", "sup", "table", "tt", "u", "ul", "var"]
		},
		"isindex": {
			"attributes": {"class": 0, "dir": 0, "id": 0, "lang": 0, "prompt": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"table": {
			"attributes": {"align": 2, "bgcolor": 0, "border": 0, "cellpadding": 0, "cellspacing": 0, "class": 0, "dir": 0, "frame": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rules": 0, "style": 0, "summary": 0, "title": 0, "width": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr"]
		},
		"caption": {
			"attributes": {"align": 3, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"]
		},
		"thead": {
			"attributes": {"align": 4, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["tr"]
		},
		"tfoot": {
			"attributes": {"align": 4, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["tr"]
		},
		"tbody": {
			"attributes": {"align": 4, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["tr"]
		},
		"colgroup": {
			"attributes": {"align": 4, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "span": 0, "style": 0, "title": 0, "valign": 0, "width": 2, "xml:lang": 0},
			"required_attributes": [],
			"children": ["col"]
		},
		"col": {
			"attributes": {"align": 4, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "span": 0, "style": 0, "title": 0, "valign": 0, "width": 2, "xml:lang": 0},
			"required_attributes": [],
			"children": []
		},
		"tr": {
			"attributes": {"align": 4, "bgcolor": 0, "char": 0, "charoff": 0, "class": 0, "dir": 0, "id": 0, "lang": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "style": 0, "title": 0, "valign": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["td", "th"]
		},
		"th": {
			"attributes": {"abbr": 0, "align": 4, "axis": 0, "bgcolor": 0, "char": 0, "charoff": 0, "class": 0, "colspan": 0, "dir": 0, "headers": 0, "height": 0, "id": 0, "lang": 0, "nowrap": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rowspan": 0, "scope": 0, "style": 0, "title": 0, "valign": 0, "width": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		},
		"td": {
			"attributes": {"abbr": 0, "align": 4, "axis": 0, "bgcolor": 0, "char": 0, "charoff": 0, "class": 0, "colspan": 0, "dir": 0, "headers": 0, "height": 0, "id": 0, "lang": 0, "nowrap": 0, "onclick": 0, "ondblclick": 0, "onkeydown": 0, "onkeypress": 0, "onkeyup": 0, "onmousedown": 0, "onmousemove": 0, "onmouseout": 0, "onmouseover": 0, "onmouseup": 0, "rowspan": 0, "scope": 0, "style": 0, "title": 0, "valign": 0, "width": 0, "xml:lang": 0},
			"required_attributes": [],
			"children": ["a", "abbr", "acronym", "address", "applet", "b", "basefont", "bdo", "big", "blockquote", "br", "button", "center", "cite", "code", "del", "dfn", "dir", "div", "dl", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "map", "menu", "noframes", "noscript", "object", "ol", "p", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "textarea", "tt", "u", "ul", "var"]
		}
	}
};