/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdChangesIndicator) {
    var weEdChangesIndicator = function(options, editor) {
        this.options = jQuery.extend({}, {
            "modified_text": "[modified]",

        }, options || {});

        this.editor = editor;
        this.$title = jQuery('title');
        this.title = jQuery.browser.msie ? document.title : this.$title.html();
    }

    weEdChangesIndicator.prototype.init = function() {
        var self = this;

        this.editor.changeIndicatorApply = function() {
            if (jQuery.browser.msie) document.title = self.title + ' ' + self.options.modified_text;
            else self.$title.html(self.title + ' ' + self.options.modified_text);
            this.changeIndicatorUnbind();
        };

        this.editor.changeIndicatorBind = function() {
            this.bind({
                "toggle.pre.weEdChangesIndicator": this.changeIndicatorUnbind,
                "toggle.post.weEdChangesIndicator": this.changeIndicatorBind,
                "updateIFrame.weEdChangesIndicator": this.changeIndicatorApply,
                "updateTextarea.weEdChangesIndicator": this.changeIndicatorApply,
                "execCommand.weEdChangesIndicator": this.changeIndicatorApply,
                "submit.pre.weEdChangesIndicator": this.changeIndicatorUnbind
            });

            // bad hack tp places submit bind in first position
            var e = this.events['submit']['pre'], t = null;
            var l = e.length;
            if (e.length > 1) {
                for (var i = 0; i < l && t === null; i++) {
                    if ('weEdChangesIndicator' === e[i].type.namespace) t = e[i];
                }
                var new_events = [t].concat(e.slice(0, i - 1)).concat(e.slice(i + 1, l - (i + 1)));
                this.events['submit']['pre'] = new_events;
            }

            this.$doc.bind('keyup.weEdChangesIndicator', function() { self.editor.changeIndicatorApply(); });
        };

        this.editor.changeIndicatorUnbind = function() {
            this.unbind('toggle.pre.weEdChangesIndicator toggle.post.weEdChangesIndicator submit.pre.weEdChangesIndicator updateIFrame.weEdChangesIndicator updateTextarea.weEdChangesIndicator execCommand.weEdChangesIndicator');
            this.$doc.unbind('keyup.weEdChangesIndicator');
        };

        this.editor.changeIndicatorBind();
    }
}