/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdCodeMirror) {
    var weEdCodeMirror = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'code_mirror';
        this.code_mirror = null;
        this.is_ok = true;

        var self = this;
        this.options = jQuery.extend({}, {
            "code_mirror": {
                "workTime": 500,
                "lineWrapping": true,
                "lineNumbers": true,
                "mode": "text/html",
                "tabMode": "indent"
            },
            "mode": ["xml/xml.js", "javascript/javascript.js", "css/css.js", "htmlmixed/htmlmixed.js"],
            "base_path": self.editor.options['plugins_path'] + "CodeMirror/",
            "path": null,
            "mode_path": null,
            "code_mirror_js": "codemirror.js",
            "autoload": true
        }, options || {});

        if (!this.options.path) this.options.path = this.options.base_path + "lib/";
        if (!this.options.mode_path) this.options.mode_path = this.options.base_path + "mode/";

        if (!weEdCodeMirror.files_loaded && this.options.autoload) {
            // load css and add rule
            // ie bug with jQuery('head')... method
            var head = document.getElementsByTagName("head")[0];
            var style_node = document.createElement('style');
            style_node.type = 'text/css';
            if ('styleSheet' in style_node) style_node.styleSheet.cssText = ".CodeMirror, .CodeMirror * { font-size: 14px !important; line-height: 18px !important; } .CodeMirror-gutter { border-right: 1px solid #999 !important; }";
            else style_node.appendChild(document.createTextNode(".CodeMirror, .CodeMirror * { font-size: 14px !important; line-height: 18px !important; } .CodeMirror-gutter { border-right: 1px solid #999 !important; }"));
            head.appendChild(style_node);

            var css_node = document.createElement('link');
            css_node.type = 'text/css';
            css_node.rel = 'stylesheet';
            css_node.href = self.options.path + "codemirror.css";
            css_node.media = 'screen';
            head.appendChild(css_node);

            // load scripts
            this.editor.loadJs(self.options.path + this.options.code_mirror_js);

            var l = this.options.mode.length;
            for (var i = 0; i < l; i++)
                this.editor.loadJs(self.options.mode_path + this.options.mode[i]);

            weEdCodeMirror.files_loaded = true;
        }
    };

    weEdCodeMirror.files_loaded = false;

    weEdCodeMirror.prototype.init = function() {
        var self = this;

        if (jQuery.browser.msie && this.editor.$container.parents('p').length) {
            this.editor.statusbarRightMessage('Can\`t load CodeMirror in a paragraph.');
            return ;
        }

        this.code_mirror = CodeMirror.fromTextArea(this.editor.$element[0],  this.options.code_mirror);

        this.editor.bind('resize.code_mirror', function() {
            self.codeMirrorResize.apply(self);
        });

        this.editor.trigger('resize');
        jQuery(this.code_mirror.getWrapperElement()).hide();


        this.editor.bind('updateTextarea.code_mirror', function(data) {
            if (!this.is_wysiwyg_mode)
                self.code_mirror.setValue(data.html);
        });


        this.editor.bind('toggle.code_mirror', function() {
            if (this.is_wysiwyg_mode) {
                self.code_mirror.save(); // save in textarea
                this.updateIFrame(this.$element.val());
                jQuery(self.code_mirror.getWrapperElement()).hide();
                this.focus();
            }
            else {
                this.$element.css({ "position": "absolute", "left": "-10000px" }); // bug on Chrome with hide()
                jQuery(self.code_mirror.getWrapperElement()).show();
                self.codeMirrorResize.apply(self);
                self.code_mirror.setValue(this.$element.val());
                self.code_mirror.focus();
            }
        });

        this.editor.bind('submit.pre.code_mirror', function(data) {
            if (!self.editor.is_wysiwyg_mode) {
                self.editor.updateIFrame(self.code_mirror.getValue());
                self.editor.updateTextarea(self.code_mirror.getValue());
            }
            else {
                self.code_mirror.setValue(self.editor.$body.html());
            }
            if (true !== data.ajax) {
                self.code_mirror.toTextArea();
                self.editor.$element.hide();
            }
        });
    };

    weEdCodeMirror.prototype.codeMirrorResize = function() {
        var css = { "width": parseInt(this.editor.$iframe.innerWidth()) + 'px', "height": parseInt(this.editor.$iframe.innerHeight()) + 'px' }
        jQuery(this.code_mirror.getScrollerElement()).css(css);
        this.code_mirror.refresh();
        if (jQuery.browser.msie && jQuery.browser.version < 8)
            jQuery(this.code_mirror.getWrapperElement()).find('div.CodeMirror-lines div:first').style('margin-left', parseInt(jQuery(this.code_mirror.getWrapperElement()).find('div.CodeMirror-gutter-text').width()) + 'px');
    };
}