/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdCssClassTools) {
    var weEdCssClassTools = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'css_class_tools';

        this.css_classes = null;
        this.css_files = [];
        this.$selected_nodes = [];
        this.$li_nodes = [];
        this.has_html_to_xhtml_plugin = false;

        //this.editor.options.buttons += ',css-class-tools';

        var self = this;

        this.editor.loadLanguage(this.plugin_name);

        this.editor.options["custom_buttons"]["css-class-tools"] = {
            "dialog": self.installDialog,
            "image": self.editor.options['images_path'] + "css-class-tools.gif",
            "css-style": { "background-position": "3px 3px" },
            "title": self._(self.plugin_name),
            "plugin": self
        };
    };

    weEdCssClassTools.prototype.init = function() {
        this.has_html_to_xhtml_plugin = this.editor.hasPlugin('html_to_xhtml');
    };

    weEdCssClassTools.prototype.installDialog = function($button) {
        var self = $button.plugin,
            i,
            $node = jQuery(self.editor.getSelectedNode()),
            node_name = self.getNodeName($node),
            $ul;

        var editor_css = [];
        for (var i in self.editor.options.css) {
            editor_css.push(self.editor.options.css[i].href);
        }
        if (editor_css.join(';') !== self.css_files.join(';')) {
            self.css_classes = null;
        }

        if (!self.css_classes) {
            self.parseCss();
        }

        $button.dialog.clearErrors();

        if ('body' === node_name) {
            $button.dialog.errors.push(self._('No editable object.'));
            $button.dialog.addButtons({"cancel": {}});

            $button.dialog.build();
            $button.dialog.hide_auto_clear = true;

            if ($button.dialog.errors.length) $button.dialog.displayErrors();

            return ;
        }

        $ul = jQuery.createElement('ul', { "class": "weed-list", "style": "max-height: 300px; overflow: auto;" });
        add_to_list($node, 0)
        $node.parents().each(function(index) {
            add_to_list(jQuery(this), (index + 1));
        });

        if (!$ul.children().length) {
            $button.dialog.errors.push(self._('No editable object.'));
            $button.dialog.addButtons({"cancel": {}});

            $button.dialog.build();
            $button.dialog.hide_auto_clear = true;

            if ($button.dialog.errors.length) $button.dialog.displayErrors();

            return ;
        }

        function add_to_list($node, index) {
            var node_name = self.getNodeName($node),
                $li = null,
                $items = null,
                $item = null,
                list = [],
                params = {},
                i, ii;

            if ('body' == node_name || 'html' == node_name) return ;
            self.$selected_nodes.push($node);

            for (i in self.css_classes) {
                for (ii in self.css_classes[i].rules) {
                    if ($node.is(self.css_classes[i].rules[ii].rule)) {
                        params = self.css_classes[i].rules[ii];
                        params.label = self.css_classes[i].label;
                        if (self.css_classes[i].longdesc) {
                            params.longdesc = self.css_classes[i].longdesc;
                        }
                        list.push(params);
                    }
                }
            }

            if (list.length) {
                $li = jQuery.createElement('li', { "text": node_name })
                        .bind('mouseover.css-class-tools', function(e) {
                            for (var i in self.$selected_nodes) {
                                self.editor.emphasisNode(self.$selected_nodes[i], false);
                            }
                            if (self.$selected_nodes && self.$selected_nodes[index]) {
                                self.editor.emphasisNode(self.$selected_nodes[index], true);
                            }
                        })
                        .bind('mouseout.css-class-tools', function(e) {
                            for (var i in self.$selected_nodes) {
                                self.editor.emphasisNode(self.$selected_nodes[i], false);
                            }
                        })
                        .bind('click.css-class-tools', function(e) {
                            var $this = jQuery(this),
                                $ul = $this.children('ul');

                            if ($ul.is(':visible')) {
                                $ul.hide();
                            }
                            else {
                                $this.siblings().children('ul').hide();
                                $ul.show();
                            }
                        });

                $items = jQuery.createElement('ul').addClass('weed-selector-list');
                for (i in list) {
                    $item = jQuery.createElement('li', { "class": "cls-" + list[i]['class'], "title": self._('rule') + ' : ' + list[i]['rule'] + '.' + list[i]['class'] }).text(list[i].label + ' (.' + list[i]['class'] + ')');

                    if ($node.hasClass(list[i]['class'])) {
                        $item.addClass('selected');
                    }
                    if (list[i].longdesc) {
                        var $span = jQuery.createElement('span').addClass('weed-css-class-longdesc').html(list[i].longdesc).hide();
                        $item.append($span);
                        $item.bind('mouseover.css-class-tools-desc', function(e) {
                            self.editor.statusbarRightMessage(jQuery(this).children('span.weed-css-class-longdesc').html(), 10000);
                        })
                        .bind('mouseout.css-class-tools-desc', function(e) {
                            self.editor.statusbarRightMessage('');
                        });
                    }

                    $item.bind('click.css-class-tools', function(e) {
                        e.stopImmediatePropagation();
                        var $this = jQuery(this),
                            elt_class = $this.attr('class').match(/\s*(cls-[\w\d\_\-]+)\s*/)[1].substring(4);

                        if (!self.$selected_nodes || index >= self.$selected_nodes.length) return ;

                        if (self.$selected_nodes[index].hasClass('weed-css-class-selected')) {
                            self.editor.emphasisNode(self.$selected_nodes[index], false);
                        }

                        if (self.$selected_nodes[index].hasClass(elt_class)) {
                            self.$selected_nodes[index].removeClass(elt_class);
                            if ('' === self.$selected_nodes[index].attr('class')) {
                                self.$selected_nodes[index].removeAttr('class');
                            }
                            $this.removeClass('selected');
                        }
                        else {
                            self.$selected_nodes[index].addClass(elt_class);
                            $this.addClass('selected');
                        }

                        self.editor.emphasisNode(self.$selected_nodes[index], true);
                        self.refresh($button, self.$selected_nodes[index]);
                    });
                    $items.append($item);
                }
                $li.append($items.hide());
                $ul.append($li);
                self.$li_nodes.push({ "li": $li, "node": $node });
            }
            return ;
        };

        $button.dialog.setBody($ul);
        var hide = $button.dialog.hide;
        $button.dialog.hide = function() {
            self.$selected_nodes = [];
            self.$li_nodes = [];

            self.editor.$doc.find('.weed-css-class-selected').each(function() {
                self.editor.emphasisNode(jQuery(this), false);
            });
            hide.apply($button.editor);
        };

        $button.dialog.build();
        $button.dialog.hide_auto_clear = true;

        if ($button.dialog.errors.length) $button.dialog.displayErrors();
    };

    weEdCssClassTools.prototype.refresh = function($button, $node) {
        $button.dialog.hide();
        $button.click();

        for (var i in this.$li_nodes) {
            if ($node[0] === this.$li_nodes[i].node[0]) {
                this.$li_nodes[i].li.click();
                return ;
            }
        }
    };

    weEdCssClassTools.prototype.getNodeName = function($node) {
        var node_name = $node.nodeName();
        if (self.has_html_to_xhtml_plugin) {
            if ('u' == node_name || 's' == node_name || 'strike' == node_name) node_name = 'span';
            else if ('b' == node_name) node_name = 'strong';
            else if ('i' == node_name) node_name = 'em';
        }
        return node_name;
    };

    weEdCssClassTools.prototype.parseCss = function() {
        var self = this,
            css_txt = '',
            css_parts = null;
            K_IN_BODY = 1,
            K_IN_COMMENT = 2,
            state = K_IN_BODY,
            parts = [],
            part = {};

        self.css_classes = {};

        loadCss();

        css_parts = css_txt.split(/(\/\*\*?|\*\/)/g);
        for (var i in css_parts) {
            var l = jQuery.trim(css_parts[i]);
            if (!l.length) continue;

            if ('/*' === l.substring(0, 2)) {
                state = K_IN_COMMENT;
                continue;
            }
            if ('*/' === l.substring(l.length - 2)) {
                state = K_IN_BODY;
                continue;
            }

            switch (state) {
                case K_IN_COMMENT:
                    l = l.split(/[\n\r]/g);
                    for (var ii in l) {
                        var ll = jQuery.trim(l[ii]).replace(/^\*\s*/, ''),
                            m = ll.match(/(\s*@(\w+)\s+(.+))/);
                        if (m && 4 === m.length) {
                            part[m[2]] = jQuery.trim(m[3]);
                        }
                    }
                    break;

                case K_IN_BODY:
                    if (part.label) {
                        var m = l.match(/(.+)\{/);
                        if (m) {
                            part.rules = [];
                            var ll = m[1].split(',');
                            for (var ii in ll) {
                                var rule = {}, css_rule = jQuery.trim(ll[ii]), cls = null;
                                if ('.' === css_rule.substring(0, 1)) {
                                    css_rule = '*' + css_rule;
                                }
                                cls = css_rule.match(/(.+)\.([\w\d\-\_]+)$/);
                                if (cls) {
                                    part.rules.push({ "rule": cls[1], "class": cls[2] });
                                }
                            }
                            if (part.rules.length) {
                                parts.push(part);
                            }
                            part = {};
                        }
                    }
                    else {
                        part = {};
                    }
                    break;
            }
        }

        parts.sort(function(a, b) {  return ((a.label == b.label) ? 0 : ((a.label > b.label) ? 1 : -1)); })
        self.css_classes = parts;

        function loadCss() {
            self.css_files = [];
            for (var i in self.editor.options.css) {
                var url = self.editor.options.css[i].href;
                self.css_files.push(url);
                jQuery.ajax({
                    "url": url,
                    "dataType": "html",
                    "success": function(css) {
                        css_txt += css;
                    },
                    async: false
                });
            }
        };
    };

    weEdCssClassTools.prototype._ = function(key) {
        return this.editor._(key, this.plugin_name)
    };
}