/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdEffects) {
    var weEdEffects = function(options, editor) {
        this.options = options;
        this.weed = editor;

        this.weed.is_enabled = true;

        // effects
        this.weed.isVisible = function() {
            return this.$container.is(':visible');
        };

        this.weed.show = function() {
            var self = this;
            this.$container.show(function() {
                self.resize();
                if (!self.is_enabled) {
                    self.is_enabled = true;
                    self.enabled(false);
                }
                self.focus();
            });
        };

        this.weed.hide = function() {
            this.$container.hide();
        };

        this.weed.enabled = function(state) {
            if (undefined === state) return this.is_enabled;

            if (this.is_enabled === state) return ;

            if (state) {
                this.$container.children('div.weed-overlay').remove();
                this.bind('resize.unbind');
            }
            else {
                var $overlay = this.displayOverlay();
                $overlay.unbind('click.overlay').addClass('disabled').style('background-color', '#fff');
                this.bind('resize.disabled', function() {
                    var position = this.$container.offset();
                    var dimensions = { "width": this.$container.outerWidth(), "height": this.$container.outerHeight(), "top": position.top, "left": position.left };
                    $overlay.css(dimensions);
                });
            }

            this.is_enabled = !this.is_enabled;
        };
    }
}