/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */


if (undefined === weEdFormatInline) {
    var weEdFormatInline = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'format_inline';

        var self = this;

        this.editor.loadLanguage(this.plugin_name);

        //this.editor.options.buttons += ',format-inline';

        this.editor.options["custom_buttons"]["format-inline"] = {
            "css-style": {"background-position": "-168px 0px"},
            "dialog": self.installDialog,
            "plugin": self,
            "title": self._(self.plugin_name)
        };
    };

    weEdFormatInline.prototype.installDialog = function($button) {
        var self = $button.plugin;

        if (!$button.$dialog) {
            var $selected_node = jQuery($button.weed.getSelectedNode());
            var $ul = jQuery.createElement('ul').addClass('weed-selector-list');
            var $li_list = [];

            jQuery.each({ "span": "span", "kbd": "kbd", "q": "q", "cite": "cite", "dfn": "dfn", "abbr": "abbr", "acronym": "acronym", "samp": "samp", "code": "code", "var": "var" }, function(key, name) {
                var $li = jQuery.createElement('li').text(self._(name))
                            .bind('click', function(e) {
                                var $this = jQuery(this);
                                if ($this.hasClass('selected')) jQuery(this).removeClass('selected');
                                else $this.addClass('selected');
                                self.exec(key, $button);
                                $button.dialog.hide();
                            })
                            .bind('mouseover', function(e) {
                                $button.weed.statusbarRightMessage('&lt;' + key + '&gt; ... &lt;/' + key + '&gt;');
                            })
                            .bind('mouseout', function(e) {
                                $button.weed.statusbarRightMessage('');
                            });
                if ($selected_node[0] && $selected_node.isNode(key) || $selected_node.parents(key).length) $li.addClass('selected');
                $ul.append($li);
                $li_list.push($li);
            });

            $button.dialog.setBody($ul);
            $button.dialog.update(function($button) {
                var $selected_node = jQuery($button.weed.getSelectedNode());
                    jQuery.each(['span', 'kbd', 'q', 'cite', 'dfn', 'abbr', 'acronym', 'samp', 'code', 'var'], function(index, key) {
                        if ($selected_node[0] && $selected_node.isNode(key) || $selected_node.parents(key).length) $li_list[index].addClass('selected');
                        else $li_list[index].removeClass('selected');
                    })
            });
            $button.dialog.build();
            $button.dialog.is_updated = true;
            $button.dialog.hide_auto_clear = false;
        }
    };

    weEdFormatInline.prototype.exec = function(key, $button) {
        var $selected_node = jQuery($button.weed.getSelectedNode(true));
        var has_key = false;

        $selected_node.parents().andSelf().each(function() {
            var $this = jQuery(this);
            if ($this.isNode(key)) {
                $content = $this.contents();
                $this.replaceWith($content);
                has_key = true;
                $button.weed.focusToNode($content[0]);
                return ;
            }
        });

        if (!has_key) {
            var html = '<' + key + '>' + $button.weed.getSelectedHtml() + '</' + key + '>';
            $button.weed.execCommand('insertHtml', html);
        }
    };

    weEdFormatInline.prototype._ = function(key) {
        return this.editor._(key, this.plugin_name);
    };
}