/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdImage) {
    var weEdImage = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'beCms_image';

        this.data = [];
        this.data_dirs = {};
        this.$select_dirs = null;
        this.$select_data = null;
        this.$select_used_data = null;
        this.data_loaded = false;

        var self = this;
        this.editor.options["custom_buttons"]["image"] = {
            "dialog": self.installDialog,
            "plugin": self
        };
    };

    weEdImage.prototype.installDialog = function($button) {
        var self = $button.plugin;
        if (!$button.$dialog) {
            if (!self.data_loaded) {
                self.getData();
                self.dataToSelect();
                self.data_loaded = true;
            }

            var $input_list = [];

            // first tab
            var $div = jQuery.createElement('div');

            var current = { "div": $div, "dirs": null, "src": null, "reload": null, "alt": null, "title": null, "legend": null, "width": null, "height": null, "thumb": null, "link": null, "box": null, "display": null, "loaded": null };

            // dirs
            var $p = jQuery.createElement('p');

            var $label = jQuery.createElement('label', { "for": "weed-image-inner-dirs", "text": self._('dir') + " : " });
            var $input = self.$select_dirs;
            $p.append($label, $input);
            $div.append($p);
            current['dirs'] = $input;

            // src
            var $p = jQuery.createElement('p');
            var $label = jQuery.createElement('label', { "for": "weed-image-inner-images", "text": self._('image') + " : " });
            var $input = self.$select_used_data;
            $p.append($label, $input);
            $div.append($p);
            current['src'] = $input;

            var $input = jQuery.createElement('button', { "id": "weed-image-inner-reload", "titl": self._('reload') })
                            .append(jQuery.createElement('img', { "src": self.editor.options['images_path'] + "reload.gif", "title": self._('reload') }));
            $p.append($input);
            $div.append($p);
            current['reload'] = $input;

            // alts
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-alt", "text": self._('alt') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-inner-alt", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['alt'] = $input;

            // title
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-title", "text": self._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-inner-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;

            // legend
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-legend", "text": self._('legend') + " : " });
            $input = jQuery.createElement('textarea', { "id": "weed-image-inner-legend", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['legend'] = $input;

            // width
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-width", "text": self._('width') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-inner-width", "class": "weed-dialog-input-small" });
            $p.append($label, $input, jQuery.createElement('span', { "text": " px"}));
            $div.append($p);
            current['width'] = $input;

            // height
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-height", "text": self._('height') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-inner-height", "class": "weed-dialog-input-small" });
            $p.append($label, $input, jQuery.createElement('span', { "text": " px"}));
            $div.append($p);
            current['height'] = $input;

            // thumb
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-thumb", "text": self._('thumb') + " : " });
            $input = jQuery.createElement('input', { "type": "checkbox", "id": "weed-image-inner-thumb", "class": "weed-dialog-input-short", "checked": "checked" })
                        .bind('change', function() {
                            $input_list[0]['width'].val('');
                            $input_list[0]['height'].val('');
                        });
            $p.append($label, $input);
            $div.append($p);
            current['thumb'] = $input;

            // link
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-link", "text": self._('link') + " : " });
            $input = jQuery.createElement('input', { "type": "checkbox", "id": "weed-image-inner-link", "class": "weed-dialog-input-short", "checked": "checked" });
            $p.append($label, $input);
            $div.append($p);
            current['link'] = $input;

            // box
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-inner-box", "text": self._('box') + " : " });
            $input = jQuery.createElement('input', { "type": "checkbox", "id": "weed-image-inner-box", "class": "weed-dialog-input-short" });
            $p.append($label, $input);
            $div.append($p);
            current['box'] = $input;

            $div.css('float', 'left');
            $p = jQuery.createElement('p', { "class": "weed-display-image" });
            $button.dialog.addTab('Image interne', jQuery.createElement('div').append($div));
            $div
                .after(jQuery.createElement('div', { "style": "clear: both;" }))
                .after(jQuery.createElement('div', { "style": "float: right; margin-left: 5px;" }).append($p));
            current['display'] = $p;
            current['loaded'] = jQuery.createElement('div').hide();
            $div.append(current['loaded']);

            $input_list.push(current);

            // second tab
            var $div = jQuery.createElement('div');

            var current = { "div": $div, "src": null, "alt": null, "title": null, "legend": null, "width": null, "height": null, "box": null };

            // src
            var $p = jQuery.createElement('p');

            var $label = jQuery.createElement('label', { "for": "weed-image-src", "text": self._('image') + " : " });
            var $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-src", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['src'] = $input;

            // alts
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-alt", "text": self._('alt') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-alt", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['alt'] = $input;

            // title
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-title", "text": self._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;

            // legend
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-legend", "text": self._('legend') + " : " });
            $input = jQuery.createElement('textarea', { "id": "weed-image-legend", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['legend'] = $input;

            // width
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-width", "text": self._('width') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-width", "class": "weed-dialog-input-small" });
            $p.append($label, $input, jQuery.createElement('span', { "text": " px"}));
            $div.append($p);
            current['width'] = $input;

            // height
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-height", "text": self._('height') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-image-height", "class": "weed-dialog-input-small" });
            $p.append($label, $input, jQuery.createElement('span', { "text": " px"}));
            $div.append($p);
            current['height'] = $input;

            // box
            $p = jQuery.createElement('p');

            $label = jQuery.createElement('label', { "for": "weed-image-box", "text": self._('box') + " : " });
            $input = jQuery.createElement('input', { "type": "checkbox", "id": "weed-image-box", "class": "weed-dialog-input-short" });
            $p.append($label, $input);
            $div.append($p);
            current['box'] = $input;

            $input_list.push(current);

            $button.dialog.addTab('Image externe', $div);

            $button.dialog.addButtons({
                "ok": { "callback": function($button) {
                    var $current = ($input_list[0]['div'].is(':visible') ? $input_list[0] : $input_list[1]),

                        src = $current['src'].val(),
                        alt = $current['alt'].val(),
                        title = $current['title'].val(),
                        legend = $current['legend'].val(),
                        width = $current['width'].val(),
                        height = $current['height'].val(),
                        href = '',
                        link = false,
                        thumb = false,
                        box = $current['box'].attr('checked') || '' != legend;

                    if ('' === src || 'http://' === src) $button.dialog.errors.push({ "error" : self._('src_required'), "element": $current['src'].parent() });
                    if ('' != width && !/^\d+$/.test(width)) $button.dialog.errors.push({ "error": self._('width_integer'), "element": $current['width'].parent() });
                    if ('' != height && !/^\d+$/.test(height)) $button.dialog.errors.push({ "error": self._('height_integer'), "element": $current['height'].parent() });

                    if ($button.dialog.errors.length) {
                        $button.dialog.displayErrors();
                        return ;
                    }

                    if ($current == $input_list[0]) {
                        var $option = $current['src'].children(':selected');
                        href = $option.val(),
                        link = $current['link'].attr('checked');
                        thumb = $current['thumb'].attr('checked');
                        src = thumb && '' !== $option.attr('data-thumb') ? $option.attr('data-thumb') : href;
                    }

                    var $node = jQuery($button.weed.getSelectedNode());
                    var temp_id = 'http://abc/' + $button.weed.getTempId() + '.png';
                    if ('img' != $node[0].nodeName.toLowerCase()) {
                        var $img = jQuery.createElement('img', { "src": temp_id }).appendTo($node),
                            $p = $img.prev();

                        if ($p.length && 'br' === $p.nodeName()) $p.remove();
                    }
                    else
                        var $img = $node;

                    if (src != $img.attr('src')) $img.attr('src', src);
                    if (alt != $img.attr('alt')) $img.attr('alt', alt);
                    if (title != $img.attr('title')) $img.attr('title', title);

                    if ('' !== width) {
                        if (width != $img.attr('width')) $img.attr('width', width);
                    }
                    else {
                        $img.removeAttr('width');
                    }
                    if ('' !== height) {
                        if (height != $img.attr('height')) $img.attr('height', height);
                    }
                    else {
                        $img.removeAttr('height');
                    }

                    var $a = $img.parents('a:first');
                    if (link && '' != href) {
                        if (!$a[0]) {
                            $a = jQuery.createElement('a', { "href": href } );
                            $img.after($a);
                            $a.append($img);
                        }
                        if ('' !== title) $a.attr('title', title);
                        $button.weed.preventLinkClick();
                    }
                    else if (!link && $a.length)  $img.unwrap('<a></a>');

                    var $obj = ($a[0] ? $a : $img);
                    var $image_box = $img.parents('div.image-box:first');
                    var $legend = $image_box.find('p.legend');
                    if (box) {
                        if (!$image_box.length) {
                            $image_box = jQuery.createElement('div', { "class": "image-box" });
                            $obj.after($image_box);
                            $image_box.append($obj);
                        }

                        if (legend && '' !== legend) {
                            if (!$legend.length) {
                                $legend = jQuery.createElement('p', { "class": "legend" });
                                $image_box.append($legend);
                            }
                            $legend.text(legend);
                        }
                        else if ($legend.length) {
                            $legend.remove();
                        }
                    }
                    else {
                        if ($image_box.length) {
                            $image_box.after($obj);
                            if ($legend.length) $obj.after($legend.html());
                            $image_box.remove();
                        }
                    }

                    $button.weed.preserveAbsoluteUrls();
                    $button.dialog.hide();
                }},
                "cancel": {}
            });

            self.installEvents($button, $input_list);
            $button.dialog.build();
            $button.dialog.hide_auto_clear = false;
        }
    };

    weEdImage.prototype.bindInputSrc = function($button, $input_list) {
        var self = $button.plugin;

        // display images with image selector
        self.$select_data.children().filter(function() { return '' != jQuery(this).val(); }).bind('mouseover.weed-image-display-image', function(e) {
            var $this = jQuery(this),
                src = ('' !== $this.attr('data-thumb') ? $this.attr('data-thumb') : $this.val()),
                $img;

                $img = jQuery.createElement('img', { "src": src }).load(function() {
                    var $this = jQuery(this), w, h, ratio, mw, mh;
                    $input_list[0]['display'].html('').append($this);
                    w = $this.width(); h = $this.height(); ratio = w / h; mw = 100; mh = 100;
                    if ((w / mw) >= (h / mh)) { $this.css('width', Math.min(w, mw) + 'px').css('height', $this.width() / ratio + 'px'); }
                    else { $this.css('height', Math.min(h, mh) + 'px').css('width', $this.height * ratio + 'px'); }
                });

            $this.bind('mouseout.weed-image-display-image', function(e) {
                $input_list[0]['loaded'].append($img);
                $input_list[0]['display'].html('');

                $this.unbind('mouseover.weed-image-display-image');
                $this.bind('mouseover.weed-image-display-image', function(e) {
                    $input_list[0]['display'].html('').append($img);
                });
            });
        });

        // dir change : update images selector
        $input_list[0]['dirs'].bind('change.weed-dir-change', function() {
            var val = jQuery(this).val();
            $input_list[0]['src'].children().remove();
            self.$select_data.find('option:first').clone(true).appendTo($input_list[0]['src']);
            if (null !== val && undefined !== val) {
                jQuery.each(self.data_dirs[val], function(index, value) {
                    self.$select_data.find('option[value="' + value + '"]').clone(true).appendTo($input_list[0]['src']);
                });
            }
            $input_list[0]['alt'].val('');
            $input_list[0]['title'].val('');
            $input_list[0]['thumb'].removeAttr('checked').attr('disabled', 'disabled');
            $input_list[0]['link'].removeAttr('checked').attr('disabled', 'disabled');
            $input_list[0]['box'].removeAttr('checked').attr('disabled', 'disabled');
        }).trigger('change.weed-dir-change');

        // image selected, update values
        $input_list[0]['src'].bind('change.weed-image', function(e) {
            var $option = jQuery(this).children(':selected');

            if ('' === $option.val()) {
                $input_list[0]['alt'].val('');
                $input_list[0]['title'].val('');
                $input_list[0]['thumb'].removeAttr('checked').attr('disabled', 'disabled');
                $input_list[0]['link'].removeAttr('checked').attr('disabled', 'disabled');
                $input_list[0]['box'].removeAttr('checked').attr('disabled', 'disabled');
            }
            else {
                $input_list[0]['alt'].val($option.attr('data-title'));
                $input_list[0]['title'].val($option.attr('data-title'));
                if ('' !== $option.attr('data-thumb')) {
                    $input_list[0]['thumb'].attr('checked', 'checked').removeAttr('disabled');
                    $input_list[0]['link'].attr('checked', 'checked').removeAttr('disabled', 'disabled');
                }
                else {
                    $input_list[0]['thumb'].removeAttr('checked').attr('disabled', 'disabled');
                    $input_list[0]['link'].removeAttr('checked').attr('disabled', 'disabled');
                }
                $input_list[0]['box'].removeAttr('disabled');
            }
        });
    };

    weEdImage.prototype.installEvents = function($button, $input_list) {
        var self = $button.plugin;

        self.bindInputSrc($button, $input_list);

        $input_list[0]['reload'].bind('click.weed-image', function(e) {
            e.preventDefault();
            var selected = $input_list[0]['src'].val(),
                selected_dir = $input_list[0]['dirs'].val();

            self.getData();
            self.dataToSelect();

            $input_list[0]['dirs'].remove();
            $input_list[0]['dirs'] = self.$select_dirs;
            jQuery('label[for="weed-image-inner-dirs"]').after($input_list[0]['dirs']);

            $input_list[0]['src'].remove();
            $input_list[0]['src'] = self.$select_used_data;
            $input_list[0]['reload'].before(self.$select_used_data);

            self.bindInputSrc($button, $input_list);

            $input_list[0]['alt'].val('');
            $input_list[0]['title'].val('');
            $input_list[0]['thumb'].removeAttr('checked').attr('disabled', 'disabled');
            $input_list[0]['link'].removeAttr('checked').attr('disabled', 'disabled');
            $input_list[0]['box'].removeAttr('checked').attr('disabled', 'disabled');

            self.$select_dirs.val(selected_dir).trigger('change');
            self.$select_data.val(selected).trigger('change');
        });

        $button.dialog.update(function($button) {
            var $node = jQuery(self.editor.getSelectedNode());

            $button.dialog.clearErrors();
            $button.dialog.display_tab = 0;

            self.$select_dirs.val("").trigger('change');

            for (var i in $input_list) {
                if ($input_list[i]['dirs']) {
                    $input_list[i]['dirs'].val('').trigger('change.weed-image');
                }
                $input_list[i]['src'].val('');
                $input_list[i]['alt'].val('');
                $input_list[i]['title'].val('');
                $input_list[i]['legend'].val('');
                $input_list[i]['width'].val('');
                $input_list[i]['height'].val('');

                if (0 === i) {
                    $input_list[i]['thumb'].removeAttr('checked').attr('disabled', 'disabled');
                    $input_list[i]['link'].removeAttr('checked').attr('disabled', 'disabled');
                    $input_list[i]['box'].removeAttr('checked').attr('disabled', 'disabled');
                }
            }

            if ('img' != $node[0].nodeName.toLowerCase()) return;

            var src = $node.attr('src');
            var alt = $node.attr('alt');
            var title = $node.attr('title');
            var width = ($node.attr('width') && '' !== $node.attr('width') ? parseInt($node.attr('width')) : '');
            var height = ($node.attr('height') && '' !== $node.attr('height') ? parseInt($node.attr('height')) : '');

            var link = false;
            var href = '';
            var thumb = false;

            var legend = '';
            var box = false;

            // box ?
            if ($node.parents('div.image-box:first').length) {
                box = true;
                var $legend_p = $node.parents('div.image-box:first').find('p.legend');
                if ($legend_p.length) legend = jQuery.trim($legend_p.text());
            }

            if ($node.parents('a:first').length) {
                link = true;
                href = $node.parents('a:first').attr('href');
            }

            // is inner image ?
            var find = false;
            self.$select_data.children().removeAttr('selected').each(function() {
                var $this = jQuery(this);

                if ('' !== $this.val()) {

                    thumb = ('' !== $this.attr('data-thumb') && src === $this.attr('data-thumb'));

                    if (src == $this.val() || '' != thumb) {
                        for (var i in self.data_dirs) {
                            if (-1 !== jQuery.inArray($this.val(), self.data_dirs[i])) {
                                $this.attr('selected', 'selected');
                                self.$select_dirs.val(i).trigger('change');
                                self.$select_used_data.find('option[value="' + $this.val() + '"]').attr('selected', 'selected');
                                break;
                            }
                        }

                        link  = (link && href === $this.val());

                        $input_list[0]['alt'].val(alt);
                        $input_list[0]['title'].val(title);
                        $input_list[0]['legend'].val(legend);
                        $input_list[0]['width'].val(width);
                        $input_list[0]['height'].val(height);

                        if (thumb) $input_list[0]['thumb'].attr('checked', 'checked').removeAttr('disabled');
                        else {
                            if ('' !== $this.attr('data-thumb')) $input_list[0]['thumb'].removeAttr('disabled');
                            else  $input_list[0]['thumb'].removeAttr('checked').attr('disabled', 'disabled');
                        }

                        if (link) $input_list[0]['link'].attr('checked', 'checked').removeAttr('disabled');
                        else $input_list[0]['link'].removeAttr('checked').removeAttr('disabled');

                        if (box) $input_list[0]['box'].attr('checked', 'checked').removeAttr('disabled');
                        else $input_list[0]['box'].removeAttr('checked').removeAttr('disabled');

                        find = true;
                        return ;
                    }
                }
            });

            if (find) return ;

            $button.dialog.display_tab = 1;

            $input_list[1]['src'].val(src);
            $input_list[1]['alt'].val(alt);
            $input_list[1]['title'].val(title);
            $input_list[1]['legend'].val(legend);
            $input_list[1]['width'].val(width);
            $input_list[1]['height'].val(height);

            if (box) $input_list[1]['box'].attr('checked', 'checked').removeAttr('disabled');
            else $input_list[1]['box'].removeAttr('checked').removeAttr('disabled');
        });
    };

    weEdImage.prototype.getData = function() {
        var data = beCms.ajax.data('images');
        this.data = data['images'];
    };

    weEdImage.prototype.dataToSelect = function() {
        var $select = jQuery.createElement('select', { "id": "weed-image-inner-images", "class": "weed-dialog-input-long" })
                            .append(jQuery.createElement('option', { "value": "", "selected": "selected" })),
            tmp_dirs = {},
            tmp_sort_dirs = [],
            dirs = {};

        function push_dir(data) {
            var d = data.dir.split('/'),
                l = d.length;

            for (var i = 0; i < l; i++) {
                var _dd = d.slice(0, i + 1),
                    dd = _dd.join('/');

                if (undefined === tmp_dirs[dd]) {
                    tmp_dirs[dd] = [];
                    tmp_sort_dirs.push(dd);
                }
            }
            tmp_dirs[data.dir].push(data.url);
        }

        for (var i = 0; i < this.data.length; i++) {
            $select.append(jQuery.createElement('option', {
                "value": this.data[i].url,
                "text": this.data[i].title,
                "data-thumb": this.data[i].thumbnail_url,
                "data-title": this.data[i].title
            }));

            push_dir(this.data[i]);
        }
        this.$select_data = $select;

        // sort dirs
        tmp_sort_dirs.sort();
        for (var i = 0; i < tmp_sort_dirs.length; i++) {
            dirs[tmp_sort_dirs[i]] = tmp_dirs[tmp_sort_dirs[i]];
        }
        tmp_sort_dirs = tmp_dirs = null;
        this.data_dirs = dirs;

        // make directory select
        $select = jQuery.createElement('select', { "id": "weed-link-inner-images-dirs", "class": "weed-dialog-input-long" });
        for (var index in dirs) {
            var label = '',
                level = index.split('/').length;

            for (level; level > 0; level--) label += '\xA0\xA0';
            label += index.split('/').pop();

            $select.append(jQuery.createElement('option', { "value": index, "text": label }));
        }
        this.$select_dirs = $select;

        // display first
        this.$select_used_data = this.$select_data.clone();
    };

    weEdImage.prototype._ = function(key) {
        return this.editor._('img_' + key);
    }
}
