/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdLink) {
    var weEdLink = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'beCms_link';

        this.data = { "pages": [], "images": [], "documents": [], "ref": [] };
        this.data_dirs = { "images": {}, "documents": {} };
        this.select_dirs = { "images": "", "documents": "" };
        this.select_data = { "pages" : "", "images": "", "documents": "", "ref": "" };
        this.select_used_data = { "images": "", "documents": "" };
        this.data_loaded = false;

        var self = this;

        this.editor.options["custom_buttons"]["link"] = {
            "dialog": self.installDialog,
            "plugin": self
        };
    };

    weEdLink.prototype.installDialog = function($button) {
        var self = $button.plugin;
        if (!$button.$dialog) {
            if (!self.data_loaded) {
                self.getData();
                self.dataToSelect();
                self.data_loaded = true;
            }

            var $href_select = jQuery.createElement('select', { "id": "weed-link-internal-href-uri", "class": "weed-dialog-input-long" });

            var $input_list = [];

            // inner link
            var $div = jQuery.createElement('div');
            var $p = jQuery.createElement('p');

            var current = { "div": $div, "url": null, "reload": null, "title": null, /*"params": null,*/ "ref": null, "load_ref": null };

            var $label = jQuery.createElement('label', { "for": "weed-link-inner-pages", "text": "Page : " });
            var $input = self.select_data['pages'];
            $p.append($label, $input);
            $div.append($p);
            current['url'] = $input;

            var $input = jQuery.createElement('button', { "id": "weed-link-inner-reload", "title": self._('reload') })
                            .append(jQuery.createElement('img', { "src": self.editor.options['images_path'] + "reload.gif", "title": self._('reload') }));
            $p.append($input);
            $div.append($p);
            current['reload'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-inner-pages-title", "text": $button.weed._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-link-inner-pages-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-inner-pages-ref", "text": "Référence : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-link-inner-pages-ref", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['ref'] = $input;

            var $input = jQuery.createElement('button', { "id": "weed-link-inner-load-ref", "title": self._('load_ref') })
                            .append(jQuery.createElement('img', { "src": self.editor.options['images_path'] + "reload.gif", "title": self._('load_ref') }));
            $p.append($input);
            $div.append($p);
            current['load_ref'] = $input;

            $input_list.push(current);

            $button.dialog.addTab('Lien interne', $div);

            // external link
            $div = jQuery.createElement('div');
            $p = jQuery.createElement('p');

            current = { "div": $div, "url": null, "title": null };

            $label = jQuery.createElement('label', { "for": "link-url", "text": $button.weed._('url') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "link-url", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['url'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-title", "text": $button.weed._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-link-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;
            $input_list.push(current);

            $button.dialog.addTab('Lien externe', $div);

            // image link
            $div = jQuery.createElement('div');
            $p = jQuery.createElement('p');

            current = { "div": $div, "dirs": null, "url": null, "reload": null, "title": null, "display": null, "loaded": null };

            $label = jQuery.createElement('label', { "for": "weed-link-inner-images-dirs", "text": "Dossier : " });
            $input = self.select_dirs['images'];
            $p.append($label, $input);
            $div.append($p);
            current['dirs'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-inner-images", "text": "Image : " });
            $input = self.select_used_data['images'];
            $p.append($label, $input);
            $div.append($p);
            current['url'] = $input;

            var $input = jQuery.createElement('button', { "id": "weed-link-inner-img-reload", "title": self._('reload') })
                            .append(jQuery.createElement('img', { "src": self.editor.options['images_path'] + "reload.gif", "title": self._('reload') }));
            $p.append($input);
            $div.append($p);
            current['reload'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-inner-title", "text": $button.weed._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-link-inner-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;

            $div.css('float', 'left');
            $p = jQuery.createElement('p', { "class": "weed-display-image" });
            $button.dialog.addTab('Image', jQuery.createElement('div').append($div));
            $div
                .after(jQuery.createElement('div', { "style": "clear: both;" }))
                .after(jQuery.createElement('div', { "style": "float: right; margin-left: 5px;" }).append($p));
            current['display'] = $p;
            current['loaded'] = jQuery.createElement('div').hide();
            $div.append(current['loaded']);

            $input_list.push(current);

            // document link
            $div = jQuery.createElement('div');
            $p = jQuery.createElement('p');

            current = { "div": $div, "dirs": null, "url": null, "reload": null, "title": null };

            $label = jQuery.createElement('label', { "for": "weed-link-inner-documents-dirs", "text": "Dossier : " });
            $input = self.select_dirs['documents'];
            $p.append($label, $input);
            $div.append($p);
            current['dirs'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-inner-documents", "text": "Document : " });
            $input = self.select_used_data['documents'];
            $p.append($label, $input);
            $div.append($p);
            current['url'] = $input;

            var $input = jQuery.createElement('button', { "id": "weed-link-inner-doc-reload", "title": self._('reload') })
                            .append(jQuery.createElement('img', { "src": self.editor.options['images_path'] + "reload.gif", "title": self._('reload') }));
            $p.append($input);
            $div.append($p);
            current['reload'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-inner-documents-title", "text": $button.weed._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-link-inner-documents-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;
            $input_list.push(current);

            $button.dialog.addTab('Document', $div);

            // internal link
            $div = jQuery.createElement('div');
            $p = jQuery.createElement('p');

            current = { "div": $div, "url": null, "title": null };

            $label = jQuery.createElement('label', { "for": "weed-link-internal-href-uri", "text": "Référence : " });
            $input = $href_select;
            $p.append($label, $input);
            $div.append($p);
            current['url'] = $input;

            $p = jQuery.createElement('p');
            $label = jQuery.createElement('label', { "for": "weed-link-internal-href-uri-title", "text": $button.weed._('title') + " : " });
            $input = jQuery.createElement('input', { "type": "text", "id": "weed-link-internal-href-uri-title", "class": "weed-dialog-input-long" });
            $p.append($label, $input);
            $div.append($p);
            current['title'] = $input;
            $input_list.push(current);

            $button.dialog.addTab('Référence', $div);

            $button.dialog.addButtons({
                "ok": { "callback": function($button) {
                    var url = null, title = null;

                    var index = 0;
                    for (var i in $input_list) {
                        if ($input_list[i]['div'].is(':visible')) {
                            index = i;
                            switch (parseInt(i)) {
                                case 0:
                                    url = 'internal-page:' + $input_list[i]['url'].val();
                                    var ref = $input_list[i]['ref'].val();
                                    if (ref.length) url += '#' + ref;
                                    break;
                                case 1:
                                    url = $button.weed.protectData($input_list[i]['url'].val());
                                    break;
                                case 2:
                                case 3:
                                case 4:
                                    url = $input_list[i]['url'].val();
                                    break;
                            }
                            title = $input_list[i]['title'].val();
                            break;
                        }
                    }

                    if (!url || '' == url || 'http://' == url) {
                        $button.dialog.errors.push({ "error": $button.weed._('url_required'), "element": $input_list[index]['url'].parent() });
                        $button.dialog.displayErrors();
                        return ;
                    }

                    var $node = jQuery($button.weed.getSelectedNode());
                    var temp_id = $button.weed.getTempId();
                    if ('a' != $node[0].nodeName.toLowerCase()) {
                        $button.weed.execCommand('createlink', temp_id);
                        var $a = $button.weed.$body.find('a[href$="' + temp_id + '"]');
                    }
                    else {
                        var $a = $node;
                    }
                    $a.attr('href', url);
                    $a.attr('title', title);
                    $button.weed.preventLinkClick();
                    $button.weed.preserveAbsoluteUrls();
                    $button.dialog.hide();
                } },
                "cancel": {}
            });
            self.installEvents($button, $input_list);
            $button.dialog.build();
            $button.dialog.hide_auto_clear = false;
        }
    };

    weEdLink.prototype.bindInputDirUrl = function($button, $input_list, type) {
        var self = $button.plugin;

        if (undefined === type) type = ['pages', 'images', 'documents'];
        else type = [type];

        // bind update title on select change
        if (-1 !== jQuery.inArray('pages', type)) {
            $input_list[0]['url'].change(function() {
                var $this = jQuery(this),
                    index = $this.children(':selected').index() - 1;

                $button.dialog.clearErrors();

                if (index < 0) $input_list[0]['title'].val('');
                else $input_list[0]['title'].val(self.data['pages'][index].title);

                if ('select' === $input_list[0]['ref'].nodeName()) {
                    $input_list[0]['ref'].remove();
                    $input_list[0]['ref'] = jQuery.createElement('input', { "type": "text", "id": "weed-link-inner-pages-ref", "class": "weed-dialog-input-long" });
                    $input_list[0]['load_ref'].before($input_list[0]['ref']);
                }
                $input_list[0]['ref'].val('');
            });
        }

        if (-1 !== jQuery.inArray('images', type)) {
            $input_list[2]['dirs'].change(function() {
                var val = jQuery(this).val();
                $input_list[2]['url'].children().remove();
                self.select_data['images'].find('option:first').clone(true).appendTo($input_list[2]['url']);
                if (null !== val && undefined !== val) {
                    self.select_data['images'].find('option[data-dir="' + val + '"]').clone(true).appendTo($input_list[2]['url']);
                }
                $input_list[2]['title'].val('');
            });

            $input_list[2]['url'].change(function() {
                var title = jQuery(this).children(':selected').attr('data-title') || '';
                $button.dialog.clearErrors();

                $input_list[2]['title'].val(title);
            });
        }

        if (-1 !== jQuery.inArray('documents', type)) {
            $input_list[3]['dirs'].change(function() {
                var val = jQuery(this).val();
                self.select_used_data['documents'].children().remove();
                self.select_data['documents'].find('option:first').clone(true).appendTo($input_list[3]['url']);
                if (null !== val && undefined !== val) {
                    self.select_data['documents'].find('option[data-dir="' + val + '"]').clone(true).appendTo($input_list[3]['url']);
                }
                $input_list[3]['title'].val('');
            });

            $input_list[3]['url'].change(function() {
                var title = jQuery(this).children(':selected').attr('data-title') || '';
                $button.dialog.clearErrors();
                $input_list[3]['title'].val(title);
            });
        }
    };

    weEdLink.prototype.installEvents = function($button, $input_list) {
        var self = $button.plugin;
        $input_list[2]['url'].children().filter(function() { return '' != jQuery(this).val(); }).bind('mouseover.weed-link-display-image', function(e) {
            var $this = jQuery(this);
            var index = $this.index() - 1;
            var src = (self.data['images'][index].thumbnail_url ? self.data['images'][index].thumbnail_url : self.data['images'][index].url);

            var $img = jQuery.createElement('img', { "src": src }).load(function() {
                var $this = jQuery(this);
                $input_list[2]['display'].html('').append($this);
                var w = $this.width(), h = $this.height(), ratio = w / h, mw = 100, mh = 100;
                if ((w / mw) >= (h / mh)) { $this.css('width', Math.min(w, mw) + 'px').css('height', $this.width() / ratio + 'px'); }
                else { $this.css('height', Math.min(h, mh) + 'px').css('width', $this.height * ratio + 'px'); }
            });

            $this.bind('mouseout.weed-link-display-image', function(e) {
                $input_list[2]['loaded'].append($img);
                $input_list[2]['display'].html('');

                $this.unbind('mouseover.weed-link-display-image');
                $this.bind('mouseover.weed-link-display-image', function(e) {
                    $input_list[2]['display'].html('').append($img);
                });
            });
        });

        self.bindInputDirUrl($button, $input_list);

        jQuery.each(['pages', 'images', 'documents'], function(index, value) {
            if (index) index++;
            $input_list[index]['reload'].bind('click.weed-image', function(e) {
                var selected = $input_list[index]['url'].val(),
                    selected_dir = ('images' === value || 'documents' === value) ? $input_list[index]['dirs'].val() : null;
                e.preventDefault();

                self.getData(value);
                self.dataToSelect(value);

                if ('images' === value || 'documents' === value) {
                    $input_list[index]['dirs'].remove();
                    $input_list[index]['dirs'] = self.select_dirs[value];
                    jQuery('label[for="weed-link-inner-' + value + '-dirs"]').after($input_list[index]['dirs']);
                }

                $input_list[index]['url'].remove();
                $input_list[index]['url'] = self.select_data[value];
                $input_list[index]['reload'].before(self.select_data[value]);
                self.bindInputDirUrl($button, $input_list, value);

                if (selected_dir)
                    self.select_dirs[value].val(selected_dir).trigger('change');

                self.select_data[value].val(selected).trigger('change');
            });
        });

        $input_list[0]['load_ref'].bind('click.weed-image', function(e) {
            var selected = $input_list[0]['ref'].val(),
                page = $input_list[0]['url'].val();

            $button.dialog.clearErrors();

            if ('' !== page) {
                self.getData('ref', page);
                if (self.data['ref'].length) {
                    self.dataToSelect('ref');
                    $input_list[0]['ref'].remove();
                    $input_list[0]['ref'] = self.select_data['ref'];
                    $input_list[0]['load_ref'].before(self.select_data['ref']);
                    self.select_data['ref'].val(selected);
                }
                else {
                    $button.dialog.errors.push({ "error": $button.weed._('no_refs'), "element": $input_list[0]['ref'].parent() });
                    $button.dialog.displayErrors();
                }
            }
            e.preventDefault();
        });

        $button.dialog.update(function($button) {
            var $node = jQuery($button.weed.getSelectedNode());
            if ('img' == $node[0].nodeName.toLowerCase() && $node.parents('a:first')) $node = $node.parents('a:first');

            $button.dialog.clearErrors();

            $input_list[4]['url'].html('').append(jQuery.createElement('option', { "value": "", "selected": "selected", "text": "" }));
            $button.weed.$body.find('*[id]').each(function() {
                var $this = jQuery(this);
                $input_list[4]['url'].append(jQuery.createElement('option', { "value": "#" + $this.attr('id'), "text": "#" + $this.attr('id') }));
            });

            if (('' == $button.weed.getSelectedText() && (!$node || ($node[0].nodeName.toLowerCase() != 'img' && $node[0].nodeName.toLowerCase() != 'a')))) {
                $button.dialog.errors.push("Aucun texte sélectionné.");
                $button.dialog.displayErrors();

                for (var i in $input_list) {
                    $input_list[i]['url'].attr('disabled', 'disabled');
                    $input_list[i]['title'].attr('disabled', 'disabled');
                }
                $button.dialog.buttons['ok'].hide();
                return;
            }

            for (var i in $input_list) {
                if ($input_list[i]['dirs']) $input_list[i]['dirs'].val('').trigger('change');
                $input_list[i]['url'].removeAttr('disabled');
                $input_list[i]['title'].val('').removeAttr('disabled');

                if ('input' == $input_list[i]['url'][0].nodeName.toLowerCase()) $input_list[i]['url'].val('http://');
                else jQuery($input_list[i]['url'].children().get(0)).attr('selected', 'selected');
            }
            $button.dialog.buttons['ok'].show();
            $button.dialog.display_tab = 0;

            var href = $node.attr('href');
            var title = $node.attr('title');

            if (!href) return ;

            var page_href = null;

            // link to internal page
            if (page_href = href.match(/internal\-page\:([\w\d\.]+)((((\?([\w\d\.=\/&;\|,%\s]+))?)((#([\w\d\.\-_]+)?)?))?)/)) {
                var ref = page_href[9];
                page_href = page_href[1];
                $button.dialog.display_tab = 0;

                $input_list[0]['url'].children().each(function() {
                    var $this = jQuery(this);
                    if (page_href == $this.val()) {
                        $this.attr('selected', 'selected');
                        return false;
                    }
                });

                $input_list[0]['title'].val(title);
                $input_list[0]['ref'].val(ref);
                return ;
            }

            // link to image
            var find = false,
                $option = self.select_data['images'].find('option[value="' + href +'"]');

            if ($option.length) {
                self.select_dirs['images'].val($option.attr('data-dir')).trigger('change');
                $input_list[2]['url'].val(href);
                $button.dialog.display_tab = 2;
                $input_list[2]['title'].val(title);

                find = true;
            }

            if (find) return;

            //* link to document ?
            $option = self.select_data['documents'].find('option[value="' + href +'"]');
            if ($option.length) {
                self.select_dirs['documents'].val($option.attr('data-dir')).trigger('change');
                $input_list[3]['url'].val(href);
                $button.dialog.display_tab = 3;
                $input_list[3]['title'].val(title);

                find = true;
            }
            if (find) return;

            //* link to reference ?
            $input_list[4]['url'].children().each(function() {
                var $this = jQuery(this);
                if (href == $this.val()) {
                    $this.attr('selected', 'selected');
                    $button.dialog.display_tab = 4;
                    $input_list[4]['title'].val(title);
                    find = true;
                    return false;
                }
            });
            if (find) return;

            $button.dialog.display_tab = 1;
            $input_list[1]['url'].val(href);
            $input_list[1]['title'].val(title);
        });
    };

    weEdLink.prototype.getData = function(data, page) {
        var d, i;
        if (undefined === data) data = 'pages;documents;images';
        if ('ref' === data) data = 'ref&ref-page=' + page;
        d = beCms.ajax.data(data);
        for (i in d) this.data[i] = d[i];
    };

    weEdLink.prototype.dataToSelect = function(data) {
        var self = this;

        if (undefined === data) data = ['pages', 'documents', 'images'];
        else data = [data];

        jQuery.each(data, function(index, name) {
            var $select = jQuery.createElement('select', { "id": "weed-link-inner-" + name, "class": "weed-dialog-input-long" })
                                .append(jQuery.createElement('option', { "value": "", "selected": "selected" })),
                tmp_dirs = {},
                tmp_sort_dirs = [],
                dirs = {},
                mkdirs = ('documents' === name || 'images' === name),
                i;

            function push_dir(data) {
                var d = data.dir.split('/'),
                    l = d.length;

                for (var i = 0; i < l; i++) {
                    var _dd = d.slice(0, i + 1),
                        dd = _dd.join('/');

                    if (undefined === tmp_dirs[dd]) {
                        tmp_dirs[dd] = [];
                        tmp_sort_dirs.push(dd);
                    }
                }
                tmp_dirs[data.dir].push(data.id || data.url);
            }

            for (i = 0; i < self.data[name].length; i++) {
                var blanks = '';
                if (self.data[name][i].level) {
                    for (var j = 0; j < self.data[name][i].level; j++) blanks += '\xA0\xA0';
                }
                $select.append(jQuery.createElement('option', { "value": (self.data[name][i].id || self.data[name][i].url),
                                                                "text": blanks + self.data[name][i].title,
                                                                "data-dir": self.data[name][i].dir,
                                                                "data-title": self.data[name][i].title }));

                if (mkdirs) {
                    push_dir(self.data[name][i]);
                }
            }

            self.select_data[name] = $select;

            if (mkdirs) {
                // sort dirs
                tmp_sort_dirs.sort();
                for (var i = 0; i < tmp_sort_dirs.length; i++) {
                    dirs[tmp_sort_dirs[i]] = tmp_dirs[tmp_sort_dirs[i]];
                }
                tmp_sort_dirs = tmp_dirs = null;
                self.data_dirs[name] = dirs;

                $select = jQuery.createElement('select', { "id": "weed-link-inner-" + name + "-dirs", "class": "weed-dialog-input-long" });
                for (var index in dirs) {
                    var label = '',
                        level = index.split('/').length;

                    for (level; level > 0; level--) label += '\xA0\xA0';
                    label += index.split('/').pop();

                    $select.append(jQuery.createElement('option', { "value": index, "text": label }));
                }
                self.select_dirs[name] = $select;

                // display first
                self.select_used_data[name] = self.select_data[name].clone();
            }
        });
    };

    weEdLink.prototype._ = function(key) {
        return this.editor._(key);
    };
}
