/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdSpecialsCharacters) {
    var weEdSpecialsCharacters = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'specials_characters';

        this.characters = {
            "Latin": {
                "chars": ["\u0041", "\u0042", "\u0043", "\u0044", "\u0045", "\u0046", "\u0047", "\u0048", "\u0049", "\u004a", "\u004b", "\u004c", "\u004d", "\u004e", "\u004f", "\u0050", "\u0051", "\u0052", "\u0053", "\u0054", "\u0055", "\u0056", "\u0057", "\u0058", "\u0059", "\u005a", "\u0061", "\u0062", "\u0063", "\u0064", "\u0065", "\u0066", "\u0067", "\u0068", "\u0069", "\u006a", "\u006b", "\u006c", "\u006d", "\u006e", "\u006f", "\u0070", "\u0071", "\u0072", "\u0073", "\u0074", "\u0075", "\u0076", "\u0077", "\u0078", "\u0079", "\u007a", "\u0030", "\u0031", "\u0032", "\u0033", "\u0034", "\u0035", "\u0036", "\u0037", "\u0038", "\u0039", "\u0021", "\u0022", "\u0023", "\u0024", "\u0025", "\u0026", "\u0027", "\u0028", "\u0029", "\u002a", "\u002b", "\u002c", "\u002d", "\u002e", "\u002f", "\u003a", "\u003b", "\u003c", "\u003d", "\u003e", "\u003f", "\u0040", "\u005b", "\u005c", "\u005d", "\u005e", "\u005f", "\u0060", "\u007b", "\u007c", "\u007d", "\u007e"]
            },
            "Latin Extended-A": {
                "chars": ["\u0100", "\u0101", "\u0102", "\u0103", "\u0104", "\u0105", "\u0106", "\u0107", "\u0108", "\u0109", "\u010a", "\u010b", "\u010c", "\u010d", "\u010e", "\u010f", "\u0110", "\u0111", "\u0112", "\u0113", "\u0114", "\u0115", "\u0116", "\u0117", "\u0118", "\u0119", "\u011a", "\u011b", "\u011c", "\u011d", "\u011e", "\u011f", "\u0120", "\u0121", "\u0122", "\u0123", "\u0124", "\u0125", "\u0126", "\u0127", "\u0128", "\u0129", "\u012a", "\u012b", "\u012c", "\u012d", "\u012e", "\u012f", "\u0130", "\u0131", "\u0132", "\u0133", "\u0134", "\u0135", "\u0136", "\u0137", "\u0138", "\u0139", "\u013a", "\u013b", "\u013c", "\u013d", "\u013e", "\u013f", "\u0140", "\u0141", "\u0142", "\u0143", "\u0144", "\u0145", "\u0146", "\u0147", "\u0148", "\u014a", "\u014b", "\u014c", "\u014d", "\u014e", "\u014f", "\u0150", "\u0151", "\u0152", "\u0153", "\u0154", "\u0155", "\u0156", "\u0157", "\u0158", "\u0159", "\u015a", "\u015b", "\u015c", "\u015d", "\u015e", "\u015f", "\u0160", "\u0161", "\u0162", "\u0163", "\u0164", "\u0165", "\u0166", "\u0167", "\u0168", "\u0169", "\u016a", "\u016b", "\u016c", "\u016d", "\u016e", "\u016f", "\u0170", "\u0171", "\u0172", "\u0173", "\u0174", "\u0175", "\u0176", "\u0177", "\u0178", "\u0179", "\u017a", "\u017b", "\u017c", "\u017d", "\u017e", "\u017f", "\u0149"]
            },
            "Latin Extended-B": {
                "chars": ["\u0180", "\u0181", "\u0182", "\u0183", "\u0184", "\u0185", "\u0186", "\u0187", "\u0188", "\u0189", "\u018a", "\u018b", "\u018c", "\u018d", "\u018e", "\u018f", "\u0190", "\u0191", "\u0192", "\u0193", "\u0194", "\u0195", "\u0196", "\u0197", "\u0198", "\u0199", "\u019a", "\u019b", "\u019c", "\u019d", "\u019e", "\u019f", "\u01a0", "\u01a1", "\u01a2", "\u01a3", "\u01a4", "\u01a5", "\u01a6", "\u01a7", "\u01a8", "\u01a9", "\u01aa", "\u01ab", "\u01ac", "\u01ad", "\u01ae", "\u01af", "\u01b0", "\u01b1", "\u01b2", "\u01b3", "\u01b4", "\u01b5", "\u01b6", "\u01b7", "\u01b8", "\u01b9", "\u01ba", "\u01bb", "\u01bc", "\u01bd", "\u01be", "\u01bf", "\u01c0", "\u01c1", "\u01c2", "\u01c3", "\u01c4", "\u01c5", "\u01c6", "\u01c7", "\u01c8", "\u01c9", "\u01ca", "\u01cb", "\u01cc", "\u01cd", "\u01ce", "\u01cf", "\u01d0", "\u01d1", "\u01d2", "\u01d3", "\u01d4", "\u01d5", "\u01d6", "\u01d7", "\u01d8", "\u01d9", "\u01da", "\u01db", "\u01dc", "\u01dd", "\u01de", "\u01df", "\u01e0", "\u01e1", "\u01e2", "\u01e3", "\u01e4", "\u01e5", "\u01e6", "\u01e7", "\u01e8", "\u01e9", "\u01ea", "\u01eb", "\u01ec", "\u01ed", "\u01ee", "\u01ef", "\u01f0", "\u01f1", "\u01f2", "\u01f3", "\u01f4", "\u01f5", "\u01f6", "\u01f7", "\u01f8", "\u01f9", "\u01fa", "\u01fb", "\u01fc", "\u01fd", "\u01fe", "\u01ff", "\u0200", "\u0201", "\u0202", "\u0203", "\u0204", "\u0205", "\u0206", "\u0207", "\u0208", "\u0209", "\u020a", "\u020b", "\u020c", "\u020d", "\u020e", "\u020f", "\u0210", "\u0211", "\u0212", "\u0213", "\u0214", "\u0215", "\u0216", "\u0217", "\u0218", "\u0219", "\u021a", "\u021b", "\u021c", "\u021d", "\u021e", "\u021f", "\u0220", "\u0221", "\u0222", "\u0223", "\u0224", "\u0225", "\u0226", "\u0227", "\u0228", "\u0229", "\u022a", "\u022b", "\u022c", "\u022d", "\u022e", "\u022f", "\u0230", "\u0231", "\u0232", "\u0233", "\u0234", "\u0235", "\u0236", "\u0237", "\u0238", "\u0239", "\u023a", "\u023b", "\u023c", "\u023d", "\u023e", "\u023f", "\u0240", "\u0241", "\u0242", "\u0243", "\u0244", "\u0245", "\u0246", "\u0247", "\u0248", "\u0249", "\u024a", "\u024b", "\u024c", "\u024d", "\u024e", "\u024f"]
            },
            "International Phonetic Alphabet": {
                "chars": ["\u0250", "\u0251", "\u0252", "\u0253", "\u0254", "\u0255", "\u0256", "\u0257", "\u0258", "\u0259", "\u025a", "\u025b", "\u025c", "\u025d", "\u025e", "\u025f", "\u0260", "\u0261", "\u0262", "\u0263", "\u0264", "\u0265", "\u0266", "\u0267", "\u0268", "\u0269", "\u026a", "\u026b", "\u026c", "\u026d", "\u026e", "\u026f", "\u0270", "\u0271", "\u0272", "\u0273", "\u0274", "\u0275", "\u0276", "\u0277", "\u0278", "\u0279", "\u027a", "\u027b", "\u027c", "\u027d", "\u027e", "\u027f", "\u0280", "\u0281", "\u0282", "\u0283", "\u0284", "\u0285", "\u0286", "\u0287", "\u0288", "\u0289", "\u028a", "\u028b", "\u028c", "\u028d", "\u028e", "\u028f", "\u0290", "\u0291", "\u0292", "\u0293", "\u0294", "\u0295", "\u0296", "\u0297", "\u0298", "\u0299", "\u029a", "\u029b", "\u029c", "\u029d", "\u029e", "\u029f", "\u02a0", "\u02a1", "\u02a2", "\u02a3", "\u02a4", "\u02a5", "\u02a6", "\u02a7", "\u02a8", "\u02a9", "\u02aa", "\u02ab", "\u02ac", "\u02ad", "\u02ae", "\u02af"]
            },
            "Greek": {
                "chars": ["\u0370", "\u0371", "\u0372", "\u0373", "\u0374", "\u0375", "\u0376", "\u0377", "\u037a", "\u037b", "\u037c", "\u037d", "\u037e", "\u0384", "\u0385", "\u0386", "\u0387", "\u0388", "\u0389", "\u038a", "\u038c", "\u038e", "\u038f", "\u0390", "\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u0396", "\u0397", "\u0398", "\u0399", "\u039a", "\u039b", "\u039c", "\u039d", "\u039e", "\u039f", "\u03a0", "\u03a1", "\u03a3", "\u03a4", "\u03a5", "\u03a6", "\u03a7", "\u03a8", "\u03a9", "\u03aa", "\u03ab", "\u03ac", "\u03ad", "\u03ae", "\u03af", "\u03b0", "\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03b8", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c2", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9", "\u03ca", "\u03cb", "\u03cc", "\u03cd", "\u03ce", "\u03cf", "\u03d0", "\u03d1", "\u03d2", "\u03d3", "\u03d4", "\u03d5", "\u03d6", "\u03d7", "\u03fa", "\u03fb", "\u03e2", "\u03e3", "\u03e4", "\u03e5", "\u03e6", "\u03e7", "\u03e8", "\u03e9", "\u03ea", "\u03eb", "\u03ec", "\u03ed", "\u03ee", "\u03ef", "\u03f0", "\u03f1", "\u03f2", "\u03f3", "\u03f4", "\u03f5", "\u03f6", "\u03f7", "\u03f8", "\u03f9", "\u03fc", "\u03fd", "\u03fe", "\u03ff"]
            },
            "Cyrillic": {
                "chars": ["\u0400", "\u0401", "\u0402", "\u0403", "\u0404", "\u0405", "\u0406", "\u0407", "\u0408", "\u0409", "\u040a", "\u040b", "\u040c", "\u040d", "\u040e", "\u040f", "\u0410", "\u0411", "\u0412", "\u0413", "\u0414", "\u0415", "\u0416", "\u0417", "\u0418", "\u0419", "\u041a", "\u041b", "\u041c", "\u041d", "\u041e", "\u041f", "\u0420", "\u0421", "\u0422", "\u0423", "\u0424", "\u0425", "\u0426", "\u0427", "\u0428", "\u0429", "\u042a", "\u042b", "\u042c", "\u042d", "\u042e", "\u042f", "\u0430", "\u0431", "\u0432", "\u0433", "\u0434", "\u0435", "\u0436", "\u0437", "\u0438", "\u0439", "\u043a", "\u043b", "\u043c", "\u043d", "\u043e", "\u043f", "\u0440", "\u0441", "\u0442", "\u0443", "\u0444", "\u0445", "\u0446", "\u0447", "\u0448", "\u0449", "\u044a", "\u044b", "\u044c", "\u044d", "\u044e", "\u044f", "\u0450", "\u0451", "\u0452", "\u0453", "\u0454", "\u0455", "\u0456", "\u0457", "\u0458", "\u0459", "\u045a", "\u045b", "\u045c", "\u045d", "\u045e", "\u045f", "\u0460", "\u0461", "\u0462", "\u0463", "\u0464", "\u0465", "\u0466", "\u0467", "\u0468", "\u0469", "\u046a", "\u046b", "\u046c", "\u046d", "\u046e", "\u046f", "\u0470", "\u0471", "\u0472", "\u0473", "\u0474", "\u0475", "\u0476", "\u0477", "\u0478", "\u0479", "\u047a", "\u047b", "\u047c", "\u047d", "\u047e", "\u047f", "\u0480", "\u0481", "\u0482", "\u0483", "\u0484", "\u0485", "\u0486", "\u0487", "\u0488", "\u0489", "\u048a", "\u048b", "\u048c", "\u048d", "\u048e", "\u048f", "\u0490", "\u0491", "\u0492", "\u0493", "\u0494", "\u0495", "\u0496", "\u0497", "\u0498", "\u0499", "\u049a", "\u049b", "\u049c", "\u049d", "\u049e", "\u049f", "\u04a0", "\u04a1", "\u04a2", "\u04a3", "\u04a4", "\u04a5", "\u04a6", "\u04a7", "\u04a8", "\u04a9", "\u04aa", "\u04ab", "\u04ac", "\u04ad", "\u04ae", "\u04af", "\u04b0", "\u04b1", "\u04b2", "\u04b3", "\u04b4", "\u04b5", "\u04b6", "\u04b7", "\u04b8", "\u04b9", "\u04ba", "\u04bb", "\u04bc", "\u04bd", "\u04be", "\u04bf", "\u04c0", "\u04c1", "\u04c2", "\u04c3", "\u04c4", "\u04c5", "\u04c6", "\u04c7", "\u04c8", "\u04c9", "\u04ca", "\u04cb", "\u04cc", "\u04cd", "\u04ce", "\u04cf", "\u04d0", "\u04d1", "\u04d2", "\u04d3", "\u04d4", "\u04d5", "\u04d6", "\u04d7", "\u04d8", "\u04d9", "\u04da", "\u04db", "\u04dc", "\u04dd", "\u04de", "\u04df", "\u04e0", "\u04e1", "\u04e2", "\u04e3", "\u04e4", "\u04e5", "\u04e6", "\u04e7", "\u04e8", "\u04e9", "\u04ea", "\u04eb", "\u04ec", "\u04ed", "\u04ee", "\u04ef", "\u04f0", "\u04f1", "\u04f2", "\u04f3", "\u04f4", "\u04f5", "\u04f6", "\u04f7", "\u04f8", "\u04f9", "\u04fa", "\u04fb", "\u04fc", "\u04fd", "\u04fe", "\u04ff"]
            },
            "Hebrew": {
                "chars": ["\u0591", "\u0592", "\u0593", "\u0594", "\u0595", "\u0596", "\u0597", "\u0598", "\u0599", "\u059a", "\u059b", "\u059c", "\u059d", "\u059e", "\u059f", "\u05a0", "\u05a1", "\u05a2", "\u05a3", "\u05a4", "\u05a5", "\u05a6", "\u05a7", "\u05a8", "\u05a9", "\u05aa", "\u05ab", "\u05ac", "\u05ad", "\u05ae", "\u05af", "\u05b0", "\u05b1", "\u05b2", "\u05b3", "\u05b4", "\u05b5", "\u05b6", "\u05b7", "\u05b8", "\u05b9", "\u05ba", "\u05bb", "\u05bc", "\u05bd", "\u05be", "\u05bf", "\u05c0", "\u05c1", "\u05c2", "\u05c3", "\u05c4", "\u05c5", "\u05c6", "\u05c7", "\u05d0", "\u05d1", "\u05d2", "\u05d3", "\u05d4", "\u05d5", "\u05d6", "\u05d7", "\u05d8", "\u05d9", "\u05da", "\u05db", "\u05dc", "\u05dd", "\u05de", "\u05df", "\u05e0", "\u05e1", "\u05e2", "\u05e3", "\u05e4", "\u05e5", "\u05e6", "\u05e7", "\u05e8", "\u05e9", "\u05ea", "\u05f0", "\u05f1", "\u05f2", "\u05f3", "\u05f4"]
            },
            "Arabic": {
                "chars": ["\u0600", "\u0601", "\u0602", "\u0603", "\u0606", "\u0607", "\u0608", "\u0609", "\u060a", "\u060b", "\u060c", "\u060d", "\u060e", "\u060f", "\u0610", "\u0611", "\u0612", "\u0613", "\u0614", "\u0615", "\u0616", "\u0617", "\u0618", "\u0619", "\u061a", "\u061b", "\u061e", "\u061f", "\u0620", "\u0621", "\u0622", "\u0623", "\u0624", "\u0625", "\u0626", "\u0627", "\u0628", "\u0629", "\u062a", "\u062b", "\u062c", "\u062d", "\u062e", "\u062f", "\u0630", "\u0631", "\u0632", "\u0633", "\u0634", "\u0635", "\u0636", "\u0637", "\u0638", "\u0639", "\u063a", "\u063b", "\u063c", "\u063d", "\u063e", "\u063f", "\u0640", "\u0641", "\u0642", "\u0643", "\u0644", "\u0645", "\u0646", "\u0647", "\u0648", "\u0649", "\u064a", "\u064b", "\u064c", "\u064d", "\u064e", "\u064f", "\u0650", "\u0651", "\u0652", "\u0653", "\u0654", "\u0655", "\u0656", "\u0657", "\u0658", "\u0659", "\u065a", "\u065b", "\u065c", "\u065d", "\u065e", "\u065f", "\u0660", "\u0661", "\u0662", "\u0663", "\u0664", "\u0665", "\u0666", "\u0667", "\u0668", "\u0669", "\u066a", "\u066b", "\u066c", "\u066d", "\u066e", "\u066f", "\u0670", "\u0671", "\u0672", "\u0673", "\u0674", "\u0675", "\u0676", "\u0677", "\u0678", "\u0679", "\u067a", "\u067b", "\u067c", "\u067d", "\u067e", "\u067f", "\u0680", "\u0681", "\u0682", "\u0683", "\u0684", "\u0685", "\u0686", "\u0687", "\u0688", "\u0689", "\u068a", "\u068b", "\u068c", "\u068d", "\u068e", "\u068f", "\u0690", "\u0691", "\u0692", "\u0693", "\u0694", "\u0695", "\u0696", "\u0697", "\u0698", "\u0699", "\u069a", "\u069b", "\u069c", "\u069d", "\u069e", "\u069f", "\u06a0", "\u06a1", "\u06a2", "\u06a3", "\u06a4", "\u06a5", "\u06a6", "\u06a7", "\u06a8", "\u06a9", "\u06aa", "\u06ab", "\u06ac", "\u06ad", "\u06ae", "\u06af", "\u06b0", "\u06b1", "\u06b2", "\u06b3", "\u06b4", "\u06b5", "\u06b6", "\u06b7", "\u06b8", "\u06b9", "\u06ba", "\u06bb", "\u06bc", "\u06bd", "\u06be", "\u06bf", "\u06c0", "\u06c1", "\u06c2", "\u06c3", "\u06c4", "\u06c5", "\u06c6", "\u06c7", "\u06c8", "\u06c9", "\u06ca", "\u06cb", "\u06cc", "\u06cd", "\u06ce", "\u06cf", "\u06d0", "\u06d1", "\u06d2", "\u06d3", "\u06d4", "\u06d5", "\u06d6", "\u06d7", "\u06d8", "\u06d9", "\u06da", "\u06db", "\u06dc", "\u06dd", "\u06de", "\u06df", "\u06e0", "\u06e1", "\u06e2", "\u06e3", "\u06e4", "\u06e5", "\u06e6", "\u06e7", "\u06e8", "\u06e9", "\u06ea", "\u06eb", "\u06ec", "\u06ed", "\u06ee", "\u06ef", "\u06f0", "\u06f1", "\u06f2", "\u06f3", "\u06f4", "\u06f5", "\u06f6", "\u06f7", "\u06f8", "\u06f9", "\u06fa", "\u06fb", "\u06fc", "\u06fd", "\u06fe", "\u06ff"]
            },
            "Latin Extended Additional": {
                "chars": ["\u1e00", "\u1e01", "\u1e02", "\u1e03", "\u1e04", "\u1e05", "\u1e06", "\u1e07", "\u1e08", "\u1e09", "\u1e0a", "\u1e0b", "\u1e0c", "\u1e0d", "\u1e0e", "\u1e0f", "\u1e10", "\u1e11", "\u1e12", "\u1e13", "\u1e14", "\u1e15", "\u1e16", "\u1e17", "\u1e18", "\u1e19", "\u1e1a", "\u1e1b", "\u1e1c", "\u1e1d", "\u1e1e", "\u1e1f", "\u1e20", "\u1e21", "\u1e22", "\u1e23", "\u1e24", "\u1e25", "\u1e26", "\u1e27", "\u1e28", "\u1e29", "\u1e2a", "\u1e2b", "\u1e2c", "\u1e2d", "\u1e2e", "\u1e2f", "\u1e30", "\u1e31", "\u1e32", "\u1e33", "\u1e34", "\u1e35", "\u1e36", "\u1e37", "\u1e38", "\u1e39", "\u1e3a", "\u1e3b", "\u1e3c", "\u1e3d", "\u1e3e", "\u1e3f", "\u1e40", "\u1e41", "\u1e42", "\u1e43", "\u1e44", "\u1e45", "\u1e46", "\u1e47", "\u1e48", "\u1e49", "\u1e4a", "\u1e4b", "\u1e4c", "\u1e4d", "\u1e4e", "\u1e4f", "\u1e50", "\u1e51", "\u1e52", "\u1e53", "\u1e54", "\u1e55", "\u1e56", "\u1e57", "\u1e58", "\u1e59", "\u1e5a", "\u1e5b", "\u1e5c", "\u1e5d", "\u1e5e", "\u1e5f", "\u1e60", "\u1e61", "\u1e62", "\u1e63", "\u1e64", "\u1e65", "\u1e66", "\u1e67", "\u1e68", "\u1e69", "\u1e6a", "\u1e6b", "\u1e6c", "\u1e6d", "\u1e6e", "\u1e6f", "\u1e70", "\u1e71", "\u1e72", "\u1e73", "\u1e74", "\u1e75", "\u1e76", "\u1e77", "\u1e78", "\u1e79", "\u1e7a", "\u1e7b", "\u1e7c", "\u1e7d", "\u1e7e", "\u1e7f", "\u1e80", "\u1e81", "\u1e82", "\u1e83", "\u1e84", "\u1e85", "\u1e86", "\u1e87", "\u1e88", "\u1e89", "\u1e8a", "\u1e8b", "\u1e8c", "\u1e8d", "\u1e8e", "\u1e8f", "\u1e90", "\u1e91", "\u1e92", "\u1e93", "\u1e94", "\u1e95", "\u1e96", "\u1e97", "\u1e98", "\u1e99", "\u1e9a", "\u1e9b", "\u1e9c", "\u1e9d", "\u1e9e", "\u1e9f", "\u1ea0", "\u1ea1", "\u1ea2", "\u1ea3", "\u1ea4", "\u1ea5", "\u1ea6", "\u1ea7", "\u1ea8", "\u1ea9", "\u1eaa", "\u1eab", "\u1eac", "\u1ead", "\u1eae", "\u1eaf", "\u1eb0", "\u1eb1", "\u1eb2", "\u1eb3", "\u1eb4", "\u1eb5", "\u1eb6", "\u1eb7", "\u1eb8", "\u1eb9", "\u1eba", "\u1ebb", "\u1ebc", "\u1ebd", "\u1ebe", "\u1ebf", "\u1ec0", "\u1ec1", "\u1ec2", "\u1ec3", "\u1ec4", "\u1ec5", "\u1ec6", "\u1ec7", "\u1ec8", "\u1ec9", "\u1eca", "\u1ecb", "\u1ecc", "\u1ecd", "\u1ece", "\u1ecf", "\u1ed0", "\u1ed1", "\u1ed2", "\u1ed3", "\u1ed4", "\u1ed5", "\u1ed6", "\u1ed7", "\u1ed8", "\u1ed9", "\u1eda", "\u1edb", "\u1edc", "\u1edd", "\u1ede", "\u1edf", "\u1ee0", "\u1ee1", "\u1ee2", "\u1ee3", "\u1ee4", "\u1ee5", "\u1ee6", "\u1ee7", "\u1ee8", "\u1ee9", "\u1eea", "\u1eeb", "\u1eec", "\u1eed", "\u1eee", "\u1eef", "\u1ef0", "\u1ef1", "\u1ef2", "\u1ef3", "\u1ef4", "\u1ef5", "\u1ef6", "\u1ef7", "\u1ef8", "\u1ef9", "\u1efa", "\u1efb", "\u1efc", "\u1efd", "\u1efe", "\u1eff"]
            },
            "General Punctuation": {
                "chars": ["\u2010", "\u2012", "\u2013", "\u2014", "\u2015", "\u2016", "\u2017", "\u2018", "\u2019", "\u201a", "\u201b", "\u201c", "\u201d", "\u201e", "\u201f", "\u2020", "\u2021", "\u2022", "\u2023", "\u2024", "\u2025", "\u2026", "\u2027", "\u2030", "\u2031", "\u2032", "\u2033", "\u2034", "\u2035", "\u2036", "\u2037", "\u2038", "\u2039", "\u203a", "\u203b", "\u203c", "\u203d", "\u203e", "\u203f", "\u2040", "\u2041", "\u2042", "\u2043", "\u2044", "\u2045", "\u2046", "\u2047", "\u2048", "\u2049", "\u204a", "\u204b", "\u204c", "\u204d", "\u204e", "\u204f", "\u2050", "\u2051", "\u2052", "\u2053", "\u2054", "\u2055", "\u2056", "\u2057", "\u2058", "\u2059", "\u205a", "\u205b", "\u205c", "\u205d", "\u205e"]
            },
            "Arrows": {
                "chars": ["\u2190", "\u2191", "\u2192", "\u2193", "\u2194", "\u2195", "\u2196", "\u2197", "\u2198", "\u2199", "\u219a", "\u219b", "\u219c", "\u219d", "\u219e", "\u219f", "\u21a0", "\u21a1", "\u21a2", "\u21a3", "\u21a4", "\u21a5", "\u21a6", "\u21a7", "\u21a8", "\u21a9", "\u21aa", "\u21ab", "\u21ac", "\u21ad", "\u21ae", "\u21af", "\u21b0", "\u21b1", "\u21b2", "\u21b3", "\u21b4", "\u21b5", "\u21b6", "\u21b7", "\u21b8", "\u21b9", "\u21ba", "\u21bb", "\u21bc", "\u21bd", "\u21be", "\u21bf", "\u21c0", "\u21c1", "\u21c2", "\u21c3", "\u21c4", "\u21c5", "\u21c6", "\u21c7", "\u21c8", "\u21c9", "\u21ca", "\u21cb", "\u21cc", "\u21cd", "\u21ce", "\u21cf", "\u21d0", "\u21d1", "\u21d2", "\u21d3", "\u21d4", "\u21d5", "\u21d6", "\u21d7", "\u21d8", "\u21d9", "\u21da", "\u21db", "\u21dc", "\u21dd", "\u21de", "\u21df", "\u21e0", "\u21e1", "\u21e2", "\u21e3", "\u21e4", "\u21e5", "\u21e6", "\u21e7", "\u21e8", "\u21e9", "\u21ea", "\u21eb", "\u21ec", "\u21ed", "\u21ee", "\u21ef", "\u21f0", "\u21f1", "\u21f2", "\u21f3", "\u21f4", "\u21f5", "\u21f6", "\u21f7", "\u21f8", "\u21f9", "\u21fa", "\u21fb", "\u21fc", "\u21fd", "\u21fe", "\u21ff"],
            },
            "Mathematical Operators": {
                "chars": ["\u2200", "\u2201", "\u2202", "\u2203", "\u2204", "\u2205", "\u2206", "\u2207", "\u2208", "\u2209", "\u220a", "\u220b", "\u220c", "\u220d", "\u220e", "\u220f", "\u2210", "\u2211", "\u2212", "\u2213", "\u2214", "\u2215", "\u2216", "\u2217", "\u2218", "\u2219", "\u221a", "\u221b", "\u221c", "\u221d", "\u221e", "\u221f", "\u2220", "\u2221", "\u2222", "\u2223", "\u2224", "\u2225", "\u2226", "\u2227", "\u2228", "\u2229", "\u222a", "\u222b", "\u222c", "\u222d", "\u222e", "\u222f", "\u2230", "\u2231", "\u2232", "\u2233", "\u2234", "\u2235", "\u2236", "\u2237", "\u2238", "\u2239", "\u223a", "\u223b", "\u223c", "\u223d", "\u223e", "\u223f", "\u2240", "\u2241", "\u2242", "\u2243", "\u2244", "\u2245", "\u2246", "\u2247", "\u2248", "\u2249", "\u224a", "\u224b", "\u224c", "\u224d", "\u224e", "\u224f", "\u2250", "\u2251", "\u2252", "\u2253", "\u2254", "\u2255", "\u2256", "\u2257", "\u2258", "\u2259", "\u225a", "\u225b", "\u225c", "\u225d", "\u225e", "\u225f", "\u2260", "\u2261", "\u2262", "\u2263", "\u2264", "\u2265", "\u2266", "\u2267", "\u2268", "\u2269", "\u226a", "\u226b", "\u226c", "\u226d", "\u226e", "\u226f", "\u2270", "\u2271", "\u2272", "\u2273", "\u2274", "\u2275", "\u2276", "\u2277", "\u2278", "\u2279", "\u227a", "\u227b", "\u227c", "\u227d", "\u227e", "\u227f", "\u2280", "\u2281", "\u2282", "\u2283", "\u2284", "\u2285", "\u2286", "\u2287", "\u2288", "\u2289", "\u228a", "\u228b", "\u228c", "\u228d", "\u228e", "\u228f", "\u2290", "\u2291", "\u2292", "\u2293", "\u2294", "\u2295", "\u2296", "\u2297", "\u2298", "\u2299", "\u229a", "\u229b", "\u229c", "\u229d", "\u229e", "\u229f", "\u22a0", "\u22a1", "\u22a2", "\u22a3", "\u22a4", "\u22a5", "\u22a6", "\u22a7", "\u22a8", "\u22a9", "\u22aa", "\u22ab", "\u22ac", "\u22ad", "\u22ae", "\u22af", "\u22b0", "\u22b1", "\u22b2", "\u22b3", "\u22b4", "\u22b5", "\u22b6", "\u22b7", "\u22b8", "\u22b9", "\u22ba", "\u22bb", "\u22bc", "\u22bd", "\u22be", "\u22bf", "\u22c0", "\u22c1", "\u22c2", "\u22c3", "\u22c4", "\u22c5", "\u22c6", "\u22c7", "\u22c8", "\u22c9", "\u22ca", "\u22cb", "\u22cc", "\u22cd", "\u22ce", "\u22cf", "\u22d0", "\u22d1", "\u22d2", "\u22d3", "\u22d4", "\u22d5", "\u22d6", "\u22d7", "\u22d8", "\u22d9", "\u22da", "\u22db", "\u22dc", "\u22dd", "\u22de", "\u22df", "\u22e0", "\u22e1", "\u22e2", "\u22e3", "\u22e4", "\u22e5", "\u22e6", "\u22e7", "\u22e8", "\u22e9", "\u22ea", "\u22eb", "\u22ec", "\u22ed", "\u22ee", "\u22ef", "\u22f0", "\u22f1", "\u22f2", "\u22f3", "\u22f4", "\u22f5", "\u22f6", "\u22f7", "\u22f8", "\u22f9", "\u22fa", "\u22fb", "\u22fc", "\u22fd", "\u22fe", "\u22ff"],
            },
            "Currency Symbols": {
                "chars": ["\u20a0", "\u20a1", "\u20a2", "\u20a3", "\u20a4", "\u20a5", "\u20a6", "\u20a7", "\u20a8", "\u20a9", "\u20aa", "\u20ab", "\u20ac", "\u20ad", "\u20ae", "\u20af", "\u20b0", "\u20b1", "\u20b2", "\u20b3", "\u20b4", "\u20b5", "\u20b6", "\u20b7", "\u20b8", "\u20b9"]
            },
            "Miscellaneous Symbols": {
                "chars": ["\u2600", "\u2601", "\u2602", "\u2603", "\u2604", "\u2605", "\u2606", "\u2607", "\u2608", "\u2609", "\u260a", "\u260b", "\u260c", "\u260d", "\u260e", "\u260f", "\u2610", "\u2611", "\u2612", "\u2613", "\u2614", "\u2615", "\u2616", "\u2617", "\u2618", "\u2619", "\u261a", "\u261b", "\u261c", "\u261d", "\u261e", "\u261f", "\u2620", "\u2621", "\u2622", "\u2623", "\u2624", "\u2625", "\u2626", "\u2627", "\u2628", "\u2629", "\u262a", "\u262b", "\u262c", "\u262d", "\u262e", "\u262f", "\u2630", "\u2631", "\u2632", "\u2633", "\u2634", "\u2635", "\u2636", "\u2637", "\u2638", "\u2639", "\u263a", "\u263b", "\u263c", "\u263d", "\u263e", "\u263f", "\u2640", "\u2641", "\u2642", "\u2643", "\u2644", "\u2645", "\u2646", "\u2647", "\u2648", "\u2649", "\u264a", "\u264b", "\u264c", "\u264d", "\u264e", "\u264f", "\u2650", "\u2651", "\u2652", "\u2653", "\u2654", "\u2655", "\u2656", "\u2657", "\u2658", "\u2659", "\u265a", "\u265b", "\u265c", "\u265d", "\u265e", "\u265f", "\u2660", "\u2661", "\u2662", "\u2663", "\u2664", "\u2665", "\u2666", "\u2667", "\u2668", "\u2669", "\u266a", "\u266b", "\u266c", "\u266d", "\u266e", "\u266f", "\u2670", "\u2671", "\u2672", "\u2673", "\u2674", "\u2675", "\u2676", "\u2677", "\u2678", "\u2679", "\u267a", "\u267b", "\u267c", "\u267d", "\u267e", "\u267f", "\u2680", "\u2681", "\u2682", "\u2683", "\u2684", "\u2685", "\u2686", "\u2687", "\u2688", "\u2689", "\u268a", "\u268b", "\u268c", "\u268d", "\u268e", "\u268f", "\u2690", "\u2691", "\u2692", "\u2693", "\u2694", "\u2695", "\u2696", "\u2697", "\u2698", "\u2699", "\u269a", "\u269b", "\u269c", "\u269d", "\u26a0", "\u26a1", "\u26a2", "\u26a3", "\u26a4", "\u26a5", "\u26a6", "\u26a7", "\u26a8", "\u26a9", "\u26aa", "\u26ab", "\u26ac", "\u26ad", "\u26ae", "\u26af", "\u26b0", "\u26b1", "\u26b2", "\u26b3", "\u26b4", "\u26b5", "\u26b6", "\u26b7", "\u26b8", "\u26b9", "\u26ba", "\u26bb", "\u26bc", "\u26c0", "\u26c1", "\u26c2", "\u26c3"],
            },
            "Miscellaneous Technical": {
                "chars": ["\u2300", "\u2301", "\u2302", "\u2303", "\u2304", "\u2305", "\u2306", "\u2307", "\u2308", "\u2309", "\u230a", "\u230b", "\u230c", "\u230d", "\u230e", "\u230f", "\u2310", "\u2311", "\u2312", "\u2313", "\u2314", "\u2315", "\u2316", "\u2317", "\u2318", "\u2319", "\u231a", "\u231b", "\u231c", "\u231d", "\u231e", "\u231f", "\u2320", "\u2321", "\u2322", "\u2323", "\u2324", "\u2325", "\u2326", "\u2327", "\u2328", "\u2329", "\u232a", "\u232b", "\u232c", "\u232d", "\u232e", "\u232f", "\u2330", "\u2331", "\u2332", "\u2333", "\u2334", "\u2335", "\u2336", "\u2337", "\u2338", "\u2339", "\u233a", "\u233b", "\u233c", "\u233d", "\u233e", "\u233f", "\u2340", "\u2341", "\u2342", "\u2343", "\u2344", "\u2345", "\u2346", "\u2347", "\u2348", "\u2349", "\u234a", "\u234b", "\u234c", "\u234d", "\u234e", "\u234f", "\u2350", "\u2351", "\u2352", "\u2353", "\u2354", "\u2355", "\u2356", "\u2357", "\u2358", "\u2359", "\u235a", "\u235b", "\u235c", "\u235d", "\u235e", "\u235f", "\u2360", "\u2361", "\u2362", "\u2363", "\u2364", "\u2365", "\u2366", "\u2367", "\u2368", "\u2369", "\u236a", "\u236b", "\u236c", "\u236d", "\u236e", "\u236f", "\u2370", "\u2371", "\u2372", "\u2373", "\u2374", "\u2375", "\u2376", "\u2377", "\u2378", "\u2379", "\u237a", "\u237b", "\u237c", "\u237d", "\u237e", "\u237f", "\u2380", "\u2381", "\u2382", "\u2383", "\u2384", "\u2385", "\u2386", "\u2387", "\u2388", "\u2389", "\u238a", "\u238b", "\u238c", "\u238d", "\u238e", "\u238f", "\u2390", "\u2391", "\u2392", "\u2393", "\u2394", "\u2395", "\u2396", "\u2397", "\u2398", "\u2399", "\u239a", "\u239b", "\u239c", "\u239d", "\u239e", "\u239f", "\u23a0", "\u23a1", "\u23a2", "\u23a3", "\u23a4", "\u23a5", "\u23a6", "\u23a7", "\u23a8", "\u23a9", "\u23aa", "\u23ab", "\u23ac", "\u23ad", "\u23ae", "\u23af", "\u23b0", "\u23b1", "\u23b2", "\u23b3", "\u23b4", "\u23b5", "\u23b6", "\u23b7", "\u23b8", "\u23b9", "\u23ba", "\u23bb", "\u23bc", "\u23bd", "\u23be", "\u23bf", "\u23c0", "\u23c1", "\u23c2", "\u23c3", "\u23c4", "\u23c5", "\u23c6", "\u23c7", "\u23c8", "\u23c9", "\u23ca", "\u23cb", "\u23cc", "\u23cd", "\u23ce", "\u23cf", "\u23d0", "\u23d1", "\u23d2", "\u23d3", "\u23d4", "\u23d5", "\u23d6", "\u23d7", "\u23d8", "\u23d9", "\u23da", "\u23db", "\u23dc", "\u23dd", "\u23de", "\u23df", "\u23e0", "\u23e1", "\u23e2", "\u23e3", "\u23e4", "\u23e5", "\u23e6", "\u23e7", "\u23e8", "\u23e9", "\u23ea", "\u23eb", "\u23ec", "\u23ed", "\u23ee", "\u23ef", "\u23f0", "\u23f1", "\u23f2"]
            },
            "Enclosed Alphanumerics": {
                "chars": ["\u2460", "\u2461", "\u2462", "\u2463", "\u2464", "\u2465", "\u2466", "\u2467", "\u2468", "\u2469", "\u246a", "\u246b", "\u246c", "\u246d", "\u246e", "\u246f", "\u2470", "\u2471", "\u2472", "\u2473", "\u2474", "\u2475", "\u2476", "\u2477", "\u2478", "\u2479", "\u247a", "\u247b", "\u247c", "\u247d", "\u247e", "\u247f", "\u2480", "\u2481", "\u2482", "\u2483", "\u2484", "\u2485", "\u2486", "\u2487", "\u2488", "\u2489", "\u248a", "\u248b", "\u248c", "\u248d", "\u248e", "\u248f", "\u2490", "\u2491", "\u2492", "\u2493", "\u2494", "\u2495", "\u2496", "\u2497", "\u2498", "\u2499", "\u249a", "\u249b", "\u249c", "\u249d", "\u249e", "\u249f", "\u24a0", "\u24a1", "\u24a2", "\u24a3", "\u24a4", "\u24a5", "\u24a6", "\u24a7", "\u24a8", "\u24a9", "\u24aa", "\u24ab", "\u24ac", "\u24ad", "\u24ae", "\u24af", "\u24b0", "\u24b1", "\u24b2", "\u24b3", "\u24b4", "\u24b5", "\u24b6", "\u24b7", "\u24b8", "\u24b9", "\u24ba", "\u24bb", "\u24bc", "\u24bd", "\u24be", "\u24bf", "\u24c0", "\u24c1", "\u24c2", "\u24c3", "\u24c4", "\u24c5", "\u24c6", "\u24c7", "\u24c8", "\u24c9", "\u24ca", "\u24cb", "\u24cc", "\u24cd", "\u24ce", "\u24cf", "\u24d0", "\u24d1", "\u24d2", "\u24d3", "\u24d4", "\u24d5", "\u24d6", "\u24d7", "\u24d8", "\u24d9", "\u24da", "\u24db", "\u24dc", "\u24dd", "\u24de", "\u24df", "\u24e0", "\u24e1", "\u24e2", "\u24e3", "\u24e4", "\u24e5", "\u24e6", "\u24e7", "\u24e8", "\u24e9", "\u24ea", "\u24eb", "\u24ec", "\u24ed", "\u24ee", "\u24ef", "\u24f0", "\u24f1", "\u24f2", "\u24f3", "\u24f4", "\u24f5", "\u24f6", "\u24f7", "\u24f8", "\u24f9", "\u24fa", "\u24fb", "\u24fc", "\u24fd", "\u24fe", "\u24ff"],
            },
            "Dingbats": {
                "chars": ["\u2701", "\u2702", "\u2703", "\u2704", "\u2706", "\u2707", "\u2708", "\u2709", "\u270c", "\u270d", "\u270e", "\u270f", "\u2710", "\u2711", "\u2712", "\u2713", "\u2714", "\u2715", "\u2716", "\u2717", "\u2718", "\u2719", "\u271a", "\u271b", "\u271c", "\u271d", "\u271e", "\u271f", "\u2720", "\u2721", "\u2722", "\u2723", "\u2724", "\u2725", "\u2726", "\u2727", "\u2729", "\u272a", "\u272b", "\u272c", "\u2730", "\u2731", "\u2732", "\u2733", "\u2734", "\u2735", "\u2736", "\u2737", "\u2738", "\u2739", "\u273a", "\u273b", "\u273c", "\u273d", "\u273e", "\u273f", "\u2740", "\u2741", "\u2742", "\u2743", "\u2744", "\u2745", "\u2746", "\u2747", "\u2748", "\u2749", "\u274a", "\u274b", "\u274d", "\u274f", "\u2750", "\u2751", "\u2752", "\u2756", "\u2758", "\u2759", "\u275a", "\u275b", "\u275c", "\u275d", "\u275e", "\u2761", "\u2762", "\u2763", "\u2764", "\u2765", "\u2766", "\u2767", "\u2768", "\u2769", "\u276a", "\u276b", "\u276c", "\u276d", "\u276e", "\u276f", "\u2770", "\u2771", "\u2772", "\u2773", "\u2774", "\u2775", "\u2776", "\u2777", "\u2778", "\u2779", "\u277a", "\u277b", "\u277c", "\u277d", "\u277e", "\u277f", "\u2780", "\u2781", "\u2782", "\u2783", "\u2784", "\u2785", "\u2786", "\u2787", "\u2788", "\u2789", "\u278a", "\u278b", "\u278c", "\u278d", "\u278e", "\u278f", "\u2790", "\u2791", "\u2792", "\u2793", "\u2794", "\u2798", "\u2799", "\u279a", "\u279b", "\u279c", "\u279d", "\u279e", "\u279f", "\u27a0", "\u27a1", "\u27a2", "\u27a3", "\u27a4", "\u27a5", "\u27a6", "\u27a7", "\u27a8", "\u27a9", "\u27aa", "\u27ab", "\u27ac", "\u27ad", "\u27ae", "\u27af", "\u27b1", "\u27b2", "\u27b3", "\u27b4", "\u27b5", "\u27b6", "\u27b7", "\u27b8", "\u27b9", "\u27ba", "\u27bb", "\u27bc", "\u27bd", "\u27be", "\u27bf"],
            }
        };

        this.editor.loadLanguage(this.plugin_name);

        var self = this;
        this.editor.options["custom_buttons"]["specials-characters"] = {
            "dialog": self.installDialog,
            "image": self.editor.options['images_path'] + "specials-characters.gif",
            "title": self._(self.plugin_name),
            "plugin": self
        };

        //this.loadLanguage();
    };

    weEdSpecialsCharacters.prototype.updateTable = function($button, $list) {
        var self = $button.plugin;

        var name = $list['selector'].children(':selected').val();
        if (self.characters[name]) {
            var $tbody = jQuery.createElement('tbody');
            $list['table'].html('').append($tbody);

            var length = self.characters[name]['chars'].length;
            var index = 0;
            var max_col = 16;
            while (index < length) {
                var $tr = jQuery.createElement('tr');
                $tbody.append($tr);

                for (var i = 0; i < max_col && index < length; i++) {
                    var $td = jQuery.createElement('td', { "text": self.characters[name]['chars'][index], "style": "background-color: #fff; border: solid 1px #000; cursor: pointer;" })
                                .bind('mouseover', function(e) {
                                    var chr = jQuery(this).text();
                                    $list['char_big'].html(chr);
                                    $list['char_small'].html(chr);

                                    var char_code = chr.charCodeAt(0);
                                    var unicode_char_code = char_code.toString(16);
                                    $list['char_code'].html('\\u' + unicode_char_code + '<br />&amp;#' + char_code + ';');
                                    jQuery(this).css('border-width', '2px');

                                })
                                .bind('mouseout', function(e) {
                                    $list['char_big'].html('');
                                    $list['char_small'].html('');
                                    $list['char_code'].html('');
                                    jQuery(this).css('border-width', '1px');
                                })
                                .bind('click', function(e) {
                                    $button.weed.execCommand('inserthtml', jQuery(this).html());
                                });
                    $tr.append($td);
                    index++;
                }

                if (index >= length && (index % max_col)) {
                    for (var i = (index % max_col); i < max_col; i++)
                        $tr.append(jQuery.createElement('td', { "style": "background-color: #ebebeb; border: solid 1px #ebebeb;", "text": "\xA0" }));
                }
            }
        }
    };

    weEdSpecialsCharacters.prototype.installDialog = function($button) {
        var self = $button.plugin;

        if (!$button.$dialog) {

            var $list = { "selector": null, "table": null, "char_big": null, "char_small": null, "char_code": null };

            // make character plage selector
            $list['selector'] = jQuery.createElement('select', { "id": "weed-special-characters-plage" });
            jQuery.each(self.characters, function(subset, char_list) {
                var $option = jQuery.createElement('option', { "value": subset, "text": self._(subset) });
                $list['selector'].append($option);
            });
            $list['selector'].bind('change.weed-special-characters', function(e) {
                self.updateTable($button, $list);
            });

            var $p_select = jQuery.createElement('p')
                                .append(jQuery.createElement('label', { "for": "weed-special-characters-plage", "text": self._('Subset') + " : "}), $list['selector']);

            var $div_chars = jQuery.createElement('div', { "style": "border: 1px solid #999; padding-top: 2px" });
            var $div_table = jQuery.createElement('div', { "style": "height: 100px; overflow: auto;" });
            $list['table'] = jQuery.createElement('table', { "style": "border: 0; border-collapse: collapse; " +
                                                          "margin-bottom: 5px; margin-left: auto; margin-right: auto; padding: 5px; text-align: center; width: 100%" });
            $div_chars.append($div_table.append($list['table']));

            var $div_display_chars = jQuery.createElement('div', { "style": "height: 40px; width: 350px; margin: 5px;" });
            $list['char_big'] = jQuery.createElement('div', { "style": "background-color: #fff; border: 1px solid #000; height: 30px; width: 30px; padding: 5px; font-size: 20px; text-align: center; float: left;" });
            $list['char_small'] = jQuery.createElement('div', { "style": "background-color: #fff; border: 1px solid #000; height: 20px; width: 25px; padding-top: 5px; margin-top: 5px; margin-left: 5px; font-size: 10px; text-align: center; float: left;" });
            $list['char_code'] = jQuery.createElement('div', { "style": "float: right;" });
            $div_display_chars.append($list['char_big'], $list['char_small'], $list['char_code']);

            var $div = jQuery.createElement('div');
            $div.append($p_select, $div_chars, $div_display_chars);
            $button.dialog.setBody($div);

            $button.dialog.addButtons({ "cancel": {} });

            $button.dialog.update(function($button) {
                $list['selector'].children(':first').attr('selected', 'selected');
                self.updateTable($button, $list);
            });

            var hide = $button.dialog.hide;
            $button.dialog.hide = function() {
                $list['table'].html('');
                return hide.apply($button);
            };

            $button.dialog.build();
            $button.dialog.hide_auto_clear = false;

        }
    };

    weEdSpecialsCharacters.prototype._ = function(key) {
        return this.editor._(key, this.plugin_name);
    };
}