/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
http://api.jquery.com/contents/
$('.container').contents().filter(function() {
  return this.nodeType == 3;
})
  .wrap('<p></p>')
.end()
.filter('br')
  .remove();


word copy cleaner : http://ethilien.net/websoft/wordcleaner/cleaner.htm
html beautifier : http://www.davidpirek.com/blog/html-beautifier-jquery-plugin
*/
if (undefined === weEdTextToParagraph) {
    var weEdTextToParagraph = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'text_to_paragraph';

        var self = this;

        // install callbacks
        this.editor.bind('toggle.text_to_paragraph', function() {
            if (this.is_wysiwyg_mode) {
                self.textToParagraph(this.$body);
                this.focus();
            }
        });

        this.editor.bind('execCommand.text_to_paragraph', function() {
            self.textToParagraph(this.$body);
            this.focus();
        });
    };

    weEdTextToParagraph.prototype.hasParent = function($obj, parents) {
        var found = false;
        $obj.parents().andSelf().each(function() {
            if (jQuery.inArray($(this)[0].nodeName.toLowerCase(), parents) != -1) {
                found = true;
                return false;
            }
        });
        return found;
    };

    weEdTextToParagraph.prototype.init = function() {
        var self = this;
        this.editor.$doc.keyup(function(evt) {
            var chr = evt.keyCode;

            if (chr == 13 && evt.shiftKey) {
                self.editor.execCommand('InsertLineBreak');
            }
            if ((chr <= 16 || (chr > 16 && chr < 32) || (chr > 32 && chr < 41) || chr == 46) || (-1 != jQuery.inArray(chr, [8, 13, 33, 34, 35, 36, 37, 38, 39, 40]))) return ;

            var node = self.editor.getSelectedNode();

            if (node) {
                self.textToParagraph(jQuery(node));
            }
        });
    };

    weEdTextToParagraph.prototype.textToParagraph = function(el, clean_br) {
        var self = this;
        clean_br = clean_br || false;
        var blocks_containers = ['address', 'blockquote', 'div', 'dl', 'fieldset', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'hr',
                                 'noscript', 'ol', 'p', 'pre', 'table', 'ul', 'dd', 'dt', 'li', 'tbody', 'td', 'tfoot', 'th', 'thead', 'tr'];
        var auto_closed = ["br", "img", "input"];

        var $focus_to = null;
        var new_p = [[]];

        jQuery(el).contents().filter(function() {
            var $this = jQuery(this);
            if (this.nodeType && this.nodeType == 3 && ! jQuery.trim($this.text()).length) {
                return false;
            }
            if (self.hasParent($this, blocks_containers)) {
                new_p.push([]);
                return false;
            }
            if (self.hasParent($this, auto_closed)) {
                new_p[new_p.length - 1].push($this);
                return false;
            }
            //if (!$focus_to) $focus_to = $this;
            new_p[new_p.length - 1].push($this);
            return true;
        });

        for (var i in new_p) {
            var list_p = new_p[i];
            if (list_p.length) {
                $focus_to = jQuery.createElement('p');
                list_p[0].before($focus_to);
                for (var ii in list_p)
                    $focus_to.append(list_p[ii]);
            }
        }

        if ($focus_to) self.editor.focusToNode($focus_to[0], true);
    };
}