/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdUndoRedo) {
    var weEdUndoRedo = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'undo_redo';

        this.undo_buffer = [];
        this.redo_buffer = [];
        this.buffer = null;

        this.exec_push = true;
        this.max_buffer = 50;

        this.$bt_undo = null;
        this.$bt_redo = null;

        // install buttons
        var self = this;
        this.editor.options.custom_buttons['undo'] = { "command": self.execUndo, "type": "no-toggle", "plugin": self };
        this.editor.options.custom_buttons['redo'] = { "command": self.execRedo, "type": "no-toggle", "plugin": self };
    };

    weEdUndoRedo.prototype.init = function() {
        var self = this;

        this.$bt_undo = this.editor.toolbar_buttons['undo'];
        this.$bt_redo = this.editor.toolbar_buttons['redo'];

        // install callbacks
        this.installBufferEvents();

        this.switchButtons();

        this.editor.$doc
            .bind('keydown.undo', function(e) { self.editor.trigger('updateIFrame.pre.undo_redo'); })
            .bind('keyup.undo', function(e) { self.editor.trigger('updateIFrame.post.undo_redo'); });

        this.editor.bind('toggle.post.undo_redo', function() {
            if (this.is_wysiwyg_mode) self.switchButtons();
            else {
                self.$bt_undo.enable(false);
                self.$bt_redo.enable(false);
            }
        });
    };

    weEdUndoRedo.prototype.installBufferEvents = function() {
        var self = this;

        this.editor.bind('updateIFrame.pre.undo_redo execCommand.pre.undo_redo', function() {
            self.buffer = self.editor.$body.html();
        });

        this.editor.bind('updateIFrame.post.undo_redo execCommand.post.undo_redo', function() {
            self.pushBuffer(1, true);
        });
    };

    weEdUndoRedo.prototype.switchButtons = function() {
        if (!this.undo_buffer.length) this.$bt_undo.enable(false);
        else if (!this.$bt_undo.enable()) this.$bt_undo.enable(true);

        if (!this.redo_buffer.length) this.$bt_redo.enable(false);
        else if (!this.$bt_redo.enable()) this.$bt_redo.enable(true);
    };

    weEdUndoRedo.prototype.pushBuffer = function(order, clean_redo) {
        if (this.exec_push) {
            var buffer = (1 == order ? this.undo_buffer : this.redo_buffer);
            var current_html = this.editor.$body.html();
            var previous_html = (this.buffer ? this.buffer : (buffer.length ? buffer[buffer.length - 1] : current_html));

            if (current_html && current_html != previous_html) {
                if (1 == order && clean_redo) this.redo_buffer = [];
                buffer.push(previous_html);
                if (buffer.length > this.max_buffer) {
                    if (2 == order) buffer.shift();
                    else buffer.pop();
                }
                this.switchButtons();
            }
            this.buffer = null;
        }
    };

    weEdUndoRedo.prototype.execUndo = function($button) {
        var self = $button.plugin;
        if (self.undo_buffer.length) {
            var html = self.undo_buffer.pop();
            self.buffer = self.editor.$body.html();
            self.exec_push = false;

            self.updateIFrame(html);

            self.exec_push = true;
            self.pushBuffer(2);
            self.switchButtons();
        }
        self.editor.focus();
    };

    weEdUndoRedo.prototype.execRedo = function($button) {
        var self = $button.plugin;
        if (self.redo_buffer.length) {
            var html = self.redo_buffer.pop();
            self.buffer = self.editor.$body.html();
            self.exec_push = false;

            self.updateIFrame(html);

            self.exec_push = true;
            self.pushBuffer(1);
            self.switchButtons();
        }
        self.editor.focus();
    };

    weEdUndoRedo.prototype.updateIFrame = function(html) {
        this.editor.unbind('updateIFrame.pre.undo_redo execCommand.pre.undo_redo updateIFrame.post.undo_redo execCommand.post.undo_redo');
        this.editor.updateIFrame(html);
        this.installBufferEvents();
    };
}