/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

if (undefined === weEdXhtmlProperties) {
    var weEdXhtmlProperties = function(options, editor) {
        this.editor = editor;
        this.plugin_name = 'xhtml_properties';

        this.$selected_node = null;
        this.$selected_nodes = [];
        this.attributes = [];
        this.dialog_type = 1; // 1 : selector ; 2 : selected

        this.has_html_to_xhtml_plugin = false;

        this.$button = null;

        this.editor.loadLanguage(this.plugin_name);
        //this.editor.options.buttons += ',xhtml-properties';

        var self = this;
        this.editor.options["custom_buttons"]["xhtml-properties"] = {
            "css-style": { "background-position": "3px 3px" },
            "dialog": self.installDialog,
            "image": self.editor.options['images_path'] + "xhtml-properties.gif",
            "title": self._('Properties for xhtml elements'),
            "plugin": self
        };

        /*
         * ihm 0 -> text
         *     1 -> textarea
         *     2 -> select
         *     3 -> boolean
        */
        this.xhtml_attributes = { };
        this.xhtml_elements = { };
    };

    weEdXhtmlProperties.DTD = {};

    weEdXhtmlProperties.prototype.init = function() {
        var self = this;
        this.has_html_to_xhtml_plugin = this.editor.hasPlugin('html_to_xhtml');
        this.$button = this.editor.toolbar_buttons['xhtml-properties'];

        if (this.editor.hasPlugin('context_menu')) {
            this.editor.addContextMenuSeparator();
            this.editor.addContextMenuItem('xhtml-properties', self._('Edit properties for...'));

            this.editor.bind('showContextMenu.pre.xhtml-properties', function() {
                var $selected_node = jQuery(this.getSelectedNode());

                self.$selected_node = null;
                self.$selected_nodes = [];
                self_dialog_type = 0;

                if (!$selected_node[0] || 'body' == $selected_node[0].nodeName.toLowerCase()) {
                    this.setContextMenuItemVisible('xhtml-properties', false);
                    return vars;
                }

                this.setContextMenuItemVisible('xhtml-properties', true);
                this.removeContextMenuItemByExpr(/xhtml-properties-./);
                self.addContextMenu($selected_node, self.$button);
            });
        }
    };

    weEdXhtmlProperties.prototype.addContextMenu = function($selected_node, $button) {
        var self = this;
        var $node = $selected_node;
        var node_name = $node[0].nodeName.toLowerCase();

        function to_menu($node, index) {
            var node_name = self.getNodeName($node);
            self.$selected_nodes.push($node);
            var $li = self.editor.addContextMenuItem('xhtml-properties-' + index, node_name, function() {
                self.$selected_node = $node;
                $button.click();

                self.clearClasses();
                $button.dialog.setTabLabel(self._('Properties for') + ' "' + self.getNodeName($node) + '"', 1);
                self.installDialogProperties($button, $node);

                $button.dialog.$tabs[1].click();
            }, 'xhtml-properties');

            if ($li) {
                $li
                .bind('mouseover.xhtml-properties', function() {
                    self.editor.emphasisNode($node, true);
                })
                .bind('mouseout.xhtml-properties', function() {
                    self.editor.emphasisNode($node, false);
                })
            }
        }

        to_menu($node, 0);

        $node.parents().each(function(index) {
            var node_name = self.getNodeName(jQuery(this));
            if ('body' == node_name || 'html' == node_name) return;
            to_menu(jQuery(this), (index + 1));
        });
    };

    weEdXhtmlProperties.prototype.installDialog = function($button) {
        var self = $button.plugin;

        if (undefined === weEdXhtmlProperties.DTD[self.editor.options['doctype']]) {
            self.editor.loadJs(self.editor.options['plugins_path'] + 'xhtml_properties_dtd/' + self.editor.options['doctype'] + '.js');
        }

        self.xhtml_attributes = weEdXhtmlProperties.DTD[self.editor.options['doctype']]["attributes"];
        self.xhtml_elements = weEdXhtmlProperties.DTD[self.editor.options['doctype']]["elements"];

        $button.dialog.clearErrors();

        self.installDialogSelector($button);

        $button.dialog.build();
        $button.dialog.hide_auto_clear = true;

        if ($button.dialog.errors.length) $button.dialog.displayErrors();
    };

    weEdXhtmlProperties.prototype.getNodeName = function($node) {
        var node_name = $node[0].nodeName.toLowerCase();
        if (this.has_html_to_xhtml_plugin) {
            if ('u' == node_name || 's' == node_name || 'strike' == node_name) node_name = 'span';
            else if ('b' == node_name) node_name = 'strong';
            else if ('i' == node_name) node_name = 'em';
        }
        return node_name;
    };

    weEdXhtmlProperties.prototype.clearClasses = function() {
        for (var i in this.$selected_nodes) {
            this.editor.emphasisNode(this.$selected_nodes[i], false);
        }
    };

    weEdXhtmlProperties.prototype.installDialogSelector = function($button) {
        var self = $button.plugin;
        var $node = jQuery($button.weed.getSelectedNode());

        self.$selected_node = null;
        self.$selected_nodes = [];

        if ('body' == $node[0].nodeName.toLowerCase()) {
            $button.dialog.errors.push(self._('No object'));
            $button.dialog.addButtons({"cancel": {}});
            return ;
        }

        var $ul = jQuery.createElement('ul').addClass('weed-selector-list');

        add_to_list($node, 0);
        $node.parents().each(function(index) {
            add_to_list(jQuery(this), (index + 1));
        });

        function add_to_list($node, index) {
            var node_name = self.getNodeName($node);

            if ('body' == node_name || 'html' == node_name) return '';

            self.$selected_nodes.push($node);

            var $li = jQuery.createElement('li').attr('id', 'weed-xhtml-properties-nodes-' + index).text(node_name)
            .bind('click.xhtml-properties', function(e) {
                if (!jQuery(this).hasClass('selected')) {
                    self.$selected_node = self.$selected_nodes[index];
                    self.clearClasses();

                    $button.dialog.setTabLabel(self._('Properties for') + ' "' + self.getNodeName(self.$selected_node) + '"', 1);

                    self.installDialogProperties($button);
                    $button.dialog.$tabs[1].click();

                    $ul.children('.selected').removeClass('selected');
                    jQuery(this).addClass('selected');
                }
                else
                    $button.dialog.$tabs[1].click();
            })
            .bind('mouseover.xhtml-properties', function(e) {
                self.clearClasses();
                if (index >= self.$selected_nodes.length) return ;
                self.editor.emphasisNode(self.$selected_nodes[index], true);
            })
            .bind('mouseout.xhtml-properties', function(e) {
                if (index >= self.$selected_nodes.length) return ;
                self.editor.emphasisNode(self.$selected_nodes[index], false);
            });

            if (self.$selected_node && self.$selected_node[0] == $node[0] && !$li.hasClass('selected')) {
                $li.addClass('selected');
            }

            $ul.append($li);
        }

        $button.dialog.addTab(self._('Element'), $ul);

        var $div_properties = jQuery.createElement('div');
        $div_properties.dialog = $button.weed.getDialogInstance($div_properties);
        $button.dialog.addTab(self._('Properties'), $div_properties);
        $button.dialog.$tabs[1].addClass('disabled');

        /* preserve click.dialog */
        $button.dialog.$tabs[1]._click = null;

        if (jQuery._data($button.dialog.$tabs[1][0], 'events').click) {
            jQuery.each(jQuery._data($button.dialog.$tabs[1][0], 'events').click, function(index, object) {
                if ('dialog' == object.namespace)
                    $button.dialog.$tabs[1]._click = object.handler;
            });
        }
        $button.dialog.$tabs[1].unbind('click.dialog');

        var hide = $button.dialog.hide;
        $button.dialog.hide = function() {
            self.$selected_nodes = [];
            self.$selected_node = null;
            return hide.apply($button);
        };
    };

    weEdXhtmlProperties.prototype.installDialogProperties = function($button, $node) {
        var self = $button.plugin;

        if (!self.$selected_node && $node)
            self.$selected_node = $node;

        if (self.$selected_node[0]) {
            self.attributes = [];
            var $div_properties = $button.dialog.$body[1];

            $div_properties.html('');
            $button.dialog.$tabs[1].removeClass('disabled');

            if ($button.dialog.$tabs[1]._click)
                $button.dialog.$tabs[1].bind('click.dialog', $button.dialog.$tabs[1]._click);

            $div_properties.dialog.init();

            var node_name = self.getNodeName(self.$selected_node);
            if (self.xhtml_elements[node_name]) {
                var elt_properties = self.xhtml_elements[node_name];
                var $input_list = {};
                jQuery.each(elt_properties, function(part_name, part_values) {
                    var key = part_name.toLowerCase().replace(/\s/g, '-');

                    var $div_body = jQuery.createElement('div');

                    jQuery.each(part_values, function(value_name, value_attr) {
                        var att_properties = self.xhtml_attributes[value_name][value_attr];
                        var ihm_type = att_properties['ihm'] || 0;
                        var ihm_class = (att_properties['small'] && att_properties['small'] ? 'weed-dialog-input-small' : 'weed-dialog-input-long');
                        var name = value_name.replace(':', '-');
                        self.attributes.push([value_name, value_attr]);


                        var $p_body = jQuery.createElement('p').append(jQuery.createElement('label', { "text": value_name + ' : ' }));
                        switch (ihm_type) {
                            case 0:
                                $input_list[name] = jQuery.createElement('input', { "type": "text", "class": ihm_class });
                                $p_body.append($input_list[name]);
                                break;

                            case 1:
                                $input_list[name] = jQuery.createElement('textarea', { "class": ihm_class });
                                $p_body.append($input_list[name]);
                                break;

                            case 2:
                                var list = att_properties['values'].split('|');
                                var $select = jQuery.createElement('select');
                                jQuery.each(list, function(index, e_name) {
                                    e_name = e_name.replace(':', '-');
                                    $select.append(jQuery.createElement('option').val(e_name).text(e_name));
                                });
                                $input_list[name] = $select;
                                $p_body.append($select);
                                break;

                            case 3:
                                $input_list[name] = jQuery.createElement('input', { "type": "checkbox" }).val(value_name);
                                $p_body.append($input_list[name]);
                                break;
                        }
                        $div_body.hide().append($p_body);
                    });
                    $div_properties.dialog.addTab(self._(part_name), $div_body);
                });

                function manage_input($input_list) {
                    for (var i in $input_list) $input_list[i].closest('p').show();
                    switch ($input_list['type'].val()) {
                        case 'text':
                        case 'password':
                            $input_list['checked'].closest('p').hide();
                            $input_list['src'].closest('p').hide();
                            $input_list['usemap'].closest('p').hide();
                            break;

                        case 'checkbox':
                        case 'radio':
                            $input_list['maxlength'].closest('p').hide();
                            $input_list['src'].closest('p').hide();
                            $input_list['usemap'].closest('p').hide();
                            $input_list['readonly'].closest('p').hide();
                            break;

                        case 'button':
                        case 'reset':
                        case 'submit':
                        case 'file':
                        case 'hidden':
                            $input_list['checked'].closest('p').hide();
                            $input_list['src'].closest('p').hide();
                            $input_list['maxlength'].closest('p').hide();
                            $input_list['usemap'].closest('p').hide();
                            $input_list['readonly'].closest('p').hide();
                            break;

                        case 'image':
                            $input_list['checked'].closest('p').hide();
                            $input_list['maxlength'].closest('p').hide();
                            $input_list['readonly'].closest('p').hide();
                            break;
                    }
                }
                if ('input' == node_name) {
                    $input_list['type'].change(function() { manage_input($input_list); });
                    manage_input($input_list);
                }

                $div_properties.dialog.addButtons({
                    "ok": {
                        "callback": function($obj) {
                            //if (self.editor.beforeUpdateHtml) self.editor.beforeUpdateHtml();
                            $obj.dialog.clearErrors();

                            self.editor.addCommand('xhtmlProperties', function() {
                                jQuery.each(self.attributes, function(index, value) {
                                    var name = value[0];
                                    var _name = name.replace(':', '-');
                                    var attr_index = value[1];
                                    var init_val = self.$selected_node.attr(name) || '';
                                    var $elt = $input_list[_name];
                                    var user_val = jQuery.trim($elt.val());

                                    if ('checkbox' == $elt.attr('type')) {
                                        user_val = $elt.attr('checked') ? name : '';
                                    }

                                    if (init_val != user_val) {
                                        if ('' != user_val && self.xhtml_attributes[name][attr_index]['validate'] && (!(user_val.match(self.xhtml_attributes[name][attr_index]['validate'])))) {
                                            $div_properties.dialog.errors.push({ "error": self._('Value error for') + ' : "' + name + '"', "element": $elt.parent() });
                                            return ;
                                        }
                                        if ('' == user_val) self.$selected_node.removeAttr(name);
                                        else self.$selected_node.attr(name, user_val);
                                    }
                                });
                            });
                            self.editor.execCommand('xhtmlProperties');

                            if ($div_properties.dialog.errors.length) {
                                $div_properties.dialog.displayErrors();
                                return ;
                            }

                            $button.dialog.hide();

                            //if (self.editor.afterUpdateHtml) self.editor.afterUpdateHtml();
                        }
                    },
                    "cancel": {
                        "callback": function($obj) {
                            $button.dialog.$tabs[0].click();
                            /* preserve click.dialog */
                            $button.dialog.$tabs[1]._click = null;
                            if ($button.dialog.$tabs[1].data('events').click) {
                                jQuery.each($button.dialog.$tabs[1].data('events').click, function(index, object) {
                                    if ('dialog' == object.namespace)
                                        $button.dialog.$tabs[1]._click = object.handler;
                                });
                            }
                            $button.dialog.$tabs[1].unbind('click.dialog').addClass('disabled');
                            $button.dialog.$body[0].find('li.selected').removeClass('selected');
                            $button.dialog.setTabLabel(self._('Properties'), 1);
                        }
                    }
                });

                $div_properties.dialog.update(function($div_properties) {
                    $div_properties.dialog.clearErrors();
                    if (self.$selected_node[0]) {
                        jQuery.each(self.attributes, function(index, value) {
                            var name = value[0];
                            var _name = name.replace(':', '-');
                            var val = self.$selected_node.attr(name) || '';
                            var $elt = $input_list[_name];

                            if ('checkbox' == $elt.attr('type') && (val || val == name)) {
                                $elt.attr('checked', 'checked');
                            }
                            else {
                                $elt.val(val);
                            }
                        });
                    };
                });

                $div_properties.dialog.build();
                $div_properties.append($div_properties.$dialog.css('border', 'none'));
                $div_properties.dialog.$tabs[0].click();
            }
            else {
                $div_properties.dialog.erros.push(self._('No properties'));
                $div_properties.displayErrors();
                $div_properties.dialog.build();
                $div_properties.append($div_properties.$dialog.css('border', 'none'));
            }
            $div_properties.dialog.is_updated = false;
            $div_properties.dialog.show = function() {
                this.update();
                if (this.display_tab >= 0 && this.display_tab < this.$tabs.length) {
                    for (var i in this.$body) this.$body[i].hide();
                    this.$tabs[this.display_tab].click();
                }
                this.$element.$dialog.show(150);
                return this;
            };
            $div_properties.dialog.hide = function() {
                this.$element.$dialog.hide(150);
                this.is_updated = false;
                if (this.hide_auto_clear) {
                    this.init();
                    this.$element.$dialog = null;
                }
                return this;
            };
            $div_properties.dialog.show();
        }
    };

    weEdXhtmlProperties.prototype._ = function(key) {
        return this.editor._(key, this.plugin_name);
    };
}