/*
 * Copyright 2012 Sébastien Raud
 *
 * This file is part of beCms.
 *
 * beCms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * beCms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with beCms.  If not, see <http://www.gnu.org/licenses/>.
 */

weEdXhtmlProperties.DTD["xhtml-1.0-strict"] = {
    "attributes": {
      "abbr": [{  }],
      "accept": [{  }],
      "accept-charset": [{  }],
      "accesskey": [{ "small": true  }],
      "action": [{  }],
      "align": [{ "ihm": 2, "values": "|left|center|right|justify|char", "validate": /^(left|center|right|justify|char)$/ }],
      "alt": [{  }],
      "archive": [{  }],
      "axis": [{  }],
      "border": [{ "validate": /^\d+$/, "small": true }],
      "cellpadding": [{ "validate": /^[+\-]?\d+(%|px)?$/, "small": true }],
      "cellspacing": [{ "validate": /^[+\-]?\d+(%|px)?$/, "small": true }],
      "char": [{  }],
      "charoff": [{ "validate": /^[+\-]?\d+(%|px)?$/, "small": true }],
      "charset": [{  }],
      "checked": [{ "ihm": 3 }],
      "cite": [{  }],
      "class": [{  }],
      "classid": [{  }],
      "codebase": [{  }],
      "codetype": [{  }],
      "cols": [{ "validate": /^\d+$/, "small": true }],
      "colspan": [{ "validate": /^\d+$/, "small": true }],
      "content": [{  }],
      "coords": [{  }],
      "data": [{  }],
      "datetime": [{ "validate": /^(\d{4})\D?(0[1-9]|1[0-2])\D?([12]\d|0[1-9]|3[01])(\D?([01]\d|2[0-3])\D?([0-5]\d)\D?([0-5]\d)?\D?(\d{3})?([zZ]|([\+-])([01]\d|2[0-3])\D?([0-5]\d)?)?)?$/ }],
      "declare": [{  }],
      "dir": [{ "ihm": 2, "values": "|ltr|rlt", "validate": /^(ltr|rlt)$/i }],
      "disabled": [{ "ihm": 3 }],
      "enctype": [{  }],
      "for": [{ "validate": /^[a-z]([a-z0-9\-_\:\.]+)?$/i }],
      "frame": [{ "validate": /^(void|above|below|hsides|lhs|rhs|vsides|box|border)$/i }],
      "headers": [{ "validate": /^([a-z]([a-z0-9\-_\:\.]+)?(\s*,\s*)?)+$/i }],
      "height": [{ "validate": /^[+\-]?\d+(%|px)?$/, "small": true }],
      "href": [{  }],
      "hreflang": [{ "validate": /^[a-z]{1,2}(-[a-z]+)?$/i }],
      "id": [{ "validate": /^[a-z]([a-z0-9\-_\:\.]+)?$/i }],
      "ismap": [{ "ihm": 3 }],
      "label": [{  }],
      "lang": [{ "validate": /^[a-z]{1,2}(-[a-z]+)?$/i, "small": true }],
      "longdesc": [{ "ihm": 1 }],
      "maxlength": [{ "small": true }],
      "method": [{  }],
      "multiple": [{ "ihm": 3 }],
      "name": [{  }],
      "nohref": [{ "ihm": 3 }],
      "readonly": [{ "ihm": 3 }],
      "rel": [{ "validate": /^(\w+| )+$/i }],
      "rev": [{ "validate": /^(\w+| )+$/i }],
      "rows": [{ "validate": /^\d+$/, "small": true }],
      "rowspan": [{ "validate": /^\d+$/, "small": true }],
      "rules": [{ "ihm": 2, "values": "|none|groups|rows|cols|all", "validate": /^(none|groups|rows|cols|all)$/i }],
      "scope": [{ "ihm": 2, "values": "|row|col|rowgroup|colgroup", "validate": /^(row|col|rowgroup|colgroup)$/i }],
      "selected": [{ "ihm": 3 }],
      "shape": [{ "ihm": 2, "values": "|rect|circle|poly|default", "validate": /^(rect|circle|poly|default)$/i }],
      "size": [{ "small": true }],
      "span": [{  }],
      "src": [{  }],
      "standby": [{  }],
      "style": [{  }],
      "summary": [{  }],
      "tabindex": [{ "small": true }],
      "title": [{  }],
      "type": [{  }, { "ihm": 2, "values": "text|password|checkbox|radio|submit|reset|file|hidden|image|button", "validate": /^(text|password|checkbox|radio|submit|reset|file|hidden|image|button)$/ }],
      "usemap": [{  }],
      "valign": [{ "ihm": 2, "values": "|top|middle|bottom|baseline", "validate": /^(top|middle|bottom|baseline)$/i }],
      "value": [{  }],
      "valuetype": [{  }],
      "width": [{ "validate": /^[+\-]?\d+(%|px)?$/, "small": true }, { "validate": /^([+\-]?(\d*\.)?\d+(%|px)?(\s*,\s*)?)+$/ }],
      "xml:lang": [{ "validate": /^[a-z]{1,2}(-[a-z]+)?$/i, "small": true }],
      "xml:space": [{ }]
    },
    "elements": {
        "div": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "p": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "h1": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "h2": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "h3": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "h4": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "h5": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "h6": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "ul": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "ol": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "li": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "dl": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "dt": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "dd": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "address": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "hr": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "pre": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Formatting": {
                "xml:space": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "blockquote": {
            "Generals": {
                "id": 0, "title": 0, "cite": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "ins": {
            "Generals": {
                "id": 0, "title": 0, "cite": 0, "class": 0, "style": 0, "datetime": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "del": {
            "Generals": {
                "id": 0, "title": 0, "cite": 0, "class": 0, "style": 0, "datetime": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "a": {
            "Generals": {
                "id": 0, "href": 0, "title": 0, "name": 0, "class": 0, "style": 0
            },
            "Relations": {
                "rel": 0, "rev": 0, "type": 0
            },
            "Accessibility": {
                "accesskey": 0, "tabindex": 0
            },
            "Image relation": {
                "coords": 0, "shape": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0, "charset": 0, "hreflang": 0
            }
        },
        "span": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "bdo": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "br": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            }
        },
        "em": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "strong": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "dfn": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "code": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "samp": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "kbd": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "var": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "cite": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "abbr": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "acronym": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "q": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0, "cite": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "sub": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "sup": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "tt": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "i": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "b": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "big": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "small": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "object": {
            "Generals": {
                "id": 0, "title": 0, "name": 0, "classid": 0, "codebase": 0, "data": 0, "class": 0, "style": 0
            },
            "Dimensions": {
                "height": 0, "width": 0
            },
            "Others": {
                "archive": 0, "declare": 0, "standby": 0
            },
            "Accessibility": {
                "tabindex": 0
            },
            "Image relation": {
                "usemap": 0
            },
            "Relations": {
                "codetype": 0, "type": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "param": {
            "Generals": {
                "id": 0, "name": 0, "value": 0, "valuetype": 0
            },
            "Relations": {
                "type": 0
            }
        },
        "img": {
            "Generals": {
                "id": 0, "src": 0, "title": 0, "alt": 0, "longdesc": 0, "class": 0, "style": 0
            },
            "Dimensions": {
                "height": 0, "width": 0
            },
            "Others": {
                "ismap": 0, "usemap": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "map": {
            "Generals": {
                "id": 0, "title": 0, "name": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "area": {
            "Generals": {
                "id": 0, "href": 0, "nohref": 0, "title": 0, "alt": 0, "class": 0, "style": 0
            },
            "Accessibility": {
                "accesskey": 0, "tabindex": 0
            },
            "Image relation": {
                "coords": 0, "shape": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "form": {
            "Generals": {
                "id": 0, "action": 0, "method": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "accept": 0, "accept-charset": 0, "enctype": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "label": {
            "Generals": {
                "id": 0, "for": 0, "title": 0, "class": 0, "style": 0
            },
            "Accessibility": {
                "accesskey": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "input": {
            "Generals": {
                "id": 0, "type": 1, "value": 0, "checked": 0, "src": 0, "title": 0, "name": 0, "alt": 0, "class": 0, "style": 0, "accept": 0, "disabled": 0, "maxlength": 0, "readonly": 0, "size": 0, "usemap": 0
            },
            "Accessibility": {
                "accesskey": 0, "tabindex": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "select": {
            "Generals": {
                "id": 0, "title": 0, "name": 0, "class": 0, "style": 0, "disabled": 0, "multiple": 0, "size": 0
            },
            "Accessibility": {
                "tabindex": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "optgroup": {
            "Generals": {
                "id": 0, "title": 0, "label": 0, "class": 0, "style": 0, "disabled": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "option": {
            "Generals": {
                "id": 0, "title": 0, "value": 0, "label": 0, "class": 0, "style": 0, "selected": 0, "disabled": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "textarea": {
            "Generals": {
                "id": 0, "name": 0, "title": 0, "class": 0, "style": 0, "cols": 0, "rows": 0, "readonly": 0, "disabled": 0
            },
            "Accessibility": {
                "accesskey": 0, "tabindex": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "fieldset": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "legend": {
            "accesskey": 0, "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "button": {
            "Generals": {
                "id": 0, "title": 0, "name": 0, "type": 0, "value": 0, "class": 0, "style": 0, "disabled": 0
            },
            "Accessibility": {
                "accesskey": 0, "tabindex": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "table": {
            "Generals": {
                "id": 0, "title": 0, "summary": 0, "class": 0, "style": 0
            },
            "Others": {
                "border": 0, "cellpadding": 0, "cellspacing": 0, "frame": 0, "rules": 0, "width": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "caption": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "thead": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "align": 0, "valign": 0, "char": 0, "charoff": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "tfoot": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "align": 0, "valign": 0, "char": 0, "charoff": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "tbody": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "align": 0, "valign": 0, "char": 0, "charoff": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "colgroup": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "align": 0, "valign": 0, "char": 0, "charoff": 0, "span": 0, "width": 1
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "col": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "align": 0, "valign": 0, "char": 0, "charoff": 0, "span": 0, "width": 1
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "tr": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "align": 0, "valign": 0, "char": 0, "charoff": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "th": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "char": 0, "charoff": 0, "colspan": 0, "rowspan": 0, "align": 0, "valign": 0, "scope": 0, "abbr": 0, "axis": 0, "headers": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        },
        "td": {
            "Generals": {
                "id": 0, "title": 0, "class": 0, "style": 0
            },
            "Others": {
                "char": 0, "charoff": 0, "colspan": 0, "rowspan": 0, "align": 0, "valign": 0, "scope": 0, "abbr": 0, "axis": 0, "headers": 0
            },
            "Internationalization": {
                "dir": 0, "lang": 0, "xml:lang": 0
            }
        }
    }
};